package com.jowhjy.hidecoords.mixin;

import com.jowhjy.hidecoords.Hidecoords;
import com.jowhjy.hidecoords.Offset;
import com.jowhjy.hidecoords.util.HasCoordOffset;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8609;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin extends class_8609 implements HasCoordOffset {

    @Shadow public abstract class_3222 getPlayer();

    @Shadow private double lastTickX;
    @Unique
    Offset hidecoords$coordOffset;

    public ServerPlayNetworkHandlerMixin(MinecraftServer server, class_2535 connection, class_8792 clientData, double lastTickX) {
        super(server, connection, clientData);
        this.lastTickX = lastTickX;
    }

    @Unique
    @Override
    public Offset hidecoords$getCoordOffset()
    {
        return hidecoords$coordOffset;
    }
    @Unique
    @Override
    public void hidecoords$setCoordOffset(Offset coordOffset, boolean resendData)
    {
        hidecoords$coordOffset = coordOffset;
        if (resendData) Hidecoords.resendDataAfterOffsetChange(this.getPlayer());
    }

    /** Inject into the constructor to make the offsetPacket
     */
    @Inject(method = "<init>", at = @At("TAIL"))
    public void hidecoords$createOffset(MinecraftServer server, class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci){

        hidecoords$coordOffset = Offset.zeroAtLocation(player.method_24515());

    }

    /*@Override
    public void send(Packet<?> packet, @Nullable PacketCallbacks callbacks)
    {
        //no offset if gamerule off
        if (!this.getPlayer().getServerWorld().getGameRules().getBoolean(Hidecoords.HIDECOORDS_GAMERULE)) {
            super.send(packet, callbacks);
            return;
        }

        Packet<?> newPacket = S2CPacketOffsetter.offsetPacket(packet, hidecoords$coordOffset, this.getPlayer().getWorld());
        if (PACKETS_WORLD_BORDER.contains(newPacket.getPacketType()))
        {
            newPacket = WorldBorderObfuscator.translate(newPacket, hidecoords$coordOffset,this.getPlayer());
        }

        super.send(newPacket, callbacks);
    }*/

}