package com.jowhjy.hidecoords;

import com.jowhjy.hidecoords.mixin.ChunkDeltaUpdateS2CPacketAccessor;
import com.jowhjy.hidecoords.util.HasAccessibleBlockPos;
import com.jowhjy.hidecoords.util.HasAccessibleChunkPos;
import com.jowhjy.hidecoords.util.IChunkDeltaUpdateS2CPacketMixin;
import com.jowhjy.hidecoords.util.OffsetableTrackedWaypoint;
import com.mojang.datafixers.util.Pair;
import eu.pb4.polymer.core.impl.interfaces.EntityAttachedPacket;
import eu.pb4.polymer.core.impl.interfaces.PossiblyInitialPacket;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_10182;
import net.minecraft.class_10264;
import net.minecraft.class_11173;
import net.minecraft.class_11200;
import net.minecraft.class_11982;
import net.minecraft.class_11983;
import net.minecraft.class_11986;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2620;
import net.minecraft.class_2622;
import net.minecraft.class_2623;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2649;
import net.minecraft.class_2653;
import net.minecraft.class_2664;
import net.minecraft.class_2666;
import net.minecraft.class_2672;
import net.minecraft.class_2673;
import net.minecraft.class_2675;
import net.minecraft.class_2676;
import net.minecraft.class_2678;
import net.minecraft.class_2692;
import net.minecraft.class_2693;
import net.minecraft.class_2707;
import net.minecraft.class_2708;
import net.minecraft.class_2709;
import net.minecraft.class_2724;
import net.minecraft.class_2739;
import net.minecraft.class_2744;
import net.minecraft.class_2759;
import net.minecraft.class_2767;
import net.minecraft.class_2777;
import net.minecraft.class_2941;
import net.minecraft.class_2945;
import net.minecraft.class_4076;
import net.minecraft.class_4208;
import net.minecraft.class_4282;
import net.minecraft.class_5217;
import net.minecraft.class_8042;
import net.minecraft.class_8212;
import net.minecraft.class_8589;
import net.minecraft.class_9094;
import net.minecraft.class_9145;
import net.minecraft.class_9276;
import net.minecraft.class_9291;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9834;
import net.minecraft.class_9835;
import net.minecraft.network.packet.s2c.play.*;
import net.minecraft.util.math.*;
import java.util.*;

public class S2CPacketOffsetter {



    public static <T extends class_2547> class_2596<?> offsetPacket(class_2596<T> packet, Offset offset, class_1937 world) {

        var newPacket = offsetPacketByType(packet, offset, world);
        if (FabricLoader.getInstance().isModLoaded("polymer-core")) {
            if (packet instanceof EntityAttachedPacket eap) {
                ((EntityAttachedPacket) newPacket).polymer$setEntity(eap.polymer$getEntity());
            }
            if (packet instanceof PossiblyInitialPacket pip && pip.polymer$getInitial())
            {
                ((PossiblyInitialPacket)newPacket).polymer$setInitial();
            }
        }
        return newPacket;
    }

    public static <T extends class_2547> class_2596<?> offsetPacketByType(class_2596<T> packet, Offset offset, class_1937 world) {

        class_9145<? extends class_2596<T>> packetType = packet.method_65080();
        //System.out.println(packetType);

        if (packetType.equals(class_9094.field_48039)) {
            class_8042 bundleS2CPacket = (class_8042) packet;
            ArrayList<class_2596<? super class_2602>> newSubpackets = new ArrayList<>();
            for (class_2596<? super class_2602> subpacket : bundleS2CPacket.method_48324()) {
                newSubpackets.add((class_2596<? super class_2602>) offsetPacket(subpacket, offset, world));
            }
            return new class_8042(newSubpackets);
        }
        if (packetType.equals(class_9094.field_48156)) {
            class_2626 typedPacket = (class_2626) packet;
            return new class_2626(offset(typedPacket.method_11309(), offset), typedPacket.method_11308());
        }
        if (packetType.equals(class_9094.field_48155)) {
            class_2623 typedPacket = (class_2623) packet;
            return new class_2623(offset(typedPacket.method_11298(), offset), typedPacket.method_11295(), typedPacket.method_11294(), typedPacket.method_11296());
        }
        if (packetType.equals(class_9094.field_48154)) {
            class_2622 typedPacket = (class_2622) packet;
            ((HasAccessibleBlockPos)typedPacket).hidecoords$setBlockPos(offset(typedPacket.method_11293(),offset));
            return typedPacket;
        }
        if (packetType.equals(class_9094.field_48153)) {
            class_2620 typedPacket = (class_2620) packet;
            return new class_2620(typedPacket.method_11280(), offset(typedPacket.method_11277(), offset), typedPacket.method_11278());
        }
        if (packetType.equals(class_9094.field_48145)) {
            class_2604 typedPacket = (class_2604) packet;
            double x = offsetX(typedPacket.method_11175(), offset);
            double y = typedPacket.method_11174();
            double z = offsetZ(typedPacket.method_11176(), offset);
            return new class_2604(typedPacket.method_11167(), typedPacket.method_11164(), x, y, z, typedPacket.method_11171(), typedPacket.method_11168(), typedPacket.method_11169(), typedPacket.method_11166(), typedPacket.method_73084(), typedPacket.method_43233());
        }
        if (packetType.equals(class_9094.field_48072)) {
            class_2708 typedPacket = (class_2708) packet;
            class_10182 oldPlayerPosition = typedPacket.comp_3228();
            class_243 oldPos = oldPlayerPosition.comp_3148();

            double x = typedPacket.comp_3229().contains(class_2709.field_12400) ? oldPos.field_1352 : offsetX(oldPos.field_1352, offset);
            double z = typedPacket.comp_3229().contains(class_2709.field_12403) ? oldPos.field_1350 : offsetZ(oldPos.field_1350, offset);

            class_243 newPos = new class_243(x, oldPos.field_1351, z);

            class_10182 newPlayerPosition = new class_10182(newPos, oldPlayerPosition.comp_3149(), oldPlayerPosition.comp_3150(), oldPlayerPosition.comp_3151());
            return new class_2708(typedPacket.comp_3133(), newPlayerPosition, typedPacket.comp_3229());
        }
        if (packetType.equals(class_9094.field_48064)) {
            class_2777 typedPacket = (class_2777) packet;
            class_10182 oldPlayerPosition = typedPacket.comp_3238();
            class_243 oldPos = oldPlayerPosition.comp_3148();

            double x = typedPacket.comp_3239().contains(class_2709.field_12400) ? oldPos.field_1352 : offsetX(oldPos.field_1352, offset);
            double z = typedPacket.comp_3239().contains(class_2709.field_12403) ? oldPos.field_1350 : offsetZ(oldPos.field_1350, offset);

            class_243 newPos = new class_243(x, oldPos.field_1351, z);

            class_10182 newPlayerPosition = new class_10182(newPos, oldPlayerPosition.comp_3149(), oldPlayerPosition.comp_3150(), oldPlayerPosition.comp_3151());
            return new class_2777(typedPacket.comp_3237(), newPlayerPosition, typedPacket.comp_3239(), typedPacket.comp_3240());
        }
        if (packetType.equals(class_9094.field_48071)) {
            class_2707 typedPacket = (class_2707) packet;
            class_243 targetPos = typedPacket.method_11732(world);
            if (targetPos == null) return packet;
            double x = offsetX(targetPos.method_10216(), offset);
            double y = targetPos.method_10214();
            double z = offsetZ(targetPos.method_10215(), offset);
            return new class_2707(typedPacket.method_11730(), x, y, z);
        }
        if (packetType.equals(class_9094.field_48161)) {
            class_8212 typedPacket = (class_8212) packet;
            List<class_8212.class_8213> data = typedPacket.comp_1313();
            ArrayList<class_8212.class_8213> newData = new ArrayList<>();
            for (class_8212.class_8213 serialized : data) {
                newData.add(new class_8212.class_8213(offset(serialized.comp_1314(), offset), serialized.comp_1315()));
            }
            return new class_8212(newData);
        }
        if (packetType.equals(class_9094.field_48016)) {
            class_2664 typedPacket = (class_2664) packet;
            return new class_2664(offset(typedPacket.comp_2883(),offset), typedPacket.comp_4594(), typedPacket.comp_4595(), typedPacket.comp_2884(), typedPacket.comp_2885(), typedPacket.comp_2886(), typedPacket.comp_4596());
        }
        if (packetType.equals(class_9094.field_48022)) {
            class_2672 typedPacket = (class_2672) packet;

            class_1923 chunkPos = new class_1923(typedPacket.method_11523(), typedPacket.method_11524());
            class_1923 newChunkPos = offset(chunkPos, offset);

            ((HasAccessibleChunkPos)typedPacket).hidecoords$setChunkX(newChunkPos.field_9181);
            ((HasAccessibleChunkPos)typedPacket).hidecoords$setChunkZ(newChunkPos.field_9180);

            return typedPacket;
        }
        if (packetType.equals(class_9094.field_48035)) {
            class_2693 typedPacket = (class_2693) packet;
            return new class_2693(offset(typedPacket.method_11677(), offset), typedPacket.method_49995());
        }
        if (packetType.equals(class_9094.field_48078)) {
            class_2637 typedPacket = (class_2637) packet;
            class_4076 oldSectionPos = ((ChunkDeltaUpdateS2CPacketAccessor)typedPacket).getSectionPos();
            class_4076 newSectionPos = class_4076.method_18681(offset(oldSectionPos.method_18692(), offset), oldSectionPos.method_18683());
            return new class_2637(newSectionPos, ((IChunkDeltaUpdateS2CPacketMixin)typedPacket).hideCoordinates$getRememberedPositions(), ((IChunkDeltaUpdateS2CPacketMixin)typedPacket).hideCoordinates$getRememberedChunkSection());
        }
        if (packetType.equals(class_9094.field_48024)) {
            class_2675 typedPacket = (class_2675) packet;
            return new class_2675(typedPacket.method_11551(),typedPacket.method_11552(), typedPacket.method_65082(), offsetX(typedPacket.method_11544(), offset), typedPacket.method_11547(), offsetZ(typedPacket.method_11546(), offset), typedPacket.method_11548(), typedPacket.method_11549(), typedPacket.method_11550(), typedPacket.method_11543(), typedPacket.method_11545());
        }
        if (packetType.equals(class_9094.field_48057)) {
            class_2767 typedPacket = (class_2767) packet;

            return new class_2767(typedPacket.method_11894(),typedPacket.method_11888(), offsetX(typedPacket.method_11890(),offset),typedPacket.method_11889(),offsetZ(typedPacket.method_11893(),offset), typedPacket.method_11891(),typedPacket.method_11892(),typedPacket.method_43236());
        }
        if (packetType.equals(class_9094.field_48032)) {
            class_2692 typedPacket = (class_2692) packet;

            return new class_2692(offset(typedPacket.comp_3347(),offset), typedPacket.comp_3348(), typedPacket.comp_3349());
        }
        if (packetType.equals(class_9094.field_48091)) {

            class_2759 typedPacket = (class_2759) packet;
            return new class_2759(new class_5217.class_12064(offset(typedPacket.comp_4904().comp_4915(), offset), typedPacket.comp_4904().comp_4916(), typedPacket.comp_4904().comp_4917()));
        }
        if (packetType.equals(class_9094.field_48017)) {
            class_2666 typedPacket = (class_2666) packet;
            return new class_2666(offset(typedPacket.comp_1726(),offset));
        }
        if (packetType.equals(class_9094.field_48025)) {
            class_2676 typedPacket = (class_2676) packet;
            class_1923 newChunkPos = offset(new class_1923(typedPacket.method_11558(), typedPacket.method_11554()),offset);
            ((HasAccessibleChunkPos)typedPacket).hidecoords$setChunkX(newChunkPos.field_9181);
            ((HasAccessibleChunkPos)typedPacket).hidecoords$setChunkZ(newChunkPos.field_9180);
            return typedPacket;
        }
        if (packetType.equals(class_9094.field_48089)) {
            class_4282 typedPacket = (class_4282) packet;
            class_1923 oldPos = new class_1923(typedPacket.method_20322(), typedPacket.method_20323());
            class_1923 newPos = offset(oldPos,offset);
            return new class_4282(newPos.field_9181,newPos.field_9180);
        }
        if (packetType.equals(class_9094.field_54527)) {
            class_10264 typedPacket = (class_10264) packet;
            class_10182 oldPlayerPosition = typedPacket.comp_3224();
            class_243 newPosition = offset(oldPlayerPosition.comp_3148(), offset);
            class_10182 newPlayerPosition = new class_10182(newPosition, oldPlayerPosition.comp_3149(), oldPlayerPosition.comp_3150(), oldPlayerPosition.comp_3151());
            return new class_10264(typedPacket.comp_3223(), newPlayerPosition, typedPacket.comp_3225());
        }
        if (packetType.equals(class_9094.field_48023)) {
            class_2673 typedPacket = (class_2673) packet;

            return new class_2673(typedPacket.method_11532(),offset(typedPacket.method_11531(),offset),typedPacket.method_11534(),typedPacket.method_11533());
        }
        if (packetType.equals(class_9094.field_48044)) {
            class_2744 typedPacket = (class_2744) packet;
            List<Pair<class_1304, class_1799>> equipmentList = typedPacket.method_30145();
            ArrayList<Pair<class_1304, class_1799>> newEquipmentList = new ArrayList<>();
            for (Pair<class_1304, class_1799> pair : equipmentList)
                newEquipmentList.add(Pair.of(pair.getFirst(), offset(pair.getSecond(),offset)));

            return new class_2744(typedPacket.method_11820(),newEquipmentList);
        }
        if (packetType.equals(class_9094.field_48168)) {
            class_2653 typedPacket = (class_2653) packet;
            return new class_2653(typedPacket.method_11452(), typedPacket.method_37439(), typedPacket.method_11450(), offset(typedPacket.method_11449(),offset));
        }
        if (packetType.equals(class_9094.field_48166)) {
            class_2649 typedPacket = (class_2649) packet;
            List<class_1799> contents = typedPacket.comp_3839();
            class_2371<class_1799> newContents = class_2371.method_10213(contents.size(), class_1799.field_8037);
            for (int i = 0; i < contents.size(); i++)
                newContents.set(i, offset(contents.get(i),offset));

            return new class_2649(typedPacket.comp_3837(), typedPacket.comp_3838(), newContents, offset(typedPacket.comp_3840(),offset));
        }
        if (packetType.equals((class_9094.field_48041))) {
            class_2739 typedPacket = (class_2739) packet;
            ArrayList<class_2945.class_7834<?>> newTrackedValues = new ArrayList<>(typedPacket.comp_1128().size());
            if (typedPacket.comp_1128().isEmpty()) return packet;
            for (int i = 0; i < typedPacket.comp_1128().size(); i++)
            {
                class_2945.class_7834<?> entry = typedPacket.comp_1128().get(i);
                class_2945.class_7834<?> newEntry = new class_2945.class_7834<>(entry.comp_1115(), (class_2941<Object>) entry.comp_1116(), offsetData(entry.comp_1117(), offset));
                newTrackedValues.add(newEntry);
            }

            return new class_2739(typedPacket.comp_1127(), newTrackedValues);
        }
        if (packetType.equals(class_9094.field_48076)) {
            class_2724 typedPacket = (class_2724) packet;
            class_8589 oldCommonPlayerSpawnInfo = typedPacket.comp_1728();
            Optional<class_4208> oldLastDeathLocation = oldCommonPlayerSpawnInfo.comp_1560();
            Optional<class_4208> newLastDeathLocation = oldLastDeathLocation.map(pos -> offset(pos,offset));
            class_8589 newCommonPlayerSpawnInfo = new class_8589(oldCommonPlayerSpawnInfo.comp_1553(), oldCommonPlayerSpawnInfo.comp_1554(), oldCommonPlayerSpawnInfo.comp_1555(), oldCommonPlayerSpawnInfo.comp_1556(), oldCommonPlayerSpawnInfo.comp_1557(), oldCommonPlayerSpawnInfo.comp_1558(), oldCommonPlayerSpawnInfo.comp_1559(), newLastDeathLocation, oldCommonPlayerSpawnInfo.comp_1561(), oldCommonPlayerSpawnInfo.comp_2893());
            return new class_2724(newCommonPlayerSpawnInfo, typedPacket.comp_1729());
        }
        if (packetType.equals(class_9094.field_48026)) {
            class_2678 typedPacket = (class_2678) packet;
            class_8589 oldCommonPlayerSpawnInfo = typedPacket.comp_1727();
            Optional<class_4208> oldLastDeathLocation = oldCommonPlayerSpawnInfo.comp_1560();
            Optional<class_4208> newLastDeathLocation = oldLastDeathLocation.map(pos -> offset(pos,offset));
            class_8589 newCommonPlayerSpawnInfo = new class_8589(oldCommonPlayerSpawnInfo.comp_1553(), oldCommonPlayerSpawnInfo.comp_1554(), oldCommonPlayerSpawnInfo.comp_1555(), oldCommonPlayerSpawnInfo.comp_1556(), oldCommonPlayerSpawnInfo.comp_1557(), oldCommonPlayerSpawnInfo.comp_1558(), oldCommonPlayerSpawnInfo.comp_1559(), newLastDeathLocation, oldCommonPlayerSpawnInfo.comp_1561(), oldCommonPlayerSpawnInfo.comp_2893());
            return new class_2678(typedPacket.comp_88(), typedPacket.comp_89(), typedPacket.comp_92(), typedPacket.comp_97(), typedPacket.comp_98(), typedPacket.comp_169(), typedPacket.comp_99(), typedPacket.comp_100(), typedPacket.comp_1964(), newCommonPlayerSpawnInfo, typedPacket.comp_2200());
        }
        if (packetType.equals(class_9094.field_52332)) {
            class_9835 typedPacket = (class_9835) packet;
            return new class_9835(typedPacket.comp_2891(), offset(typedPacket.comp_2892(), offset));
        }
        if (packetType.equals(class_9094.field_52331)) {
            class_9834 typedPacket = (class_9834) packet;
            return new class_9834(offset(typedPacket.comp_2890(), offset));
        }
        if (packetType.equals(class_9094.field_59621)) {
            class_11173 typedPacket = (class_11173) packet;
            class_11200 waypoint = typedPacket.comp_4023();
            return new class_11173(typedPacket.comp_4022(), offset(waypoint, offset));
        }

        if (packetType.equals(class_9094.field_62790)) {
            class_11982 typedPacket = (class_11982) packet;
            return new class_11982(offset(typedPacket.comp_4823(),offset), typedPacket.comp_4824());
        }
        if (packetType.equals(class_9094.field_62786)) {
            class_11983 typedPacket = (class_11983) packet;
            return new class_11983(offset(typedPacket.comp_4825(),offset), typedPacket.comp_4826());
        }
        if (packetType.equals(class_9094.field_62789)) {
            class_11986 typedPacket = (class_11986) packet;
            return new class_11986(offset(typedPacket.comp_4830(),offset), typedPacket.comp_4831());
        }

        //if (!(packetType.equals(PlayPackets.SET_BORDER_CENTER) || packetType.equals(PlayPackets.SET_BORDER_SIZE) || packetType.equals(PlayPackets.MOVE_ENTITY_POS)|| packetType.equals(PlayPackets.ENTITY_POSITION_SYNC)|| packetType.equals(PlayPackets.ROTATE_HEAD)|| packetType.equals(PlayPackets.SET_ENTITY_MOTION)|| packetType.equals(PlayPackets.MOVE_ENTITY_POS_ROT)))
            //System.out.println(packet);



        return packet;
    }

    private static Object offsetData(Object value, Offset offset)
    {
        if (value instanceof class_1799 itemStack) {
            return(offset(itemStack,offset));
        }
        if (value instanceof class_2338 blockPos) {
            return(offset(blockPos,offset));
        }
        if (value instanceof Optional<?> optional) {
            if (optional.isPresent()) return Optional.of(offsetData(optional.get(), offset));
        }
        return value;
    }

    private static class_243 offset(class_243 vec3d, Offset offset) {
        return new class_243(vec3d.method_10216() + offset.getX(), vec3d.field_1351, vec3d.method_10215() + offset.getZ());
    }

    public static class_2338 offset(class_2338 blockPos, Offset offset)
    {
        return new class_2338(blockPos.method_10263() + offset.getX(), blockPos.method_10264(), blockPos.method_10260() + offset.getZ());
    }

    public static double offsetX(double x, Offset offset)
    {
        return x + offset.getX();
    }
    public static double offsetZ(double z, Offset offset)
    {
        return z + offset.getZ();
    }
    public static class_1923 offset(class_1923 chunkPos, Offset offset)
    {
        return new class_1923(chunkPos.field_9181 + offset.getChunkX(), chunkPos.field_9180 + offset.getChunkZ());
    }

    public static class_1799 offset(class_1799 itemStack, Offset offset) {
        if (itemStack == null) return null;

        class_1799 result = itemStack.method_7972();

        class_9276 comp;
        if ((comp = itemStack.method_58694(class_9334.field_49650)) != null)
        {
            class_9276.class_9277 newBundleComp = new class_9276.class_9277(class_9276.field_49289);
            comp.method_59707().forEach(innerStack -> newBundleComp.method_57432(offset(innerStack, offset)));
            result.method_57379(class_9334.field_49650, newBundleComp.method_57435());
        }

        if (itemStack.method_31574(class_1802.field_8251)) {
            itemStack.method_57353().forEach(componentMapEntry -> {
                if (!(componentMapEntry.comp_2444() instanceof class_9291 lodestoneComponent)) return;

                class_9331<class_9291> test = (class_9331<class_9291>) componentMapEntry.comp_2443();

                if (lodestoneComponent.comp_2402().isEmpty()) return;
                class_9291 newLodestoneComponent = new class_9291(Optional.of(offset(lodestoneComponent.comp_2402().get(), offset)), lodestoneComponent.comp_2403());
                result.method_57379(test, newLodestoneComponent);
            });
        }
        return result;
    }


    private static class_4208 offset(class_4208 globalPos, Offset offset) {
        return new class_4208(globalPos.comp_2207(), offset(globalPos.comp_2208(),offset));
    }

    private static class_11200 offset(class_11200 waypoint, Offset offset) {
        return (class_11200) ((OffsetableTrackedWaypoint)waypoint).hidecoords$offset(offset);
    }
}
