package com.jowhjy.hidecoords.mixin;

import com.jowhjy.hidecoords.*;
import com.jowhjy.hidecoords.util.HasCoordOffset;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2792;
import net.minecraft.class_3244;
import net.minecraft.class_9094;
import net.minecraft.class_9145;

@Mixin(class_2535.class)
public abstract class ClientConnectionMixin {

    @Unique
    private static final Set<class_9145<?>> PACKETS_WORLD_BORDER = Set.of(
            // These packets are translated in WorldBorderObfuscator, not this file.
            class_9094.field_48021,
            class_9094.field_48082,
            class_9094.field_48083,
            class_9094.field_48084,
            class_9094.field_48085,
            class_9094.field_48086
    );

    @Shadow private volatile @Nullable class_2547 packetListener;

    @Shadow @Final private Queue<Consumer<class_2535>> queuedTasks;

    @Inject(method = "handlePacket", at =@At("HEAD"), cancellable = true)
    private static <T extends class_2547> void hidecoords$offsetIncomingPacket(class_2596<T> packet, class_2547 listener, CallbackInfo ci)
    {
        if (listener instanceof class_3244 serverPlayNetworkHandler) {
            //dont offset if gamerule off
            if (!serverPlayNetworkHandler.method_32311().juhc$shouldOffset()) return;

            Offset offset = ((HasCoordOffset)serverPlayNetworkHandler).hidecoords$getCoordOffset();
            class_2596<class_2792> newPacket = C2SPacketOffsetter.offsetPacket(packet, offset);
            newPacket.method_65081((class_3244) listener);
            ci.cancel();        }
    }

    @ModifyVariable(method = "sendInternal", at = @At("HEAD"), argsOnly = true)
    public class_2596<?> juhc$offsetOutgoingPacket(class_2596<?> packet) {
        if (this.packetListener instanceof  class_3244 serverPlayNetworkHandler) {
            //dont offset if gamerule off
            if (!serverPlayNetworkHandler.method_32311().juhc$shouldOffset()) return packet;

            Offset offset = ((HasCoordOffset) serverPlayNetworkHandler).hidecoords$getCoordOffset();
            return PACKETS_WORLD_BORDER.contains(packet.method_65080())
            ? WorldBorderObfuscator.translate(packet, offset,serverPlayNetworkHandler.method_32311())
            : S2CPacketOffsetter.offsetPacket(packet, offset, serverPlayNetworkHandler.method_32311().method_51469());
        }
        return packet;
    }

}
