package com.jowhjy.hidecoords.mixin;

import com.jowhjy.hidecoords.Hidecoords;
import com.jowhjy.hidecoords.util.HasCoordOffset;
import com.jowhjy.hidecoords.util.IServerPlayerEntityMixin;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5454;
import net.minecraft.class_5895;
import net.minecraft.class_5897;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3222.class)
public abstract class ServerPlayerEntityMixin extends class_1657 implements IServerPlayerEntityMixin {

    @Shadow public class_3244 networkHandler;

    @Shadow public abstract class_3218 method_73183();

    @Unique boolean offsetActive = true;

    public ServerPlayerEntityMixin(class_1937 world, GameProfile gameProfile) {
        super(world, gameProfile);
    }

    @Inject(method = "teleportTo(Lnet/minecraft/world/TeleportTarget;)Lnet/minecraft/server/network/ServerPlayerEntity;", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerPlayerEntity;setServerWorld(Lnet/minecraft/server/world/ServerWorld;)V"))
    public void hidecoords$changeOffsetOnDimensionChange(class_5454 teleportTarget, CallbackInfoReturnable<class_1297> cir)
    {
        ((HasCoordOffset)(this.networkHandler)).hidecoords$setCoordOffset(com.jowhjy.hidecoords.Offset.zeroAtLocation(class_2338.method_49638(teleportTarget.comp_2821())), false);
    }

    //todo this is very inefficient!
    @Inject(method = "teleportTo(Lnet/minecraft/world/TeleportTarget;)Lnet/minecraft/server/network/ServerPlayerEntity;", at = @At("TAIL"))
    public void hidecoords$changeBorderOnTeleport(class_5454 teleportTarget, CallbackInfoReturnable<class_1297> cir)
    {
        if (!juhc$shouldOffset()) return;
        this.networkHandler.method_14364(new class_5897(this.method_73183().method_8621()));
        this.networkHandler.method_14364(new class_5895(this.method_73183().method_8621()));
    }
    @Override
    public void method_6091(class_243 movementInput)
    {
        super.method_6091(movementInput);
        if (!juhc$shouldOffset()) return;
        this.networkHandler.method_14364(new class_5897(this.method_73183().method_8621()));
        this.networkHandler.method_14364(new class_5895(this.method_73183().method_8621()));
    }

    @Unique @Override
    public boolean juhc$shouldOffset()
    {
        return offsetActive && this.method_73183().method_64395().method_8355(Hidecoords.HIDECOORDS_GAMERULE);
    }
    @Unique @Override
    public void juhc$setShouldOffset(boolean value)
    {
        offsetActive = value;
    }

}
