/*
 * Decompiled with CFR 0.152.
 */
package com.jowhjy.hidecoords;

import com.jowhjy.hidecoords.Offset;
import java.util.EnumSet;
import net.minecraft.class_2338;
import net.minecraft.class_2596;
import net.minecraft.class_2784;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5889;
import net.minecraft.class_5895;
import net.minecraft.class_5896;
import net.minecraft.class_5897;
import net.minecraft.class_9094;
import org.jetbrains.annotations.NotNull;

public class WorldBorderObfuscator {
    private static final double BASELINE_SIZE = 6.0E7;

    private static EnumSet<Wall> visibleBorders(class_2338 location, class_3218 world) {
        double viewDistanceBlocks = world.method_8503().method_3760().method_14568() * 16;
        class_2784 realBorder = world.method_8621();
        double xMax = realBorder.method_11964() + realBorder.method_11965() / 2.0;
        double xMin = realBorder.method_11964() - realBorder.method_11965() / 2.0;
        double zMax = realBorder.method_11980() + realBorder.method_11965() / 2.0;
        double zMin = realBorder.method_11980() - realBorder.method_11965() / 2.0;
        EnumSet<Wall> seen = EnumSet.noneOf(Wall.class);
        if (xMax - (double)location.method_10263() < viewDistanceBlocks) {
            seen.add(Wall.X_POSITIVE);
        }
        if ((double)location.method_10263() - xMin < viewDistanceBlocks) {
            seen.add(Wall.X_NEGATIVE);
        }
        if (zMax - (double)location.method_10260() < viewDistanceBlocks) {
            seen.add(Wall.Z_POSITIVE);
        }
        if ((double)location.method_10260() - zMin < viewDistanceBlocks) {
            seen.add(Wall.Z_NEGATIVE);
        }
        return seen;
    }

    public static class_2596<?> translate(@NotNull class_2596<?> packet, Offset offset, class_3222 player) {
        class_3218 world = player.method_51469();
        double scaleFactor = world.method_8597().comp_646();
        class_2784 dummyWorldBorder = new class_2784();
        EnumSet<Wall> seenWalls = WorldBorderObfuscator.visibleBorders(player.method_24515(), world);
        if (seenWalls.contains((Object)Wall.X_POSITIVE) && seenWalls.contains((Object)Wall.X_NEGATIVE) || seenWalls.contains((Object)Wall.Z_POSITIVE) && seenWalls.contains((Object)Wall.Z_NEGATIVE)) {
            if (packet.method_65080().equals((Object)class_9094.field_48021)) {
                class_5889 typedPacket = (class_5889)packet;
                long l = typedPacket.method_34128();
                if (l > 0L) {
                    dummyWorldBorder.method_11957(typedPacket.method_34127(), typedPacket.method_34126(), l);
                } else {
                    dummyWorldBorder.method_11969(typedPacket.method_34126());
                }
                dummyWorldBorder.method_11973(typedPacket.method_34129());
                dummyWorldBorder.method_11967(typedPacket.method_34131());
                dummyWorldBorder.method_11975(typedPacket.method_34130());
                dummyWorldBorder.method_11978((typedPacket.method_34124() + (double)offset.getX()) * scaleFactor, (typedPacket.method_34125() + (double)offset.getZ()) * scaleFactor);
                return new class_5889(dummyWorldBorder);
            }
            if (packet.method_65080().equals((Object)class_9094.field_48082)) {
                class_5895 typedPacket = (class_5895)packet;
                dummyWorldBorder.method_11978((typedPacket.method_34158() + (double)offset.getX()) * scaleFactor, (typedPacket.method_34157() + (double)offset.getZ()) * scaleFactor);
                return new class_5895(dummyWorldBorder);
            }
            return packet;
        }
        class_2784 border = world.method_8621();
        double centerX = 0.0;
        double centerZ = 0.0;
        double diameter = 6.0E7;
        if (!seenWalls.isEmpty()) {
            if (seenWalls.contains((Object)Wall.X_POSITIVE)) {
                double realXMax = border.method_11964() + border.method_11965() / 2.0;
                centerX = realXMax - 3.0E7;
                centerX += (double)offset.getX();
            }
            if (seenWalls.contains((Object)Wall.X_NEGATIVE)) {
                double realXMin = border.method_11964() - border.method_11965() / 2.0;
                centerX = realXMin + 3.0E7;
                centerX += (double)offset.getX();
            }
            if (seenWalls.contains((Object)Wall.Z_POSITIVE)) {
                double realZMax = border.method_11980() + border.method_11965() / 2.0;
                centerZ = realZMax - 3.0E7;
                centerZ += (double)offset.getZ();
            }
            if (seenWalls.contains((Object)Wall.Z_NEGATIVE)) {
                double realZMin = border.method_11980() - border.method_11965() / 2.0;
                centerZ = realZMin + 3.0E7;
                centerZ += (double)offset.getZ();
            }
        } else {
            centerZ = 0.0;
            centerX = 0.0;
        }
        if (packet.method_65080().equals((Object)class_9094.field_48021)) {
            class_5889 typedPacket = (class_5889)packet;
            long l = typedPacket.method_34128();
            if (l > 0L) {
                dummyWorldBorder.method_11957(6.0E7, 6.0E7, l);
            } else {
                dummyWorldBorder.method_11969(6.0E7);
            }
            dummyWorldBorder.method_11973(typedPacket.method_34129());
            dummyWorldBorder.method_11967(typedPacket.method_34131());
            dummyWorldBorder.method_11975(typedPacket.method_34130());
            dummyWorldBorder.method_11978(centerX * scaleFactor, centerZ * scaleFactor);
            return new class_5889(dummyWorldBorder);
        }
        if (packet.method_65080().equals((Object)class_9094.field_48082)) {
            dummyWorldBorder.method_11978(centerX * scaleFactor, centerZ * scaleFactor);
            return new class_5895(dummyWorldBorder);
        }
        if (packet.method_65080().equals((Object)class_9094.field_48083)) {
            class_5896 typedPacket = (class_5896)packet;
            long l = typedPacket.method_34162();
            if (l > 0L) {
                dummyWorldBorder.method_11957(6.0E7, 6.0E7, l);
            } else {
                dummyWorldBorder.method_11969(6.0E7);
            }
            return new class_5896(dummyWorldBorder);
        }
        if (packet.method_65080().equals((Object)class_9094.field_48084)) {
            dummyWorldBorder.method_11969(6.0E7);
            return new class_5897(dummyWorldBorder);
        }
        return packet;
    }

    static enum Wall {
        X_POSITIVE,
        X_NEGATIVE,
        Z_POSITIVE,
        Z_NEGATIVE;

    }
}

