/*
 * Decompiled with CFR 0.152.
 */
package org.pvp.pvponedoteight.GameUtils;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.pvp.pvponedoteight.PVPOneDotEight;

public class ArenaConfig {
    private Location iniLocal;
    private Boolean pending = true;
    private Boolean visible = false;
    private boolean editing = false;
    public long lastClick = 0L;
    private int x1;
    private int y1;
    private int z1;
    private int largx;
    private int largz;
    private String world;
    private boolean pvpOldMode = true;
    private ArmorStand armor;
    private PVPOneDotEight myPvp;
    private Location baseLocation;
    private Location location2;
    private Location location3;
    private Location location4;

    public ArenaConfig(PVPOneDotEight myPvp) {
        this.myPvp = myPvp;
    }

    public boolean SetupArena(Location local, Player player) {
        if (this.iniLocal == null) {
            this.iniLocal = local;
            this.x1 = this.iniLocal.getBlockX();
            this.z1 = this.iniLocal.getBlockZ();
            this.world = local.getWorld().getName();
            player.sendBlockChange(local, Material.GLOWSTONE.createBlockData());
            player.sendMessage("Right click again on the opposite border");
            return true;
        }
        if (this.pending.booleanValue() || this.editing) {
            if (this.editing) {
                double d1 = local.distance(this.baseLocation);
                double d2 = local.distance(this.location2);
                double d3 = local.distance(this.location3);
                double d4 = local.distance(this.location4);
                d1 = Math.floor(d1 * 100.0) / 100.0;
                d2 = Math.floor(d2 * 100.0) / 100.0;
                d3 = Math.floor(d3 * 100.0) / 100.0;
                d4 = Math.floor(d4 * 100.0) / 100.0;
                Location mostFar = d1 > d2 ? (d1 > d3 ? (d1 > d4 ? this.baseLocation : this.location4) : (d3 > d4 ? this.location3 : this.location4)) : (d2 > d3 ? (d2 > d4 ? this.location2 : this.location4) : (d3 > d4 ? this.location3 : this.location4));
                if (mostFar.distance(local) <= 8.0) {
                    return false;
                }
                this.iniLocal = mostFar;
            } else {
                if (Math.abs(local.getBlockX() - this.x1) <= 6) {
                    return false;
                }
                if (Math.abs(local.getBlockZ() - this.z1) <= 6) {
                    return false;
                }
            }
            if (this.visible.booleanValue()) {
                this.drawLimits(player, true);
            }
            Location endLocal = local;
            int tmpx1 = this.iniLocal.getBlockX();
            int tmpz1 = this.iniLocal.getBlockZ();
            int tmpx2 = endLocal.getBlockX();
            int tmpz2 = endLocal.getBlockZ();
            if (tmpx1 < tmpx2) {
                this.x1 = tmpx1;
                this.largx = tmpx2 - tmpx1;
                this.y1 = this.iniLocal.getBlockY();
            } else {
                this.x1 = tmpx2;
                this.largx = tmpx1 - tmpx2;
                this.y1 = endLocal.getBlockY();
            }
            if (tmpz1 < tmpz2) {
                this.z1 = tmpz1;
                this.largz = tmpz2 - tmpz1;
            } else {
                this.z1 = tmpz2;
                this.largz = tmpz1 - tmpz2;
            }
            this.baseLocation = new Location(Bukkit.getWorld((String)this.world), (double)this.x1, (double)this.y1, (double)this.z1);
            this.location2 = new Location(Bukkit.getWorld((String)this.world), (double)(this.x1 + this.largx), (double)this.y1, (double)this.z1);
            this.location3 = new Location(Bukkit.getWorld((String)this.world), (double)(this.x1 + this.largx), (double)this.y1, (double)(this.z1 + this.largz));
            this.location4 = new Location(Bukkit.getWorld((String)this.world), (double)this.x1, (double)this.y1, (double)(this.z1 + this.largz));
            this.pending = false;
            this.editing = true;
            player.sendMessage("Left click to save or right click to adjust");
            this.drawLimits(player, false);
        }
        return true;
    }

    public void terminateArena() {
        this.myPvp.mybukkit.showArenaLabel(this.armor, new Location(Bukkit.getWorld((String)this.world), (double)Math.abs(this.x1 + this.largx / 2), (double)this.y1, (double)this.z1), "", false, true);
    }

    public Boolean isArenaFinished() {
        return this.pending == false;
    }

    public Boolean isArenaEditing() {
        return this.editing;
    }

    public void enableArenaEditing(Player player) {
        this.editing = true;
        this.drawLimits(player, false);
        this.myPvp.mybukkit.showArenaLabel(this.armor, new Location(Bukkit.getWorld((String)this.world), (double)Math.abs(this.x1 + this.largx / 2), (double)this.y1, (double)this.z1), "Editing Arena", false, false);
    }

    public void endArenaEditing(Player player, boolean delete) {
        if (this.editing) {
            this.editing = false;
            this.drawLimits(player, true);
            if (delete) {
                this.myPvp.mybukkit.showArenaLabel(this.armor, new Location(Bukkit.getWorld((String)this.world), (double)Math.abs(this.x1 + this.largx / 2), (double)this.y1, (double)this.z1), "", false, false);
            } else {
                this.myPvp.mybukkit.showArenaLabel(this.armor, new Location(Bukkit.getWorld((String)this.world), (double)Math.abs(this.x1 + this.largx / 2), (double)this.y1, (double)this.z1), String.valueOf(ChatColor.BLACK) + "Arena for oldPVP: " + String.valueOf(this.pvpOldMode ? ChatColor.GREEN : ChatColor.RED) + this.pvpOldMode, true, false);
            }
        }
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public Boolean isNewPvpMode() {
        return !this.pvpOldMode;
    }

    public Boolean isInArena(Location local) {
        int x3 = local.getBlockX();
        int z3 = local.getBlockZ();
        if (x3 >= this.x1 && x3 <= this.x1 + this.largx && z3 >= this.z1 && z3 <= this.z1 + this.largz) {
            return true;
        }
        return false;
    }

    public Boolean isNearArena(Location local) {
        int x3 = local.getBlockX();
        int z3 = local.getBlockZ();
        if (x3 >= this.x1 - 30 && x3 <= this.x1 + this.largx + 30 && z3 >= this.z1 - 30 && z3 <= this.z1 + this.largz + 30) {
            return true;
        }
        return false;
    }

    public String[] getDimensions() {
        String[] array = new String[]{"" + this.x1, "" + this.y1, "" + this.z1, "" + this.largx, "" + this.largz, this.world, "" + this.pvpOldMode};
        return array;
    }

    public void setDimensions(String[] array) {
        this.x1 = Integer.parseInt(array[0]);
        this.y1 = Integer.parseInt(array[1]);
        this.z1 = Integer.parseInt(array[2]);
        this.largx = Integer.parseInt(array[3]);
        this.largz = Integer.parseInt(array[4]);
        this.world = array[5];
        this.pvpOldMode = Boolean.parseBoolean(array[6]);
        this.baseLocation = new Location(Bukkit.getWorld((String)this.world), (double)this.x1, (double)this.y1, (double)this.z1);
        this.location2 = new Location(Bukkit.getWorld((String)this.world), (double)(this.x1 + this.largx), (double)this.y1, (double)this.z1);
        this.location3 = new Location(Bukkit.getWorld((String)this.world), (double)(this.x1 + this.largx), (double)this.y1, (double)(this.z1 + this.largz));
        this.location4 = new Location(Bukkit.getWorld((String)this.world), (double)this.x1, (double)this.y1, (double)(this.z1 + this.largz));
        this.iniLocal = this.baseLocation.clone();
        this.pending = false;
        this.editing = false;
        this.visible = false;
        this.myPvp.mybukkit.showArenaLabel(this.armor, new Location(Bukkit.getWorld((String)this.world), (double)Math.abs(this.x1 + this.largx / 2), (double)this.y1, (double)this.z1), String.valueOf(ChatColor.BLACK) + "Arena with oldPVP: " + String.valueOf(this.pvpOldMode ? ChatColor.GREEN : ChatColor.RED) + this.pvpOldMode, true, false);
    }

    private void drawLimits(Player player, boolean hideArena) {
        if (!this.isArenaFinished().booleanValue()) {
            player.sendMessage("not yet finished!");
            return;
        }
        long counter = System.nanoTime();
        if (!hideArena) {
            if (counter - this.lastClick < 250000000L) {
                this.pvpOldMode = !this.pvpOldMode;
            }
            this.lastClick = counter;
        }
        this.visible = !hideArena;
        int xLimit = this.largx;
        int zLimit = this.largz;
        Location loc = this.baseLocation.clone();
        for (int x = 0; x <= xLimit; ++x) {
            for (int z = 0; z <= zLimit; ++z) {
                loc = this.baseLocation.clone();
                loc.add((double)x, 0.0, (double)z);
                Location aux = loc.clone();
                aux.add(0.0, 1.0, 0.0);
                for (int y = 0; !(y >= 7 || loc.getBlock().getType().isSolid() && aux.getBlock().isEmpty()); ++y) {
                    if (loc.getBlock().getType().isSolid() && aux.getBlock().getType().isSolid()) {
                        loc.add(0.0, 1.0, 0.0);
                        aux.add(0.0, 1.0, 0.0);
                        continue;
                    }
                    if (!loc.getBlock().isEmpty() || !aux.getBlock().isEmpty()) continue;
                    loc.add(0.0, -1.0, 0.0);
                    aux.add(0.0, -1.0, 0.0);
                }
                this.y1 = loc.getBlockY();
                if (x == 0 && z == 0 || x == 0 && z == zLimit || z == 0 && x == xLimit || x == xLimit && z == zLimit) {
                    if (hideArena) {
                        player.sendBlockChange(loc, loc.getBlock().getBlockData());
                        continue;
                    }
                    if (!hideArena && !this.pvpOldMode) {
                        player.sendBlockChange(loc, Material.SHROOMLIGHT.createBlockData());
                        continue;
                    }
                    player.sendBlockChange(loc, Material.SEA_LANTERN.createBlockData());
                    continue;
                }
                if (x != 0 && x != xLimit && z != 0 && z != zLimit) continue;
                if (hideArena) {
                    player.sendBlockChange(loc, loc.getBlock().getBlockData());
                    continue;
                }
                if (!hideArena && !this.pvpOldMode) {
                    player.sendBlockChange(loc, Material.NETHERITE_BLOCK.createBlockData());
                    continue;
                }
                player.sendBlockChange(loc, Material.IRON_BLOCK.createBlockData());
            }
        }
    }
}

