/*
 * Decompiled with CFR 0.152.
 */
package org.pvp.pvponedoteight;

import java.io.File;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityPlaceEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.pvp.pvponedoteight.GameUtils.ArenaConfig;
import org.pvp.pvponedoteight.GameUtils.MyPlayer;
import org.pvp.pvponedoteight.Utils.Metrics;
import org.pvp.pvponedoteight.Utils.MyBukkit;
import org.pvp.pvponedoteight.Utils.PVPPlaceholderHandler;
import org.pvp.pvponedoteight.Utils.Utils;

public final class PVPOneDotEight
extends JavaPlugin
implements Listener {
    public final String VERSION = this.getDescription().getVersion();
    public boolean isInit = true;
    public MyBukkit mybukkit;
    private int maxCPS;
    private boolean checkOnlineUpdate;
    private boolean specialEffects;
    private boolean noCooldown;
    private boolean fastRespawn;
    private boolean normalizeHackedItems;
    private boolean autoSetShield;
    private boolean controlEntitiesInArena;
    private boolean protectArena;
    private String workingWorld;
    private LinkedList<ArenaConfig> myArenas = new LinkedList();
    private Hashtable<UUID, MyPlayer> playersHash = new Hashtable();
    private Hashtable<UUID, String> playerKnockback1dot8 = new Hashtable();

    public void onEnable() {
        this.mybukkit = new MyBukkit(this);
        this.LoadSettings();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (Utils.checkGreater("1.21.1", Bukkit.getServer().getBukkitVersion()) == -1) {
            this.getLogger().severe(" You are using a Minecraft Server version with possible data loss and known exploits, get informed and evaluate updating to 1.21.1");
        }
        String version = Bukkit.getServer().getName().toUpperCase();
        this.mybukkit.UpdateChecker(true);
        this.mybukkit.runTaskTimer(null, null, null, () -> this.ShowPlayerInArena(), 0L, 40L);
        this.startMetrics();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PVPPlaceholderHandler(this).register();
        } else {
            this.getLogger().info("Could not find PlaceholderAPI!");
        }
        this.getLogger().info("Version " + this.VERSION + " enabled on " + version + "!");
        this.isInit = false;
    }

    public void onDisable() {
        for (int k = 0; k < this.myArenas.size(); ++k) {
            ArenaConfig arena = this.myArenas.get(k);
            arena.terminateArena();
        }
        this.getLogger().info(this.VERSION + " disabled!");
    }

    public void LoadSettings() {
        FileConfiguration config = this.getConfig();
        this.setupConfig();
        try {
            this.workingWorld = config.getString("workingWorld", "");
            this.checkOnlineUpdate = config.getBoolean("checkUpdate", true);
            this.specialEffects = config.getBoolean("specialEffects", false);
            this.normalizeHackedItems = config.getBoolean("normalizeHackedItems", false);
            this.noCooldown = config.getBoolean("noCooldown", true);
            this.autoSetShield = config.getBoolean("autoSetShield", true);
            this.controlEntitiesInArena = config.getBoolean("controlEntitiesInArena", false);
            this.protectArena = config.getBoolean("protectArena", false);
            this.maxCPS = config.getInt("maxCPS", 16);
            this.fastRespawn = config.getBoolean("fastRespawn", false);
        }
        catch (Exception e) {
            this.maxCPS = 16;
        }
        try {
            for (int k = 0; k < 100; ++k) {
                String[] array = new String[7];
                array[0] = config.getString("Arenas.Arena" + k + ".a");
                if (array[0] != null) {
                    array[1] = config.getString("Arenas.Arena" + k + ".b");
                    array[2] = config.getString("Arenas.Arena" + k + ".c");
                    array[3] = config.getString("Arenas.Arena" + k + ".d");
                    array[4] = config.getString("Arenas.Arena" + k + ".e");
                    array[5] = config.getString("Arenas.Arena" + k + ".f");
                    array[6] = config.getString("Arenas.Arena" + k + ".g");
                    ArenaConfig arena = new ArenaConfig(this);
                    arena.setDimensions(array);
                    this.myArenas.add(arena);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            System.out.println("Arenas. excep  " + e.getMessage());
        }
    }

    private void setupConfig() {
        FileConfiguration config = this.getConfig();
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdir();
        }
        config.options().header("==== PVPOneDotEight Configs ====");
        config.addDefault("checkUpdate", (Object)true);
        config.addDefault("specialEffects", (Object)false);
        config.addDefault("normalizeHackedItems", (Object)false);
        config.addDefault("noCooldown", (Object)true);
        config.addDefault("autoSetShield", (Object)true);
        config.addDefault("controlEntitiesInArena", (Object)false);
        config.addDefault("protectArena", (Object)false);
        config.options().copyDefaults(true);
        this.saveConfig();
    }

    private void startMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this, 22590);
            metrics.addCustomChart(new Metrics.SimplePie("check_online", () -> {
                if (this.checkOnlineUpdate) {
                    return "true";
                }
                return "false";
            }));
            metrics.addCustomChart(new Metrics.SimplePie("no_cooldown", () -> {
                if (this.noCooldown) {
                    return "true";
                }
                return "false";
            }));
            metrics.addCustomChart(new Metrics.SimplePie("special_effects", () -> {
                if (this.specialEffects) {
                    return "true";
                }
                return "false";
            }));
            metrics.addCustomChart(new Metrics.SimplePie("normalize_Hacked_Items", () -> {
                if (this.normalizeHackedItems) {
                    return "true";
                }
                return "false";
            }));
        }
        catch (Exception e) {
            this.getLogger().info(String.valueOf(ChatColor.RED) + " Failed to register into Bstats");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        boolean newPVP = false;
        if (this.myArenas.size() == 0) {
            String world = player.getWorld().getName();
            if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                return;
            }
        } else {
            ArenaConfig arena;
            MyPlayer myPlayer = this.playersHash.get(player.getUniqueId());
            if (myPlayer == null) {
                myPlayer = new MyPlayer();
                this.playersHash.put(player.getUniqueId(), myPlayer);
            }
            if ((arena = this.isInArena(player.getLocation())) == null) {
                return;
            }
            myPlayer.UpdateArena(arena);
            newPVP = arena.isNewPvpMode();
        }
        this.preparePlayer(player, newPVP);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerChangedWorldEvent(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        if (this.myArenas.size() == 0) {
            String world = player.getWorld().getName();
            if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                this.resetPlayer(player);
            } else if (!this.workingWorld.equals("") && world.equals(this.workingWorld)) {
                this.preparePlayer(player, false);
            }
        } else {
            MyPlayer myPlayer = this.playersHash.get(player.getUniqueId());
            ArenaConfig arena = this.isInArena(player.getLocation());
            if (arena == null) {
                myPlayer.UpdateArena(null);
                this.resetPlayer(player);
            } else {
                myPlayer.UpdateArena(arena);
                this.preparePlayer(player, arena.isNewPvpMode());
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.resetPlayer(player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityPlaceEvent(@NotNull EntityPlaceEvent event) {
        if (event == null) {
            PVPOneDotEight.$$$reportNull$$$0(0);
        }
        Location location = event.getBlock().getLocation();
        String myWorld = location.getWorld().getName();
        if (this.myArenas.size() == 0) {
            if (!this.workingWorld.equals("") && !myWorld.equals(this.workingWorld)) {
                return;
            }
        } else {
            MyPlayer myPlayer = this.playersHash.get(event.getPlayer().getUniqueId());
            if (myPlayer == null) {
                return;
            }
            if (!myPlayer.isInPVPArena() || myPlayer.isNewPVPArena()) {
                return;
            }
        }
        if (event.getEntityType() == EntityType.END_CRYSTAL && !myWorld.endsWith("_nether") && !myWorld.endsWith("_end")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSelect(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (this.myArenas.size() == 0) {
            String world = player.getWorld().getName();
            if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                return;
            }
        } else {
            MyPlayer myPlayer = this.playersHash.get(player.getUniqueId());
            if (myPlayer == null) {
                return;
            }
            if (!myPlayer.isInPVPArena() || myPlayer.isNewPVPArena()) {
                return;
            }
        }
        this.mybukkit.runTaskLater(player, null, null, () -> this.filterPlayerInventory(player), 5L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        if (this.myArenas.size() == 0) {
            String world = player.getWorld().getName();
            if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                return;
            }
        } else {
            MyPlayer myPlayer = this.playersHash.get(player.getUniqueId());
            if (myPlayer == null) {
                return;
            }
            if (!myPlayer.isInPVPArena() || myPlayer.isNewPVPArena()) {
                return;
            }
        }
        this.mybukkit.runTaskLater(player, null, null, () -> this.filterPlayerInventory(player), 5L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onEntityHit(EntityDamageByEntityEvent event) {
        if (event.getDamager() instanceof Player) {
            Player attacker = (Player)event.getDamager();
            MyPlayer myPlayer = null;
            if (this.myArenas.size() == 0) {
                String world = attacker.getWorld().getName();
                if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                    return;
                }
            } else {
                myPlayer = this.playersHash.get(attacker.getUniqueId());
                if (myPlayer == null) {
                    return;
                }
                if (myPlayer.isInPVPArena() && myPlayer.isNewPVPArena()) {
                    return;
                }
            }
            if (myPlayer == null) {
                return;
            }
            if (event.getEntity() instanceof Player) {
                float cooldown;
                MyPlayer myPlayer2;
                if (!myPlayer.isInPVPArena()) {
                    event.setCancelled(true);
                    return;
                }
                if (!myPlayer.isPlayingPVP()) {
                    event.setCancelled(true);
                    return;
                }
                if (this.myArenas.size() > 0 && !(myPlayer2 = this.playersHash.get(event.getEntity().getUniqueId())).isPlayingPVP()) {
                    event.setCancelled(true);
                    return;
                }
                if (this.noCooldown && (double)(cooldown = attacker.getAttackCooldown()) < 1.0) {
                    event.setDamage(event.getDamage() * (double)(1.0f / cooldown));
                }
                this.applyLegacyKB((Player)event.getEntity(), attacker);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player myEntity = event.getEntity();
        if (!(myEntity instanceof Player)) {
            return;
        }
        Player victim = myEntity;
        if (this.myArenas.size() == 0) {
            String world = victim.getWorld().getName();
            if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                return;
            }
        } else {
            MyPlayer myPlayer = this.playersHash.get(victim.getUniqueId());
            if (myPlayer == null) {
                return;
            }
            if (!myPlayer.isInPVPArena()) {
                return;
            }
            myPlayer.setDeaths();
            Player killer = victim.getKiller();
            if (killer instanceof Player) {
                MyPlayer myPlayer2 = this.playersHash.get(killer.getUniqueId());
                if (!myPlayer2.isInPVPArena()) {
                    event.setCancelled(true);
                    return;
                }
                if (myPlayer2 != null) {
                    myPlayer2.setKills();
                }
            }
        }
        if (this.specialEffects) {
            this.mybukkit.runTaskLater(victim, null, null, () -> {
                victim.getWorld().strikeLightningEffect(victim.getLocation());
                victim.getWorld().spawnParticle(Particle.GLOW, victim.getLocation(), 10, 0.0, 0.0, 1.0);
            }, 1L);
        }
        if (this.fastRespawn) {
            this.fastSpawn(victim);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        if (this.myArenas.size() == 0) {
            String world = event.getPlayer().getWorld().getName();
            if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                return;
            }
        } else {
            MyPlayer myPlayer = this.playersHash.get(event.getPlayer().getUniqueId());
            if (myPlayer == null) {
                return;
            }
            if (!myPlayer.isInPVPArena() || myPlayer.isNewPVPArena()) {
                return;
            }
        }
        if (event.getItem().getType() == Material.CHORUS_FRUIT || event.getItem().getType() == Material.SUSPICIOUS_STEW || event.getItem().getType() == Material.BEETROOT_SOUP) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onRodHit(ProjectileHitEvent event) {
        Projectile hookEntity;
        ProjectileSource fisher;
        if (event.getEntityType() == EntityType.FISHING_BOBBER && (fisher = ((FishHook)(hookEntity = event.getEntity())).getShooter()) instanceof Player) {
            Entity defender;
            Player player = (Player)fisher;
            if (this.myArenas.size() == 0) {
                String world = hookEntity.getWorld().getName();
                if (!this.workingWorld.equals("") && !world.equals(this.workingWorld)) {
                    return;
                }
            } else {
                MyPlayer myPlayer = this.playersHash.get(player.getUniqueId());
                if (myPlayer == null) {
                    return;
                }
                if (!myPlayer.isInPVPArena() || myPlayer.isNewPVPArena()) {
                    return;
                }
            }
            if ((defender = event.getHitEntity()) != null) {
                defender.setVelocity(this.calculateKnockBackVelocity(defender.getVelocity(), hookEntity.getVelocity()));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerMoveEvent(@NotNull PlayerMoveEvent event) {
        if (event == null) {
            PVPOneDotEight.$$$reportNull$$$0(1);
        }
        if (this.myArenas.size() == 0) {
            return;
        }
        Player player = event.getPlayer();
        MyPlayer myPlayer = this.playersHash.get(player.getUniqueId());
        if (myPlayer == null || !myPlayer.isPlayingPVP() || !player.getGameMode().equals((Object)GameMode.SURVIVAL)) {
            return;
        }
        ArenaConfig arena = this.isInArena(player.getLocation());
        if (arena == null && myPlayer.isInPVPArena()) {
            myPlayer.UpdateArena(null);
            this.resetPlayer(player);
        } else {
            boolean newArena = myPlayer.UpdateArena(arena);
            if (newArena) {
                this.preparePlayer(player, arena.isNewPvpMode());
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntitySpawnEvent(@NotNull EntitySpawnEvent event) {
        ArenaConfig arena;
        if (event == null) {
            PVPOneDotEight.$$$reportNull$$$0(2);
        }
        if (!this.controlEntitiesInArena) {
            return;
        }
        if (this.myArenas.size() == 0) {
            return;
        }
        Entity ent = event.getEntity();
        if (ent instanceof LivingEntity && (arena = this.isInArena(ent.getLocation())) != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onProcessBlockBreakEvent(BlockBreakEvent e) {
        if (!this.protectArena) {
            return;
        }
        Player player = e.getPlayer();
        ArenaConfig arena = this.isInArena(player.getLocation());
        if (arena != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onBlockPlaceEvent(BlockPlaceEvent e) {
        if (!this.protectArena) {
            return;
        }
        Player player = e.getPlayer();
        ArenaConfig arena = this.isInArena(player.getLocation());
        if (arena != null) {
            e.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArenaClick(PlayerInteractEvent event) {
        Action a = event.getAction();
        Block block = event.getClickedBlock();
        ItemStack item = event.getItem();
        if (block == null || item == null) {
            return;
        }
        Player player = event.getPlayer();
        Location loc = block.getLocation();
        ArenaConfig arena = null;
        if (!player.isOp()) {
            return;
        }
        if (a.equals((Object)Action.RIGHT_CLICK_BLOCK) && item.getType().equals((Object)Material.BONE)) {
            for (int k = 0; k < this.myArenas.size(); ++k) {
                arena = this.myArenas.get(k);
                if (arena.isInArena(loc).booleanValue() && arena.isArenaEditing().booleanValue() && System.currentTimeMillis() - arena.lastClick < 5000L) {
                    FileConfiguration config = this.getConfig();
                    for (int delete = 0; delete < this.myArenas.size(); ++delete) {
                        config.set("Arenas.Arena" + delete + ".a", null);
                        config.set("Arenas.Arena" + delete + ".b", null);
                        config.set("Arenas.Arena" + delete + ".c", null);
                        config.set("Arenas.Arena" + delete + ".d", null);
                        config.set("Arenas.Arena" + delete + ".e", null);
                        config.set("Arenas.Arena" + delete + ".f", null);
                        config.set("Arenas.Arena" + delete + ".g", null);
                    }
                    this.myArenas.remove(arena);
                    arena.endArenaEditing(player, true);
                    arena = null;
                    for (int update = 0; update < this.myArenas.size(); ++update) {
                        arena = this.myArenas.get(update);
                        String[] list = arena.getDimensions();
                        config.set("Arenas.Arena" + update + ".a", (Object)list[0]);
                        config.set("Arenas.Arena" + update + ".b", (Object)list[1]);
                        config.set("Arenas.Arena" + update + ".c", (Object)list[2]);
                        config.set("Arenas.Arena" + update + ".d", (Object)list[3]);
                        config.set("Arenas.Arena" + update + ".e", (Object)list[4]);
                        config.set("Arenas.Arena" + update + ".f", (Object)list[5]);
                        config.set("Arenas.Arena" + update + ".g", (Object)list[6]);
                    }
                    config.options().copyDefaults(true);
                    this.saveConfig();
                    player.sendMessage("Arena deleted!");
                    return;
                }
                if (!arena.isInArena(loc).booleanValue()) continue;
                arena.enableArenaEditing(player);
                arena.lastClick = System.currentTimeMillis();
                player.sendMessage("Click again to delete (in less then 5 secs)");
            }
        } else if (a.equals((Object)Action.LEFT_CLICK_BLOCK) && item.getType().equals((Object)Material.ARROW)) {
            for (int k = 0; k < this.myArenas.size(); ++k) {
                arena = this.myArenas.get(k);
                if (!arena.isInArena(loc).booleanValue() || !arena.isArenaEditing().booleanValue()) continue;
                arena.endArenaEditing(player, false);
                event.setCancelled(true);
                FileConfiguration config = this.getConfig();
                String[] list = arena.getDimensions();
                config.set("Arenas.Arena" + k + ".a", (Object)list[0]);
                config.set("Arenas.Arena" + k + ".b", (Object)list[1]);
                config.set("Arenas.Arena" + k + ".c", (Object)list[2]);
                config.set("Arenas.Arena" + k + ".d", (Object)list[3]);
                config.set("Arenas.Arena" + k + ".e", (Object)list[4]);
                config.set("Arenas.Arena" + k + ".f", (Object)list[5]);
                config.set("Arenas.Arena" + k + ".g", (Object)list[6]);
                config.options().copyDefaults(true);
                this.saveConfig();
            }
        } else if (a.equals((Object)Action.RIGHT_CLICK_BLOCK) && item.getType().equals((Object)Material.ARROW)) {
            for (int k = 0; k < this.myArenas.size(); ++k) {
                arena = this.myArenas.get(k);
                if (arena.isNearArena(loc).booleanValue()) {
                    if (arena.isArenaFinished().booleanValue() && !arena.isVisible().booleanValue()) {
                        arena.enableArenaEditing(player);
                    } else {
                        boolean ok = arena.SetupArena(loc, player);
                        if (!ok) {
                            player.sendMessage("Invalid finished position, too small");
                        }
                    }
                    return;
                }
                player.sendMessage("You are too far from start position");
            }
            if (arena != null && arena.isArenaEditing().booleanValue()) {
                return;
            }
            if (arena == null || arena.isArenaFinished().booleanValue() && !arena.isNearArena(loc).booleanValue()) {
                arena = new ArenaConfig(this);
                arena.SetupArena(loc, player);
                this.myArenas.add(arena);
                return;
            }
        }
    }

    private ArenaConfig isInArena(Location loc) {
        for (int k = 0; k < this.myArenas.size(); ++k) {
            ArenaConfig arena = this.myArenas.get(k);
            if (!arena.isInArena(loc).booleanValue()) continue;
            return arena;
        }
        return null;
    }

    private void fastSpawn(Player player) {
        this.mybukkit.runTaskLater(player, null, null, () -> {
            if (!player.isOnline()) {
                return;
            }
            if (this.specialEffects) {
                player.getWorld().strikeLightningEffect(player.getRespawnLocation());
            }
            player.spigot().respawn();
        }, 40L);
    }

    private void filterPlayerInventory(Player player) {
        ItemStack it1 = player.getInventory().getItemInMainHand();
        ItemStack it2 = player.getInventory().getItemInOffHand();
        String item1 = it1.getType().toString();
        String item2 = it2.getType().toString();
        if (item1.contains("SWORD") && it1.containsEnchantment(Enchantment.SWEEPING_EDGE)) {
            int level = (Integer)it1.getEnchantments().get(Enchantment.SWEEPING_EDGE);
            it1.removeEnchantment(Enchantment.SWEEPING_EDGE);
            Repairable newSword = (Repairable)it1.getItemMeta();
            int repairCost = newSword.getRepairCost();
            if (repairCost > 120) {
                repairCost /= 2;
            }
            newSword.setRepairCost(repairCost / 2);
            it1.setItemMeta((ItemMeta)newSword);
            ItemStack book = new ItemStack(Material.ENCHANTED_BOOK, 1);
            EnchantmentStorageMeta bookmeta = (EnchantmentStorageMeta)book.getItemMeta();
            bookmeta.addStoredEnchant(Enchantment.SWEEPING_EDGE, level, true);
            book.setItemMeta((ItemMeta)bookmeta);
            player.getInventory().addItem(new ItemStack[]{book});
        }
        if (item1.contains("TOTEM")) {
            player.getEnderChest().addItem(new ItemStack[]{it1});
            player.getInventory().remove(it1);
            player.sendMessage("This is PVP 1.8, Totem of Undying is not used");
        }
        if (item2.contains("TOTEM")) {
            player.getEnderChest().addItem(new ItemStack[]{it2});
            player.getInventory().setItemInOffHand(new ItemStack(Material.AIR, 1));
            player.sendMessage("This is PVP 1.8, Totem of Undying is not used");
        }
    }

    private void preparePlayer(Player player, boolean newPVP) {
        ItemStack it;
        if (this.normalizeHackedItems) {
            block0: for (int i = 0; i < player.getInventory().getSize(); ++i) {
                ItemStack item = player.getInventory().getItem(i);
                if (item == null || item.getEnchantments() == null) continue;
                for (Map.Entry entry : item.getEnchantments().entrySet()) {
                    int level = (Integer)entry.getValue();
                    if (level < 6) continue;
                    item.removeEnchantment((Enchantment)entry.getKey());
                    continue block0;
                }
            }
        }
        if (newPVP) {
            return;
        }
        String key = Attribute.GENERIC_ATTACK_SPEED.name();
        AttributeInstance instance = player.getAttribute(Attribute.valueOf((String)key));
        if (instance != null && instance.getBaseValue() == 4.0) {
            instance.setBaseValue((double)this.maxCPS);
        }
        if ((it = player.getInventory().getItemInOffHand()) != null) {
            String myItem = it.getType().toString();
            if (myItem.contains("SHIELD")) {
                return;
            }
            if (myItem.contains("TOTEM")) {
                player.getEnderChest().addItem(new ItemStack[]{it});
                player.getInventory().setItemInOffHand(new ItemStack(Material.AIR, 1));
            } else {
                player.getInventory().remove(it);
            }
            player.getInventory().addItem(new ItemStack[]{it});
        }
        if (this.autoSetShield) {
            ItemStack it2;
            if (player.getInventory().contains(Material.SHIELD)) {
                player.getInventory().remove(Material.SHIELD);
                it2 = new ItemStack(Material.SHIELD, 1);
                player.getInventory().setItemInOffHand(it2);
                return;
            }
            it2 = new ItemStack(Material.SHIELD, 1);
            player.getInventory().setItemInOffHand(it2);
        }
    }

    private void resetPlayer(Player player) {
        String key = Attribute.GENERIC_ATTACK_SPEED.name();
        AttributeInstance instance = player.getAttribute(Attribute.valueOf((String)key));
        if (instance != null && instance.getBaseValue() != 4.0) {
            instance.setBaseValue(4.0);
        }
    }

    private Vector calculateKnockBackVelocity(Vector currentVelocity, Vector hookVelocity) {
        currentVelocity.add(hookVelocity.multiply(0.45));
        currentVelocity.add(new Vector(0.0, 0.45, 0.0));
        return currentVelocity;
    }

    public void applyLegacyKB(Player victim, Player attacker) {
        if (this.playerKnockback1dot8.get(victim.getUniqueId()) != null) {
            return;
        }
        double BASE_KB = 0.4;
        double SPRINT_KB = 0.2;
        double VERTICAL_KB = 0.38;
        double DAMPING = 0.6;
        Vector direction = victim.getLocation().getDirection().normalize();
        direction = direction.setX(direction.getX() * DAMPING);
        direction = direction.setY(0);
        direction = direction.setZ(direction.getZ() * DAMPING);
        double strength = BASE_KB + (attacker.isSprinting() ? SPRINT_KB : 0.0);
        Vector kb = direction.multiply(strength);
        if (victim.isOnGround()) {
            kb.setY(VERTICAL_KB);
        }
        if (kb.getX() > 500.0 || kb.getZ() > 500.0) {
            return;
        }
        double resistance = 1.0 - victim.getAttribute(Attribute.GENERIC_KNOCKBACK_RESISTANCE).getValue();
        kb.multiply(new Vector(resistance, 1.0, resistance));
        victim.setVelocity(kb);
        this.playerKnockback1dot8.put(victim.getUniqueId(), "");
        this.mybukkit.runTaskLater(victim, null, null, () -> this.playerKnockback1dot8.remove(victim.getUniqueId()), 2L);
    }

    public Hashtable<UUID, MyPlayer> getPlayersHash() {
        return this.playersHash;
    }

    public void ShowPlayerInArena() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            MyPlayer myPlayer = this.playersHash.get(player.getUniqueId());
            if (myPlayer == null || !myPlayer.isInPVPArena()) continue;
            this.mybukkit.sendActionBar(player, String.valueOf(ChatColor.GREEN) + "In pvpArena");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "org/pvp/pvponedoteight/PVPOneDotEight";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onEntityPlaceEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onPlayerMoveEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onEntitySpawnEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

