/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousmonsters.init;

import net.mcreator.luminousmonsters.entity.CherrySkeletonEntity;
import net.mcreator.luminousmonsters.entity.CherryZombieEntity;
import net.mcreator.luminousmonsters.entity.CrimsonWalkerEntity;
import net.mcreator.luminousmonsters.entity.DarkOakSkeletonEntity;
import net.mcreator.luminousmonsters.entity.DarkOakZombieEntity;
import net.mcreator.luminousmonsters.entity.GlacialSkeletonEntity;
import net.mcreator.luminousmonsters.entity.GlacialZombieEntity;
import net.mcreator.luminousmonsters.entity.HollowEntity;
import net.mcreator.luminousmonsters.entity.MinerSkeletonEntity;
import net.mcreator.luminousmonsters.entity.MinerZombieEntity;
import net.mcreator.luminousmonsters.entity.RevenantEntity;
import net.mcreator.luminousmonsters.entity.SavannaSkeletonEntity;
import net.mcreator.luminousmonsters.entity.SavannaZombieEntity;
import net.mcreator.luminousmonsters.entity.SunkenEntity;
import net.mcreator.luminousmonsters.entity.SwampSkeletonEntity;
import net.mcreator.luminousmonsters.entity.SwampZombieEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class LuminousMonstersModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"luminous_monsters");
    public static final DeferredHolder<EntityType<?>, EntityType<MinerZombieEntity>> MINER_ZOMBIE = LuminousMonstersModEntities.register("miner_zombie", EntityType.Builder.of(MinerZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<MinerSkeletonEntity>> MINER_SKELETON = LuminousMonstersModEntities.register("miner_skeleton", EntityType.Builder.of(MinerSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<GlacialZombieEntity>> GLACIAL_ZOMBIE = LuminousMonstersModEntities.register("glacial_zombie", EntityType.Builder.of(GlacialZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<GlacialSkeletonEntity>> GLACIAL_SKELETON = LuminousMonstersModEntities.register("glacial_skeleton", EntityType.Builder.of(GlacialSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SwampZombieEntity>> SWAMP_ZOMBIE = LuminousMonstersModEntities.register("swamp_zombie", EntityType.Builder.of(SwampZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SwampSkeletonEntity>> SWAMP_SKELETON = LuminousMonstersModEntities.register("swamp_skeleton", EntityType.Builder.of(SwampSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<DarkOakZombieEntity>> DARK_OAK_ZOMBIE = LuminousMonstersModEntities.register("dark_oak_zombie", EntityType.Builder.of(DarkOakZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<DarkOakSkeletonEntity>> DARK_OAK_SKELETON = LuminousMonstersModEntities.register("dark_oak_skeleton", EntityType.Builder.of(DarkOakSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<HollowEntity>> HOLLOW = LuminousMonstersModEntities.register("hollow", EntityType.Builder.of(HollowEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SunkenEntity>> SUNKEN = LuminousMonstersModEntities.register("sunken", EntityType.Builder.of(SunkenEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<CrimsonWalkerEntity>> CRIMSON_WALKER = LuminousMonstersModEntities.register("crimson_walker", EntityType.Builder.of(CrimsonWalkerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<RevenantEntity>> REVENANT = LuminousMonstersModEntities.register("revenant", EntityType.Builder.of(RevenantEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<CherryZombieEntity>> CHERRY_ZOMBIE = LuminousMonstersModEntities.register("cherry_zombie", EntityType.Builder.of(CherryZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<CherrySkeletonEntity>> CHERRY_SKELETON = LuminousMonstersModEntities.register("cherry_skeleton", EntityType.Builder.of(CherrySkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SavannaZombieEntity>> SAVANNA_ZOMBIE = LuminousMonstersModEntities.register("savanna_zombie", EntityType.Builder.of(SavannaZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SavannaSkeletonEntity>> SAVANNA_SKELETON = LuminousMonstersModEntities.register("savanna_skeleton", EntityType.Builder.of(SavannaSkeletonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 2.0f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            MinerZombieEntity.init();
            MinerSkeletonEntity.init();
            GlacialZombieEntity.init();
            GlacialSkeletonEntity.init();
            SwampZombieEntity.init();
            SwampSkeletonEntity.init();
            DarkOakZombieEntity.init();
            DarkOakSkeletonEntity.init();
            HollowEntity.init();
            SunkenEntity.init();
            CrimsonWalkerEntity.init();
            RevenantEntity.init();
            CherryZombieEntity.init();
            CherrySkeletonEntity.init();
            SavannaZombieEntity.init();
            SavannaSkeletonEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MINER_ZOMBIE.get(), MinerZombieEntity.createAttributes().build());
        event.put((EntityType)MINER_SKELETON.get(), MinerSkeletonEntity.createAttributes().build());
        event.put((EntityType)GLACIAL_ZOMBIE.get(), GlacialZombieEntity.createAttributes().build());
        event.put((EntityType)GLACIAL_SKELETON.get(), GlacialSkeletonEntity.createAttributes().build());
        event.put((EntityType)SWAMP_ZOMBIE.get(), SwampZombieEntity.createAttributes().build());
        event.put((EntityType)SWAMP_SKELETON.get(), SwampSkeletonEntity.createAttributes().build());
        event.put((EntityType)DARK_OAK_ZOMBIE.get(), DarkOakZombieEntity.createAttributes().build());
        event.put((EntityType)DARK_OAK_SKELETON.get(), DarkOakSkeletonEntity.createAttributes().build());
        event.put((EntityType)HOLLOW.get(), HollowEntity.createAttributes().build());
        event.put((EntityType)SUNKEN.get(), SunkenEntity.createAttributes().build());
        event.put((EntityType)CRIMSON_WALKER.get(), CrimsonWalkerEntity.createAttributes().build());
        event.put((EntityType)REVENANT.get(), RevenantEntity.createAttributes().build());
        event.put((EntityType)CHERRY_ZOMBIE.get(), CherryZombieEntity.createAttributes().build());
        event.put((EntityType)CHERRY_SKELETON.get(), CherrySkeletonEntity.createAttributes().build());
        event.put((EntityType)SAVANNA_ZOMBIE.get(), SavannaZombieEntity.createAttributes().build());
        event.put((EntityType)SAVANNA_SKELETON.get(), SavannaSkeletonEntity.createAttributes().build());
    }
}

