/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.events;

import fr.midaco.villagerquests.VillagerQuests;
import fr.midaco.villagerquests.gui.VillagerQuestDialog;
import fr.midaco.villagerquests.network.RequestOpenQuestMenuPacket;
import fr.midaco.villagerquests.quest.Quest;
import fr.midaco.villagerquests.quest.QuestManager;
import fr.midaco.villagerquests.villager.VillagerType;
import java.lang.reflect.Field;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="villagerquests", value={Dist.CLIENT})
public class ClientGuiHandler {
    private static String lastVillagerProfession = null;
    private static String lastVillagerType = null;
    private static int lastVillagerLevel = 1;
    private static int pendingQuestButtonVillagerId = -1;

    public static void setLastVillagerData(String profession, String type, int level) {
        lastVillagerProfession = profession;
        lastVillagerType = type;
        lastVillagerLevel = level;
    }

    public static String getLastVillagerProfession() {
        return lastVillagerProfession;
    }

    public static String getLastVillagerType() {
        return lastVillagerType;
    }

    public static int getLastVillagerLevel() {
        return lastVillagerLevel;
    }

    public static void setPendingQuestButtonVillagerId(int villagerEntityId) {
        pendingQuestButtonVillagerId = villagerEntityId;
    }

    @SubscribeEvent
    public static void onScreenInit(ScreenEvent.Init event) {
        Screen screen = event.getScreen();
        if (screen instanceof MerchantScreen) {
            Object menu2;
            MerchantScreen merchantScreen = (MerchantScreen)screen;
            Villager realVillager = null;
            try {
                menu2 = (MerchantMenu)merchantScreen.m_6262_();
                Field traderField = null;
                try {
                    traderField = menu2.getClass().getDeclaredField("trader");
                }
                catch (NoSuchFieldException e1) {
                    try {
                        traderField = menu2.getClass().getDeclaredField("f_");
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                if (traderField != null) {
                    traderField.setAccessible(true);
                    Object traderObj = traderField.get(menu2);
                    if (traderObj instanceof Villager) {
                        realVillager = (Villager)traderObj;
                    }
                }
            }
            catch (Exception menu2) {
                // empty catch block
            }
            if (realVillager != null) {
                menu2 = realVillager.m_20148_();
            }
            Villager realVillagerFinal = realVillager;
            int menuWidth = 276;
            int menuHeight = 166;
            int screenCenterX = merchantScreen.f_96543_ / 2;
            int screenCenterY = merchantScreen.f_96544_ / 2;
            int menuLeft = screenCenterX - menuWidth / 2;
            int menuTop = screenCenterY - menuHeight / 2;
            int questButtonX = menuLeft - 65;
            int questButtonY = menuTop + 18;
            event.addListener((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"Qu\u00eate"), btn -> VillagerQuests.NETWORK.sendToServer((Object)new RequestOpenQuestMenuPacket())).m_252987_(questButtonX, questButtonY, 60, 20).m_253136_());
        }
    }

    private static VillagerType getVillagerType(Villager villager) {
        if (villager == null) {
            return VillagerType.FARMER;
        }
        VillagerProfession profession = villager.m_7141_().m_35571_();
        String profName = profession != null ? profession.toString().toLowerCase() : "";
        Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)("Profession d\u00e9tect\u00e9e : " + profName)));
        if (profName.contains("farmer")) {
            return VillagerType.FARMER;
        }
        if (profName.contains("librarian")) {
            return VillagerType.LIBRARIAN;
        }
        if (profName.contains("cleric")) {
            return VillagerType.CLERIC;
        }
        if (profName.contains("armorer")) {
            return VillagerType.ARMORER;
        }
        if (profName.contains("butcher")) {
            return VillagerType.BUTCHER;
        }
        if (profName.contains("shepherd")) {
            return VillagerType.SHEPHERD;
        }
        if (profName.contains("fisherman")) {
            return VillagerType.FISHERMAN;
        }
        if (profName.contains("mason")) {
            return VillagerType.MASON;
        }
        if (profName.contains("toolsmith")) {
            return VillagerType.TOOLSMITH;
        }
        if (profName.contains("weaponsmith")) {
            return VillagerType.WEAPONSMITH;
        }
        if (profName.contains("leatherworker")) {
            return VillagerType.LEATHERWORKER;
        }
        if (profName.contains("cartographer")) {
            return VillagerType.CARTOGRAPHER;
        }
        if (profName.contains("nitwit")) {
            return VillagerType.NITWIT;
        }
        return VillagerType.FARMER;
    }

    private static VillagerType getVillagerTypeFromSyncedProfession() {
        String profName;
        String string = profName = lastVillagerProfession != null ? lastVillagerProfession.toLowerCase() : "";
        if (profName.contains("farmer")) {
            return VillagerType.FARMER;
        }
        if (profName.contains("librarian")) {
            return VillagerType.LIBRARIAN;
        }
        if (profName.contains("cleric")) {
            return VillagerType.CLERIC;
        }
        if (profName.contains("armorer")) {
            return VillagerType.ARMORER;
        }
        if (profName.contains("butcher")) {
            return VillagerType.BUTCHER;
        }
        if (profName.contains("shepherd")) {
            return VillagerType.SHEPHERD;
        }
        if (profName.contains("fisherman")) {
            return VillagerType.FISHERMAN;
        }
        if (profName.contains("mason")) {
            return VillagerType.MASON;
        }
        if (profName.contains("toolsmith")) {
            return VillagerType.TOOLSMITH;
        }
        if (profName.contains("weaponsmith")) {
            return VillagerType.WEAPONSMITH;
        }
        if (profName.contains("leatherworker")) {
            return VillagerType.LEATHERWORKER;
        }
        if (profName.contains("cartographer")) {
            return VillagerType.CARTOGRAPHER;
        }
        if (profName.contains("nitwit")) {
            return VillagerType.NITWIT;
        }
        return VillagerType.FARMER;
    }

    public static void openQuestMenuFromPacket(UUID villagerUUID, VillagerType villagerType, int villagerEntityId) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        String villagerId = villagerUUID.toString();
        Quest quest = QuestManager.getOrCreateQuestData((UUID)mc.f_91074_.m_20148_(), (String)villagerId, (VillagerType)villagerType).quest;
        mc.m_91152_((Screen)new VillagerQuestDialog(null, villagerUUID, villagerEntityId, quest, villagerType));
    }
}

