/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.events;

import com.mojang.logging.LogUtils;
import fr.midaco.villagerquests.VillagerQuests;
import fr.midaco.villagerquests.network.ShowQuestButtonPacket;
import fr.midaco.villagerquests.network.VillagerProfessionSyncPacket;
import fr.midaco.villagerquests.quest.ObjectiveType;
import fr.midaco.villagerquests.quest.Quest;
import fr.midaco.villagerquests.quest.QuestManager;
import fr.midaco.villagerquests.quest.QuestObjective;
import fr.midaco.villagerquests.villager.VillagerType;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="villagerquests")
public class QuestEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, Integer> lastVillagerInteracted = new ConcurrentHashMap<UUID, Integer>();

    @SubscribeEvent
    public static void onPlayerInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Entity entity = event.getTarget();
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            lastVillagerInteracted.put(player2.m_20148_(), villager.m_19879_());
            VillagerData data = villager.m_7141_();
            VillagerQuests.NETWORK.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new VillagerProfessionSyncPacket(data));
            VillagerType villagerType = QuestEventHandler.getVillagerType(villager);
            VillagerQuests.NETWORK.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new ShowQuestButtonPacket(villager.m_19879_()));
        }
    }

    public static VillagerType getVillagerType(Villager villager) {
        if (villager.m_7141_().m_35571_() != null) {
            String profession = villager.m_7141_().m_35571_().toString().toLowerCase();
            if (profession.contains("farmer")) {
                return VillagerType.FARMER;
            }
            if (profession.contains("fisherman")) {
                return VillagerType.FISHERMAN;
            }
            if (profession.contains("shepherd")) {
                return VillagerType.SHEPHERD;
            }
            if (profession.contains("butcher")) {
                return VillagerType.BUTCHER;
            }
            if (profession.contains("librarian")) {
                return VillagerType.LIBRARIAN;
            }
            if (profession.contains("cartographer")) {
                return VillagerType.CARTOGRAPHER;
            }
            if (profession.contains("cleric")) {
                return VillagerType.CLERIC;
            }
            if (profession.contains("armorer")) {
                return VillagerType.ARMORER;
            }
            if (profession.contains("weaponsmith")) {
                return VillagerType.WEAPONSMITH;
            }
            if (profession.contains("toolsmith")) {
                return VillagerType.TOOLSMITH;
            }
            if (profession.contains("mason")) {
                return VillagerType.MASON;
            }
            if (profession.contains("leatherworker")) {
                return VillagerType.LEATHERWORKER;
            }
        }
        return VillagerType.getRandomType();
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            String entityType = event.getEntity().m_6095_().toString();
            QuestEventHandler.updateQuestProgress(player, entityType, ObjectiveType.KILL_ENTITY);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            String blockType = event.getState().m_60734_().toString();
            QuestEventHandler.updateQuestProgress(player2, blockType, ObjectiveType.BREAK_BLOCK);
        }
    }

    @SubscribeEvent
    public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            String blockType = event.getPlacedBlock().m_60734_().toString();
            QuestEventHandler.updateQuestProgress(player, blockType, ObjectiveType.PLACE_BLOCK);
        }
    }

    private static void updateQuestProgress(ServerPlayer player, String target, ObjectiveType type) {
        UUID playerId = player.m_20148_();
        List<Quest> quests = QuestManager.getPlayerQuests(playerId);
        for (Quest quest : quests) {
            if (quest.isCompleted()) continue;
            for (QuestObjective objective : quest.getObjectives()) {
                if (objective.getType() != type || objective.isCompleted()) continue;
                boolean updated = false;
                switch (type) {
                    case KILL_ENTITY: {
                        if (objective.getTargetEntity() == null || !target.contains(objective.getTargetEntity())) break;
                        objective.incrementProgress(1);
                        updated = true;
                        break;
                    }
                    case BREAK_BLOCK: 
                    case PLACE_BLOCK: {
                        if (objective.getTargetBlock() == null || !target.contains(objective.getTargetBlock())) break;
                        objective.incrementProgress(1);
                        updated = true;
                        break;
                    }
                }
                if (!updated || !objective.isCompleted()) continue;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7aObjectif termin\u00e9 : " + objective.getDescription())));
            }
            if (!quest.checkCompletion()) continue;
            QuestManager.completeQuest(player.m_20148_(), quest.getVillagerId(), player);
        }
    }

    public static void updateGatherQuests(ServerPlayer player, ItemStack item) {
        UUID playerId = player.m_20148_();
        List<Quest> quests = QuestManager.getPlayerQuests(playerId);
        for (Quest quest : quests) {
            if (quest.isCompleted()) continue;
            for (QuestObjective objective : quest.getObjectives()) {
                if (objective.getType() != ObjectiveType.GATHER_ITEM || objective.isCompleted() || objective.getTargetItem() == null || !ItemStack.m_150942_((ItemStack)objective.getTargetItem(), (ItemStack)item)) continue;
                objective.incrementProgress(item.m_41613_());
                if (!objective.isCompleted()) continue;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7aObjectif termin\u00e9 : " + objective.getDescription())));
            }
            if (!quest.checkCompletion()) continue;
            QuestManager.completeQuest(player.m_20148_(), quest.getVillagerId(), player);
        }
    }

    public static Integer getLastVillagerInteracted(UUID playerUUID) {
        return lastVillagerInteracted.get(playerUUID);
    }

    public static void handleCompleteQuestPacket(UUID villagerUUID, int villagerEntityId, ServerPlayer player) {
        if (player == null) {
            return;
        }
        String villagerId = villagerUUID.toString();
        QuestManager.PlayerVillagerQuestData questData = QuestManager.getOrCreateQuestData(player.m_20148_(), villagerId, QuestEventHandler.getVillagerTypeFromEntityId(player, villagerEntityId));
        if (questData == null || questData.quest == null) {
            return;
        }
        boolean allOk = true;
        for (QuestObjective objective : questData.quest.getObjectives()) {
            if (objective.isCompleted() || objective.getType() != ObjectiveType.GATHER_ITEM || objective.getTargetItem() == null) continue;
            int count = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)objective.getTargetItem())) continue;
                count += stack.m_41613_();
            }
            if (count >= objective.getRequiredAmount()) continue;
            allOk = false;
            break;
        }
        if (!allOk) {
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7cVous n'avez pas tous les objets requis pour rendre la qu\u00eate !"));
            return;
        }
        block2: for (QuestObjective objective : questData.quest.getObjectives()) {
            if (objective.isCompleted() || objective.getType() != ObjectiveType.GATHER_ITEM || objective.getTargetItem() == null) continue;
            int toRemove = objective.getRequiredAmount();
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                ItemStack stack;
                stack = (ItemStack)player.m_150109_().f_35974_.get(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)objective.getTargetItem())) continue;
                int remove = Math.min(stack.m_41613_(), toRemove);
                stack.m_41774_(remove);
                if ((toRemove -= remove) <= 0) continue block2;
            }
        }
        QuestManager.completeQuest(player.m_20148_(), villagerId, player);
        player.m_213846_((Component)Component.m_237113_((String)"\u00a7aQu\u00eate rendue ! R\u00e9compense re\u00e7ue."));
    }

    private static VillagerType getVillagerTypeFromEntityId(ServerPlayer player, int entityId) {
        Entity entity = player.m_9236_().m_6815_(entityId);
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            return QuestEventHandler.getVillagerType(villager);
        }
        return VillagerType.FARMER;
    }
}

