/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.network;

import fr.midaco.villagerquests.events.ClientGuiHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class VillagerProfessionSyncPacket {
    private final String profession;
    private final String type;
    private final int level;

    public VillagerProfessionSyncPacket(VillagerData data) {
        this.profession = data.m_35571_().toString();
        this.type = data.m_35560_().toString();
        this.level = data.m_35576_();
    }

    public VillagerProfessionSyncPacket(String profession, String type, int level) {
        this.profession = profession;
        this.type = type;
        this.level = level;
    }

    public VillagerProfessionSyncPacket(FriendlyByteBuf buf) {
        this.profession = buf.m_130277_();
        this.type = buf.m_130277_();
        this.level = buf.m_130242_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.profession);
        buf.m_130070_(this.type);
        buf.m_130130_(this.level);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> VillagerProfessionSyncPacket.handleClient(this.profession, this.type, this.level));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(String profession, String type, int level) {
        ClientGuiHandler.setLastVillagerData(profession, type, level);
    }

    public String getProfession() {
        return this.profession;
    }

    public String getType() {
        return this.type;
    }

    public int getLevel() {
        return this.level;
    }
}

