/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.quest;

import fr.midaco.villagerquests.quest.ObjectiveType;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class QuestObjective {
    private String id;
    private String description;
    private ObjectiveType type;
    private ItemStack targetItem;
    private String targetEntity;
    private String targetBlock;
    private int requiredAmount;
    private int currentAmount;
    private boolean completed;

    public QuestObjective(String id, String description, ObjectiveType type, int requiredAmount) {
        this.id = id;
        this.description = description;
        this.type = type;
        this.requiredAmount = requiredAmount;
        this.currentAmount = 0;
        this.completed = false;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public ObjectiveType getType() {
        return this.type;
    }

    public ItemStack getTargetItem() {
        return this.targetItem;
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public String getTargetBlock() {
        return this.targetBlock;
    }

    public int getRequiredAmount() {
        return this.requiredAmount;
    }

    public int getCurrentAmount() {
        return this.currentAmount;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setTargetItem(ItemStack targetItem) {
        this.targetItem = targetItem;
    }

    public void setTargetEntity(String targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setTargetBlock(String targetBlock) {
        this.targetBlock = targetBlock;
    }

    public void setCurrentAmount(int currentAmount) {
        this.currentAmount = currentAmount;
        this.checkCompletion();
    }

    public void incrementProgress(int amount) {
        this.currentAmount += amount;
        this.checkCompletion();
    }

    public void checkCompletion() {
        this.completed = this.currentAmount >= this.requiredAmount;
    }

    public float getProgress() {
        return Math.min(1.0f, (float)this.currentAmount / (float)this.requiredAmount);
    }

    public String getProgressText() {
        return this.currentAmount + "/" + this.requiredAmount;
    }

    public boolean isFulfilledByInventory(LocalPlayer player) {
        if (this.getType() == ObjectiveType.GATHER_ITEM && this.getTargetItem() != null) {
            int count = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.getTargetItem())) continue;
                count += stack.m_41613_();
            }
            return count >= this.getRequiredAmount();
        }
        return false;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id);
        tag.m_128359_("description", this.description);
        tag.m_128359_("type", this.type.name());
        tag.m_128405_("requiredAmount", this.requiredAmount);
        tag.m_128405_("currentAmount", this.currentAmount);
        tag.m_128379_("completed", this.completed);
        if (this.targetItem != null) {
            CompoundTag itemTag = new CompoundTag();
            this.targetItem.m_41739_(itemTag);
            tag.m_128365_("targetItem", (Tag)itemTag);
        }
        if (this.targetEntity != null) {
            tag.m_128359_("targetEntity", this.targetEntity);
        }
        if (this.targetBlock != null) {
            tag.m_128359_("targetBlock", this.targetBlock);
        }
        return tag;
    }

    public static QuestObjective load(CompoundTag tag) {
        String id = tag.m_128461_("id");
        String description = tag.m_128461_("description");
        ObjectiveType type = ObjectiveType.valueOf(tag.m_128461_("type"));
        int requiredAmount = tag.m_128451_("requiredAmount");
        QuestObjective objective = new QuestObjective(id, description, type, requiredAmount);
        objective.currentAmount = tag.m_128451_("currentAmount");
        objective.completed = tag.m_128471_("completed");
        if (tag.m_128441_("targetItem")) {
            objective.targetItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("targetItem"));
        }
        if (tag.m_128441_("targetEntity")) {
            objective.targetEntity = tag.m_128461_("targetEntity");
        }
        if (tag.m_128441_("targetBlock")) {
            objective.targetBlock = tag.m_128461_("targetBlock");
        }
        return objective;
    }
}

