/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.utils;

import fr.midaco.villagerquests.villager.VillagerType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class QuestUtils {
    public static String getQuestTitleKey(VillagerType villagerType) {
        return switch (villagerType) {
            case VillagerType.FARMER -> "quest.villager.farmer.title";
            case VillagerType.FISHERMAN -> "quest.villager.fisherman.title";
            case VillagerType.SHEPHERD -> "quest.villager.shepherd.title";
            case VillagerType.BUTCHER -> "quest.villager.butcher.title";
            case VillagerType.LIBRARIAN -> "quest.villager.librarian.title";
            case VillagerType.CARTOGRAPHER -> "quest.villager.cartographer.title";
            case VillagerType.CLERIC -> "quest.villager.cleric.title";
            case VillagerType.ARMORER -> "quest.villager.armorer.title";
            case VillagerType.WEAPONSMITH -> "quest.villager.weaponsmith.title";
            case VillagerType.TOOLSMITH -> "quest.villager.toolsmith.title";
            case VillagerType.MASON -> "quest.villager.mason.title";
            case VillagerType.LEATHERWORKER -> "quest.villager.leatherworker.title";
            case VillagerType.NITWIT -> "quest.villager.nitwit.title";
            default -> "quest.villager.default.title";
        };
    }

    public static String getQuestDescKey(VillagerType villagerType) {
        return switch (villagerType) {
            case VillagerType.FARMER -> "quest.villager.farmer.desc";
            case VillagerType.FISHERMAN -> "quest.villager.fisherman.desc";
            case VillagerType.SHEPHERD -> "quest.villager.shepherd.desc";
            case VillagerType.BUTCHER -> "quest.villager.butcher.desc";
            case VillagerType.LIBRARIAN -> "quest.villager.librarian.desc";
            case VillagerType.CARTOGRAPHER -> "quest.villager.cartographer.desc";
            case VillagerType.CLERIC -> "quest.villager.cleric.desc";
            case VillagerType.ARMORER -> "quest.villager.armorer.desc";
            case VillagerType.WEAPONSMITH -> "quest.villager.weaponsmith.desc";
            case VillagerType.TOOLSMITH -> "quest.villager.toolsmith.desc";
            case VillagerType.MASON -> "quest.villager.mason.desc";
            case VillagerType.LEATHERWORKER -> "quest.villager.leatherworker.desc";
            case VillagerType.NITWIT -> "quest.villager.nitwit.desc";
            default -> "quest.villager.default.desc";
        };
    }

    public static Component getQuestTitleComponent(VillagerType villagerType) {
        return Component.m_237115_((String)QuestUtils.getQuestTitleKey(villagerType));
    }

    public static Component getQuestDescComponent(VillagerType villagerType) {
        return Component.m_237115_((String)QuestUtils.getQuestDescKey(villagerType));
    }

    public static Component getItemDisplayName(ItemStack item) {
        return item.m_41786_();
    }

    public static int getRequiredAmountForItem(ItemStack item) {
        String itemName;
        return switch (itemName = item.m_41720_().toString().toLowerCase().replace("minecraft:", "")) {
            case "diamond", "emerald", "netherite_ingot" -> 1;
            case "iron_ingot", "gold_ingot", "coal" -> 3;
            case "wheat", "potato", "carrot", "beetroot" -> 8;
            case "cod", "salmon" -> 5;
            case "wool", "leather" -> 4;
            case "beef", "porkchop", "mutton", "chicken", "rabbit" -> 6;
            default -> 2;
        };
    }
}

