/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fr.midaco.villagerquests.quest.Quest;
import fr.midaco.villagerquests.quest.QuestManager;
import fr.midaco.villagerquests.quest.QuestObjective;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="villagerquests")
public class QuestCommand {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"quest").requires(source -> source.m_6761_(0))).then(Commands.m_82127_((String)"list").executes(context -> QuestCommand.listQuests((CommandSourceStack)context.getSource())))).then(Commands.m_82127_((String)"info").then(Commands.m_82129_((String)"questId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> QuestCommand.showQuestInfo((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"questId")))))).then(Commands.m_82127_((String)"abandon").then(Commands.m_82129_((String)"questId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> QuestCommand.abandonQuest((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"questId")))))).then(Commands.m_82127_((String)"complete").then(Commands.m_82129_((String)"questId", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> QuestCommand.completeQuest((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"questId")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"give").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> QuestCommand.giveQuestToPlayer((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(context -> QuestCommand.clearPlayerQuests((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player")))))));
    }

    private static int listQuests(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"Cette commande ne peut \u00eatre utilis\u00e9e que par un joueur."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerId = player.m_20148_();
        List<Map.Entry<String, Quest>> activeQuests = QuestManager.getActiveQuestsWithVillagerIds(playerId);
        if (activeQuests.isEmpty()) {
            source.m_288197_(() -> Component.m_237115_((String)"villagerquests.command.list.empty"), false);
            return 0;
        }
        source.m_288197_(() -> Component.m_237115_((String)"villagerquests.command.list.title"), false);
        for (int i = 0; i < activeQuests.size(); ++i) {
            int idx = i;
            Map.Entry<String, Quest> entry = activeQuests.get(i);
            Quest quest = entry.getValue();
            String status = quest.isCompleted() ? "\u00a7a\u2713 " + Component.m_237115_((String)"villagerquests.quest.status.completed").getString() : "\u00a7e\u25cb " + Component.m_237115_((String)"villagerquests.quest.status.in_progress").getString();
            float progress = quest.getProgress() * 100.0f;
            String questTitle = quest.getTitle();
            source.m_288197_(() -> Component.m_237113_((String)String.format("\u00a77%d. \u00a7f%s \u00a77(%s) \u00a78[%.1f%%]", idx + 1, questTitle, status, Float.valueOf(progress))), false);
        }
        return activeQuests.size();
    }

    private static int showQuestInfo(CommandSourceStack source, int questId) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"Cette commande ne peut \u00eatre utilis\u00e9e que par un joueur."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerId = player.m_20148_();
        List<Map.Entry<String, Quest>> activeQuests = QuestManager.getActiveQuestsWithVillagerIds(playerId);
        if (questId < 1 || questId > activeQuests.size()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cID de qu\u00eate invalide."));
            return 0;
        }
        Map.Entry<String, Quest> entry = activeQuests.get(questId - 1);
        Quest quest = entry.getValue();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7a=== " + quest.getTitle() + " ===")), false);
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77" + quest.getDescription())), false);
        source.m_288197_(() -> Component.m_237110_((String)"villagerquests.command.info.type", (Object[])new Object[]{quest.getType().getDisplayName()}), false);
        if (!quest.getObjectives().isEmpty()) {
            source.m_288197_(() -> Component.m_237115_((String)"villagerquests.command.info.objectives"), false);
            for (int i = 0; i < quest.getObjectives().size(); ++i) {
                QuestObjective objective = quest.getObjectives().get(i);
                String status = objective.isCompleted() ? "\u00a7a\u2713" : "\u00a7e\u25cb";
                source.m_288197_(() -> Component.m_237113_((String)String.format("  %s %s \u00a77(%s)", status, objective.getDescription(), objective.getProgressText())), false);
            }
        }
        if (!quest.getRewards().isEmpty()) {
            source.m_288197_(() -> Component.m_237115_((String)"villagerquests.command.info.rewards"), false);
            for (ItemStack reward : quest.getRewards()) {
                source.m_288197_(() -> Component.m_237113_((String)("  \u00a77- " + reward.m_41613_() + "x " + reward.m_41611_().getString())), false);
            }
        }
        if (quest.getExperienceReward() > 0) {
            source.m_288197_(() -> Component.m_237110_((String)"villagerquests.command.info.experience", (Object[])new Object[]{quest.getExperienceReward()}), false);
        }
        return 1;
    }

    private static int abandonQuest(CommandSourceStack source, int questId) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"Cette commande ne peut \u00eatre utilis\u00e9e que par un joueur."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerId = player.m_20148_();
        List<Map.Entry<String, Quest>> activeQuests = QuestManager.getActiveQuestsWithVillagerIds(playerId);
        if (questId < 1 || questId > activeQuests.size()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cID de qu\u00eate invalide."));
            return 0;
        }
        Map.Entry<String, Quest> entry = activeQuests.get(questId - 1);
        String villagerId = entry.getKey();
        Quest quest = entry.getValue();
        if (QuestManager.abandonQuest(playerId, villagerId)) {
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7cQu\u00eate abandonn\u00e9e : " + quest.getTitle())), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)"\u00a7cImpossible d'abandonner cette qu\u00eate."));
        return 0;
    }

    private static int completeQuest(CommandSourceStack source, int questId) {
        Entity entity = source.m_81373_();
        if (!(entity instanceof ServerPlayer)) {
            source.m_81352_((Component)Component.m_237113_((String)"Cette commande ne peut \u00eatre utilis\u00e9e que par un joueur."));
            return 0;
        }
        ServerPlayer player = (ServerPlayer)entity;
        UUID playerId = player.m_20148_();
        List<Quest> quests = QuestManager.getPlayerQuests(playerId);
        if (questId < 1 || questId > quests.size()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cID de qu\u00eate invalide."));
            return 0;
        }
        Quest quest = quests.get(questId - 1);
        if (!quest.isCompleted()) {
            source.m_81352_((Component)Component.m_237113_((String)"\u00a7cCette qu\u00eate n'est pas encore termin\u00e9e."));
            return 0;
        }
        QuestManager.completeQuest(player.m_20148_(), quest.getVillagerId(), player);
        return 1;
    }

    private static int giveQuestToPlayer(CommandSourceStack source, ServerPlayer targetPlayer) {
        String villagerId = "admin_command";
        if (QuestManager.offerQuestToPlayer(targetPlayer, villagerId, null)) {
            source.m_288197_(() -> Component.m_237113_((String)("\u00a7aQu\u00eate donn\u00e9e \u00e0 " + targetPlayer.m_7755_().getString())), false);
            return 1;
        }
        source.m_81352_((Component)Component.m_237113_((String)("\u00a7cImpossible de donner une qu\u00eate \u00e0 " + targetPlayer.m_7755_().getString())));
        return 0;
    }

    private static int clearPlayerQuests(CommandSourceStack source, ServerPlayer targetPlayer) {
        UUID playerId = targetPlayer.m_20148_();
        List<Quest> quests = QuestManager.getPlayerQuests(playerId);
        int count = quests.size();
        quests.clear();
        source.m_288197_(() -> Component.m_237113_((String)("\u00a7a" + count + " qu\u00eates supprim\u00e9es pour " + targetPlayer.m_7755_().getString())), false);
        return count;
    }
}

