/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.midaco.villagerquests.VillagerQuests;
import fr.midaco.villagerquests.network.CompleteQuestPacket;
import fr.midaco.villagerquests.quest.ObjectiveType;
import fr.midaco.villagerquests.quest.Quest;
import fr.midaco.villagerquests.quest.QuestManager;
import fr.midaco.villagerquests.quest.QuestObjective;
import fr.midaco.villagerquests.utils.QuestUtils;
import fr.midaco.villagerquests.villager.VillagerType;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;

public class VillagerQuestDialog
extends Screen {
    private final Villager villager = null;
    private final Quest quest;
    private final Screen parent;
    private final VillagerType villagerType;
    private final String villagerId;
    private QuestManager.PlayerVillagerQuestData questData;
    private final UUID villagerUUID;
    private final int villagerEntityId;

    public VillagerQuestDialog(Screen parent, UUID villagerUUID, int villagerEntityId, Quest quest, VillagerType villagerType) {
        super((Component)Component.m_237115_((String)"villagerquests.dialog.title"));
        this.quest = quest;
        this.parent = parent;
        this.villagerType = villagerType;
        this.villagerUUID = villagerUUID;
        this.villagerId = villagerUUID != null ? villagerUUID.toString() : "unknown";
        this.villagerEntityId = villagerEntityId;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_6915_();
            this.questData = QuestManager.getOrCreateQuestData(player.m_20148_(), this.villagerId, villagerType);
        }
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int buttonYOffset = 60;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (this.questData == null || player == null) {
            return;
        }
        this.m_169413_();
        switch (this.questData.state) {
            case AVAILABLE: {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.yes"), btn -> {
                    QuestManager.acceptQuest(player.m_20148_(), this.villagerId);
                    CompoundTag playerData = player.getPersistentData();
                    QuestManager.savePlayerQuests(player.m_20148_(), playerData);
                    this.closeQuestDialog();
                }).m_252987_(centerX - 80, centerY + buttonYOffset, 50, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.no"), btn -> {
                    QuestManager.refuseQuest(player.m_20148_(), this.villagerId);
                    CompoundTag playerData = player.getPersistentData();
                    QuestManager.savePlayerQuests(player.m_20148_(), playerData);
                    this.closeQuestDialog();
                }).m_252987_(centerX - 15, centerY + buttonYOffset, 50, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.close"), btn -> this.closeQuestDialog()).m_252987_(centerX + 50, centerY + buttonYOffset, 50, 20).m_253136_());
                break;
            }
            case ACCEPTED: {
                boolean canComplete;
                boolean bl = canComplete = this.questData.quest != null && this.hasAllQuestItems() && !this.questData.quest.isCompleted();
                if (canComplete) {
                    this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.turn_in"), btn -> {
                        VillagerQuests.NETWORK.sendToServer((Object)new CompleteQuestPacket(this.villagerUUID, this.villagerEntityId));
                        this.closeQuestDialog();
                    }).m_252987_(centerX - 100, centerY + buttonYOffset, 120, 20).m_253136_());
                    this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.close"), btn -> this.closeQuestDialog()).m_252987_(centerX + 30, centerY + buttonYOffset, 50, 20).m_253136_());
                    break;
                }
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.close"), btn -> this.closeQuestDialog()).m_252987_(centerX - 40, centerY + buttonYOffset, 80, 20).m_253136_());
                break;
            }
            case COMPLETED: {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.close"), btn -> this.closeQuestDialog()).m_252987_(centerX - 40, centerY + buttonYOffset, 80, 20).m_253136_());
                break;
            }
            case REFUSED: {
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.yes"), btn -> {
                    QuestManager.acceptQuest(player.m_20148_(), this.villagerId);
                    CompoundTag playerData = player.getPersistentData();
                    QuestManager.savePlayerQuests(player.m_20148_(), playerData);
                    this.closeQuestDialog();
                }).m_252987_(centerX - 80, centerY + buttonYOffset, 50, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.no"), btn -> this.closeQuestDialog()).m_252987_(centerX - 15, centerY + buttonYOffset, 50, 20).m_253136_());
                this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"villagerquests.button.close"), btn -> this.closeQuestDialog()).m_252987_(centerX + 50, centerY + buttonYOffset, 50, 20).m_253136_());
            }
        }
    }

    private void closeQuestDialog() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.m_6915_();
        }
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    /*
     * WARNING - void declaration
     */
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Entity entity;
        this.m_280273_(guiGraphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int dialogWidth = 300;
        int dialogHeight = 250;
        int dialogX = centerX - dialogWidth / 2;
        int dialogY = centerY - dialogHeight / 2;
        guiGraphics.m_280509_(dialogX, dialogY, dialogX + dialogWidth, dialogY + dialogHeight, -2013265920);
        guiGraphics.m_280509_(dialogX, dialogY, dialogX + dialogWidth, dialogY + 1, -1);
        guiGraphics.m_280509_(dialogX, dialogY + dialogHeight - 1, dialogX + dialogWidth, dialogY + dialogHeight, -1);
        guiGraphics.m_280509_(dialogX, dialogY, dialogX + 1, dialogY + dialogHeight, -1);
        guiGraphics.m_280509_(dialogX + dialogWidth - 1, dialogY, dialogX + dialogWidth, dialogY + dialogHeight, -1);
        int villagerX = dialogX + 20;
        int villagerY = dialogY + 20;
        Villager villagerToRender = null;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.m_9236_() != null && (entity = player.m_9236_().m_6815_(this.villagerEntityId)) instanceof Villager) {
            Villager v;
            villagerToRender = v = (Villager)entity;
        }
        if (villagerToRender != null) {
            this.renderVillager(guiGraphics, villagerX, villagerY, villagerToRender);
        }
        int infoX = villagerX + 60;
        int infoY = dialogY + 20;
        MutableComponent villagerName = this.villagerType != null ? this.villagerType.getDisplayName() : Component.m_237115_((String)"villagerquests.villager.default_name");
        guiGraphics.m_280430_(this.f_96547_, (Component)villagerName, infoX, infoY, 0xFFFFFF);
        if (this.questData == null) {
            return;
        }
        switch (this.questData.state) {
            case AVAILABLE: 
            case REFUSED: {
                if (this.questData.quest != null) {
                    guiGraphics.m_280430_(this.f_96547_, QuestUtils.getQuestTitleComponent(this.villagerType), infoX, infoY + 20, 0xFFFF00);
                    int maxWidth = 200;
                    List wrappedDesc = this.f_96547_.m_92923_((FormattedText)QuestUtils.getQuestDescComponent(this.villagerType), maxWidth);
                    int descY = infoY + 35;
                    for (Object line : wrappedDesc) {
                        guiGraphics.m_280648_(this.f_96547_, (FormattedCharSequence)line, infoX, descY, 0xCCCCCC);
                        descY += 10;
                    }
                    int objY = descY + 5;
                    guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.objectives"), infoX, objY, 65280);
                    objY += 12;
                    for (QuestObjective questObjective : this.questData.quest.getObjectives()) {
                        Object progressText = questObjective.getProgressText();
                        if (questObjective.getType() == ObjectiveType.GATHER_ITEM && player != null) {
                            int inInventory = 0;
                            for (ItemStack stack : player.m_150109_().f_35974_) {
                                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)questObjective.getTargetItem())) continue;
                                inInventory += stack.m_41613_();
                            }
                            progressText = Math.max(questObjective.getCurrentAmount(), inInventory) + "/" + questObjective.getRequiredAmount();
                        }
                        MutableComponent desc = Component.m_237113_((String)questObjective.getDescription());
                        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)"- ").m_7220_((Component)desc).m_7220_((Component)Component.m_237113_((String)(" (" + (String)progressText + ")"))), infoX, objY, 0xAAAAAA);
                        objY += 10;
                    }
                    int rewardY = objY + 5;
                    guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.rewards"), infoX, rewardY, 0xFFAA00);
                    rewardY += 12;
                    for (ItemStack reward : this.questData.quest.getRewards()) {
                        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("- " + reward.m_41613_() + "x " + reward.m_41611_().getString())), infoX, rewardY, 0xAAFFAA);
                        rewardY += 10;
                    }
                    if (this.questData.quest.getExperienceReward() <= 0) break;
                    guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)("- " + this.questData.quest.getExperienceReward() + " XP")), infoX, rewardY, 0xAAAAFF);
                    break;
                }
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.no_quest"), infoX, infoY + 20, 0xFF0000);
                break;
            }
            case ACCEPTED: {
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.accepted_1"), infoX, infoY + 20, 65280);
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.accepted_2"), infoX, infoY + 35, 65280);
                if (this.questData.quest == null) break;
                float progress = this.questData.quest.getProgress() * 100.0f;
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"villagerquests.dialog.progress", (Object[])new Object[]{String.format("%.1f", Float.valueOf(progress))}), infoX, infoY + 55, 0xFFFF00);
                int objY = infoY + 75;
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.objectives"), infoX, objY, 65280);
                objY += 12;
                for (QuestObjective objective : this.questData.quest.getObjectives()) {
                    void var23_34;
                    String status = objective.isCompleted() ? "\u00a7a\u2713" : "\u00a7e\u25cb";
                    String string = objective.getProgressText();
                    int color = 0xAAAAAA;
                    String icon = "";
                    switch (objective.getType()) {
                        case GATHER_ITEM: {
                            icon = " [\ud83d\udce6] ";
                            color = 16766720;
                            break;
                        }
                        case KILL_ENTITY: 
                        case HUNT_ANIMAL: {
                            icon = " [\ud83d\udde1] ";
                            color = 0xFF5555;
                            break;
                        }
                        case CRAFT_ITEM: {
                            icon = " [\u2692] ";
                            color = 0x55FFFF;
                            break;
                        }
                        case DELIVER_ITEM: {
                            icon = " [\ud83d\udce4] ";
                            color = 0x55FF55;
                            break;
                        }
                        case INTERACT_WITH_ENTITY: {
                            icon = " [\ud83e\udd1d] ";
                            color = 0xAAAAFF;
                            break;
                        }
                        case FISH_ITEM: {
                            icon = " [\ud83d\udc1f] ";
                            color = 0x55AAFF;
                            break;
                        }
                        case FARM_CROP: {
                            icon = " [\ud83c\udf3e] ";
                            color = 10551152;
                            break;
                        }
                        case FIND_SPECIAL_ITEM: {
                            icon = " [\ud83d\udc8e] ";
                            color = 0xAA00FF;
                            break;
                        }
                        default: {
                            icon = " [-] ";
                            color = 0xAAAAAA;
                        }
                    }
                    if (objective.getType() == ObjectiveType.GATHER_ITEM && player != null) {
                        int inInventory = 0;
                        for (ItemStack stack : player.m_150109_().f_35974_) {
                            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)objective.getTargetItem())) continue;
                            inInventory += stack.m_41613_();
                        }
                        String string2 = Math.max(objective.getCurrentAmount(), inInventory) + "/" + objective.getRequiredAmount();
                    }
                    MutableComponent desc = Component.m_237113_((String)objective.getDescription());
                    guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237113_((String)(status + " " + icon)).m_7220_((Component)desc).m_7220_((Component)Component.m_237113_((String)(" (" + (String)var23_34 + ")"))), infoX, objY, color);
                    objY += 12;
                }
                break;
            }
            case COMPLETED: {
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.completed"), infoX, infoY + 20, 0xAAAAAA);
                guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"villagerquests.dialog.come_back"), infoX, infoY + 35, 0xAAAAAA);
            }
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderVillager(GuiGraphics guiGraphics, int x, int y, Villager villagerToRender) {
        if (villagerToRender == null) {
            return;
        }
        villagerToRender.f_20883_ = 180.0f;
        villagerToRender.m_146922_(180.0f);
        villagerToRender.m_146926_(0.0f);
        villagerToRender.f_20885_ = 180.0f;
        villagerToRender.f_20886_ = 180.0f;
        VillagerQuestDialog.renderEntityInInventoryVanilla(x + 15, y + 90, 30, (LivingEntity)villagerToRender);
    }

    public static void renderEntityInInventoryVanilla(int x, int y, int scale, LivingEntity entity) {
        if (entity == null) {
            return;
        }
        float oldBodyYaw = entity.f_20883_;
        float oldYaw = entity.m_146908_();
        float oldPitch = entity.m_146909_();
        float oldHeadYaw = entity.f_20885_;
        float oldHeadYawO = entity.f_20886_;
        entity.f_20883_ = 180.0f;
        entity.m_146922_(180.0f);
        entity.m_146926_(0.0f);
        entity.f_20885_ = 180.0f;
        entity.f_20886_ = 180.0f;
        EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
        dispatcher.m_114468_(false);
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 50.0);
        poseStack.m_85841_((float)scale, (float)scale, (float)(-scale));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        dispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, poseStack, (MultiBufferSource)bufferSource, 0xF000F0);
        bufferSource.m_109911_();
        poseStack.m_85849_();
        dispatcher.m_114468_(true);
        entity.f_20883_ = oldBodyYaw;
        entity.m_146922_(oldYaw);
        entity.m_146926_(oldPitch);
        entity.f_20885_ = oldHeadYaw;
        entity.f_20886_ = oldHeadYawO;
    }

    public boolean m_7043_() {
        return false;
    }

    private boolean hasAllQuestItems() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || this.questData == null || this.questData.quest == null) {
            return false;
        }
        for (QuestObjective objective : this.questData.quest.getObjectives()) {
            if (objective.isCompleted() || objective.isFulfilledByInventory(player)) continue;
            return false;
        }
        return true;
    }
}

