/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.network;

import fr.midaco.villagerquests.events.QuestEventHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CompleteQuestPacket {
    private final UUID villagerUUID;
    private final int villagerEntityId;

    public CompleteQuestPacket(UUID villagerUUID, int villagerEntityId) {
        this.villagerUUID = villagerUUID;
        this.villagerEntityId = villagerEntityId;
    }

    public CompleteQuestPacket(FriendlyByteBuf buf) {
        this.villagerUUID = buf.m_130259_();
        this.villagerEntityId = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.villagerUUID);
        buf.writeInt(this.villagerEntityId);
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.encode(buf);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                QuestEventHandler.handleCompleteQuestPacket(this.villagerUUID, this.villagerEntityId, player);
            }
        });
        return true;
    }
}

