/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.network;

import fr.midaco.villagerquests.events.ClientGuiHandler;
import fr.midaco.villagerquests.villager.VillagerType;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class OpenQuestMenuPacket {
    private final UUID villagerUUID;
    private final VillagerType villagerType;
    private final int villagerEntityId;

    public OpenQuestMenuPacket(UUID villagerUUID, VillagerType villagerType, int villagerEntityId) {
        this.villagerUUID = villagerUUID;
        this.villagerType = villagerType;
        this.villagerEntityId = villagerEntityId;
    }

    public OpenQuestMenuPacket(FriendlyByteBuf buf) {
        this.villagerUUID = buf.m_130259_();
        this.villagerType = VillagerType.valueOf(buf.m_130277_());
        this.villagerEntityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.villagerUUID);
        buf.m_130070_(this.villagerType.name());
        buf.writeInt(this.villagerEntityId);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientGuiHandler.openQuestMenuFromPacket(this.villagerUUID, this.villagerType, this.villagerEntityId));
        ctx.get().setPacketHandled(true);
    }

    public UUID getVillagerUUID() {
        return this.villagerUUID;
    }

    public VillagerType getVillagerType() {
        return this.villagerType;
    }

    public int getVillagerEntityId() {
        return this.villagerEntityId;
    }
}

