/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.quest;

import fr.midaco.villagerquests.quest.QuestObjective;
import fr.midaco.villagerquests.quest.QuestType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class Quest {
    private String id;
    private String title;
    private String description;
    private QuestType type;
    private List<QuestObjective> objectives;
    private List<ItemStack> rewards;
    private int experienceReward;
    private boolean completed;
    private long startTime;
    private long completionTime;
    private String villagerId;

    public Quest(String id, String title, String description, QuestType type, String villagerId) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.type = type;
        this.villagerId = villagerId;
        this.objectives = new ArrayList<QuestObjective>();
        this.rewards = new ArrayList<ItemStack>();
        this.completed = false;
        this.startTime = System.currentTimeMillis();
        this.experienceReward = 0;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public QuestType getType() {
        return this.type;
    }

    public List<QuestObjective> getObjectives() {
        return this.objectives;
    }

    public List<ItemStack> getRewards() {
        return this.rewards;
    }

    public int getExperienceReward() {
        return this.experienceReward;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getCompletionTime() {
        return this.completionTime;
    }

    public String getVillagerId() {
        return this.villagerId;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
        if (completed) {
            this.completionTime = System.currentTimeMillis();
        }
    }

    public void setExperienceReward(int experienceReward) {
        this.experienceReward = experienceReward;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addObjective(QuestObjective objective) {
        this.objectives.add(objective);
    }

    public void addReward(ItemStack reward) {
        this.rewards.add(reward);
    }

    public boolean checkCompletion() {
        if (this.completed) {
            return true;
        }
        for (QuestObjective objective : this.objectives) {
            if (objective.isCompleted()) continue;
            return false;
        }
        this.setCompleted(true);
        return true;
    }

    public float getProgress() {
        if (this.objectives.isEmpty()) {
            return 1.0f;
        }
        int completedObjectives = 0;
        for (QuestObjective objective : this.objectives) {
            if (!objective.isCompleted()) continue;
            ++completedObjectives;
        }
        return (float)completedObjectives / (float)this.objectives.size();
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id);
        tag.m_128359_("title", this.title);
        tag.m_128359_("description", this.description);
        tag.m_128359_("type", this.type.name());
        tag.m_128359_("villagerId", this.villagerId);
        tag.m_128379_("completed", this.completed);
        tag.m_128356_("startTime", this.startTime);
        tag.m_128356_("completionTime", this.completionTime);
        tag.m_128405_("experienceReward", this.experienceReward);
        ListTag objectivesTag = new ListTag();
        for (QuestObjective objective : this.objectives) {
            objectivesTag.add((Object)objective.save());
        }
        tag.m_128365_("objectives", (Tag)objectivesTag);
        ListTag rewardsTag = new ListTag();
        for (ItemStack reward : this.rewards) {
            CompoundTag rewardTag = new CompoundTag();
            reward.m_41739_(rewardTag);
            rewardsTag.add((Object)rewardTag);
        }
        tag.m_128365_("rewards", (Tag)rewardsTag);
        return tag;
    }

    public static Quest load(CompoundTag tag) {
        String id = tag.m_128461_("id");
        String title = tag.m_128461_("title");
        String description = tag.m_128461_("description");
        QuestType type = QuestType.valueOf(tag.m_128461_("type"));
        String villagerId = tag.m_128461_("villagerId");
        Quest quest = new Quest(id, title, description, type, villagerId);
        quest.completed = tag.m_128471_("completed");
        quest.startTime = tag.m_128454_("startTime");
        quest.completionTime = tag.m_128454_("completionTime");
        quest.experienceReward = tag.m_128451_("experienceReward");
        ListTag objectivesTag = tag.m_128437_("objectives", 10);
        for (int i = 0; i < objectivesTag.size(); ++i) {
            CompoundTag objectiveTag = objectivesTag.m_128728_(i);
            quest.objectives.add(QuestObjective.load(objectiveTag));
        }
        ListTag rewardsTag = tag.m_128437_("rewards", 10);
        for (int i = 0; i < rewardsTag.size(); ++i) {
            CompoundTag rewardTag = rewardsTag.m_128728_(i);
            quest.rewards.add(ItemStack.m_41712_((CompoundTag)rewardTag));
        }
        return quest;
    }
}

