/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.quest;

import com.mojang.logging.LogUtils;
import fr.midaco.villagerquests.quest.ObjectiveType;
import fr.midaco.villagerquests.quest.Quest;
import fr.midaco.villagerquests.quest.QuestObjective;
import fr.midaco.villagerquests.quest.QuestType;
import fr.midaco.villagerquests.utils.QuestUtils;
import fr.midaco.villagerquests.villager.VillagerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="villagerquests")
public class QuestManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Map<UUID, List<Quest>> playerQuests = new ConcurrentHashMap<UUID, List<Quest>>();
    private static final Map<String, List<Quest>> villagerQuests = new ConcurrentHashMap<String, List<Quest>>();
    private static final Map<UUID, Map<String, PlayerVillagerQuestData>> playerVillagerQuests = new ConcurrentHashMap<UUID, Map<String, PlayerVillagerQuestData>>();

    public static void init() {
        LOGGER.info("Initialisation du syst\u00e8me de qu\u00eates...");
    }

    public static Quest generateRandomQuest(String villagerId, VillagerType villagerType) {
        Random rand;
        int extraObjectiveChance;
        String questId = villagerType.getId() + "_quest_" + System.currentTimeMillis();
        Component title = QuestUtils.getQuestTitleComponent(villagerType);
        Component description = QuestUtils.getQuestDescComponent(villagerType);
        Quest quest = new Quest(questId, title.getString(), description.getString(), QuestType.GATHER, villagerId);
        ArrayList<QuestObjective> objectives = new ArrayList<QuestObjective>();
        List<ItemStack> requestedItems = villagerType.getRequestedItems();
        if (!requestedItems.isEmpty()) {
            int numObjectives = 1;
            ArrayList<ItemStack> selectedItems = new ArrayList<ItemStack>();
            Random rand2 = new Random();
            while (selectedItems.size() < numObjectives) {
                ItemStack item = requestedItems.get(rand2.nextInt(requestedItems.size()));
                boolean already = false;
                for (ItemStack it : selectedItems) {
                    if (!ItemStack.m_150942_((ItemStack)it, (ItemStack)item)) continue;
                    already = true;
                    break;
                }
                if (already) continue;
                selectedItems.add(item);
            }
            for (ItemStack item : selectedItems) {
                String objectiveId = "gather_" + item.m_41720_().toString().toLowerCase().replace("minecraft:", "");
                int requiredAmount = QuestUtils.getRequiredAmountForItem(item);
                String itemName = item.m_41786_().getString();
                QuestObjective objective = new QuestObjective(objectiveId, "quest.objective.gather", ObjectiveType.GATHER_ITEM, requiredAmount, requiredAmount, itemName);
                objective.setTargetItem(item);
                objectives.add(objective);
            }
        }
        if ((extraObjectiveChance = (rand = new Random()).nextInt(100)) < 50) {
            switch (villagerType) {
                case MASON: {
                    String blockName = "Stone";
                    int requiredAmount = 8;
                    QuestObjective objective = new QuestObjective("break_stone", "quest.objective.break", ObjectiveType.BREAK_BLOCK, requiredAmount, requiredAmount, blockName);
                    objective.setTargetBlock(blockName);
                    objectives.add(objective);
                    break;
                }
                case FARMER: {
                    QuestObjective farmObjective = new QuestObjective("farm_wheat", "quest.objective.farm", ObjectiveType.FARM_CROP, 5, 5, "Bl\u00e9");
                    farmObjective.setTargetItem(new ItemStack((ItemLike)Items.f_42405_));
                    objectives.add(farmObjective);
                    break;
                }
                case FISHERMAN: {
                    QuestObjective fishObjective = new QuestObjective("fish_fish", "quest.objective.fish", ObjectiveType.FISH_ITEM, 2, 2, "Poisson");
                    fishObjective.setTargetItem(new ItemStack((ItemLike)Items.f_42526_));
                    objectives.add(fishObjective);
                    break;
                }
                case BUTCHER: {
                    String[] animals = new String[]{"minecraft:cow", "minecraft:pig", "minecraft:chicken"};
                    String[] animalNames = new String[]{"Vache", "Cochon", "Poulet"};
                    int animalIndex = rand.nextInt(animals.length);
                    String animalEntity = animals[animalIndex];
                    String animalName = animalNames[animalIndex];
                    int huntAmount = 2 + rand.nextInt(3);
                    QuestObjective huntObjective = new QuestObjective("hunt_" + animalName.toLowerCase(), "quest.objective.hunt", ObjectiveType.HUNT_ANIMAL, huntAmount, huntAmount, animalName);
                    huntObjective.setTargetEntity(animalEntity);
                    objectives.add(huntObjective);
                    break;
                }
                case WEAPONSMITH: 
                case TOOLSMITH: 
                case ARMORER: {
                    String[][] mobs = new String[][]{{"minecraft:zombie", "entity.minecraft.zombie"}, {"minecraft:skeleton", "entity.minecraft.skeleton"}, {"minecraft:creeper", "entity.minecraft.creeper"}, {"minecraft:spider", "entity.minecraft.spider"}};
                    int mobIndex = rand.nextInt(mobs.length);
                    String entityName = mobs[mobIndex][0];
                    String translationKey = mobs[mobIndex][1];
                    int killRequiredAmount = 3;
                    QuestObjective killObjective = new QuestObjective("kill_" + entityName.replace("minecraft:", ""), "quest.objective.kill", ObjectiveType.KILL_ENTITY, killRequiredAmount, killRequiredAmount, translationKey);
                    killObjective.setTargetEntity(entityName);
                    objectives.add(killObjective);
                    break;
                }
                default: {
                    String[][] mobs = new String[][]{{"minecraft:zombie", "entity.minecraft.zombie"}, {"minecraft:skeleton", "entity.minecraft.skeleton"}, {"minecraft:creeper", "entity.minecraft.creeper"}, {"minecraft:spider", "entity.minecraft.spider"}};
                    int mobIndex = rand.nextInt(mobs.length);
                    String entityName = mobs[mobIndex][0];
                    String translationKey = mobs[mobIndex][1];
                    int killRequiredAmount = 3;
                    QuestObjective killObjective = new QuestObjective("kill_" + entityName.replace("minecraft:", ""), "quest.objective.kill", ObjectiveType.KILL_ENTITY, killRequiredAmount, killRequiredAmount, translationKey);
                    killObjective.setTargetEntity(entityName);
                    objectives.add(killObjective);
                }
            }
        }
        for (QuestObjective objective : objectives) {
            quest.addObjective(objective);
        }
        List<ItemStack> rewards = QuestManager.generateRewardsForVillagerType(villagerType);
        for (ItemStack reward : rewards) {
            quest.addReward(reward);
        }
        int experienceReward = QuestManager.generateExperienceReward(villagerType);
        quest.setExperienceReward(experienceReward);
        return quest;
    }

    private static List<QuestObjective> generateObjectivesForVillagerType(VillagerType villagerType) {
        ArrayList<QuestObjective> objectives = new ArrayList<QuestObjective>();
        List<ItemStack> requestedItems = villagerType.getRequestedItems();
        if (!requestedItems.isEmpty()) {
            int numObjectives = 1;
            ArrayList<ItemStack> selectedItems = new ArrayList<ItemStack>();
            Random rand = new Random();
            while (selectedItems.size() < numObjectives) {
                ItemStack item = requestedItems.get(rand.nextInt(requestedItems.size()));
                boolean already = false;
                for (ItemStack it : selectedItems) {
                    if (!ItemStack.m_150942_((ItemStack)it, (ItemStack)item)) continue;
                    already = true;
                    break;
                }
                if (already) continue;
                selectedItems.add(item);
            }
            for (ItemStack item : selectedItems) {
                String objectiveId = "gather_" + item.m_41720_().toString().toLowerCase().replace("minecraft:", "");
                int requiredAmount = QuestUtils.getRequiredAmountForItem(item);
                String itemName = QuestUtils.getItemDisplayName(item).getString();
                QuestObjective objective = new QuestObjective(objectiveId, "quest.objective.gather", ObjectiveType.GATHER_ITEM, requiredAmount, requiredAmount, itemName);
                objective.setTargetItem(item);
                objectives.add(objective);
            }
        }
        return objectives;
    }

    private static List<ItemStack> generateRewardsForVillagerType(VillagerType villagerType) {
        ArrayList<ItemStack> rewards = new ArrayList<ItemStack>();
        Collection allItems = ForgeRegistries.ITEMS.getValues();
        ArrayList itemList = new ArrayList(allItems);
        if (!itemList.isEmpty()) {
            Random rand = new Random();
            int numRewards = 1 + rand.nextInt(3);
            for (int i = 0; i < numRewards; ++i) {
                Item randomItem = (Item)itemList.get(rand.nextInt(itemList.size()));
                int amount = 1 + rand.nextInt(5);
                ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)randomItem);
                if (key != null) {
                    LOGGER.info("R\u00e9compense g\u00e9n\u00e9r\u00e9e : {} x{}", (Object)key, (Object)amount);
                }
                rewards.add(new ItemStack((ItemLike)randomItem, amount));
            }
        }
        return rewards;
    }

    private static int generateExperienceReward(VillagerType villagerType) {
        return villagerType.getExperienceReward();
    }

    public static List<Quest> getPlayerQuests(UUID playerId) {
        ArrayList<Quest> result = new ArrayList<Quest>();
        List legacy = playerQuests.getOrDefault(playerId, new ArrayList());
        result.addAll(legacy);
        Map<String, PlayerVillagerQuestData> villagerMap = playerVillagerQuests.get(playerId);
        if (villagerMap != null) {
            for (PlayerVillagerQuestData data : villagerMap.values()) {
                if (data.state != PlayerVillagerQuestData.State.ACCEPTED || data.quest == null) continue;
                result.add(data.quest);
            }
        }
        return result;
    }

    public static List<Map.Entry<String, Quest>> getActiveQuestsWithVillagerIds(UUID playerId) {
        ArrayList<Map.Entry<String, Quest>> result = new ArrayList<Map.Entry<String, Quest>>();
        Map<String, PlayerVillagerQuestData> villagerMap = playerVillagerQuests.get(playerId);
        if (villagerMap != null) {
            for (Map.Entry<String, PlayerVillagerQuestData> entry : villagerMap.entrySet()) {
                if (entry.getValue().state != PlayerVillagerQuestData.State.ACCEPTED || entry.getValue().quest == null) continue;
                result.add(Map.entry(entry.getKey(), entry.getValue().quest));
            }
        }
        return result;
    }

    public static boolean abandonQuest(UUID playerId, String villagerId) {
        PlayerVillagerQuestData data;
        Map<String, PlayerVillagerQuestData> villagerMap = playerVillagerQuests.get(playerId);
        if (villagerMap != null && (data = villagerMap.get(villagerId)) != null && data.state == PlayerVillagerQuestData.State.ACCEPTED) {
            data.state = PlayerVillagerQuestData.State.REFUSED;
            LOGGER.info("Qu\u00eate abandonn\u00e9e pour le joueur {} et villageois {}", (Object)playerId, (Object)villagerId);
            return true;
        }
        return false;
    }

    public static void completeQuest(UUID playerId, String villagerId, ServerPlayer player) {
        PlayerVillagerQuestData data = QuestManager.getOrCreateQuestData(playerId, villagerId, null);
        if (data == null || data.quest == null) {
            return;
        }
        for (ItemStack reward : data.quest.getRewards()) {
            player.m_36356_(reward);
        }
        if (data.quest.getExperienceReward() > 0) {
            player.m_6756_(data.quest.getExperienceReward());
        }
        data.state = PlayerVillagerQuestData.State.COMPLETED;
        data.completionTimestamp = System.currentTimeMillis();
        player.m_213846_((Component)Component.m_237113_((String)("\u00a7aQu\u00eate termin\u00e9e : " + data.quest.getTitle())));
        player.m_213846_((Component)Component.m_237113_((String)"\u00a76R\u00e9compenses re\u00e7ues !"));
        LOGGER.info("Qu\u00eate termin\u00e9e par {}: {}", (Object)player.m_7755_().getString(), (Object)data.quest.getTitle());
    }

    public static boolean offerQuestToPlayer(ServerPlayer player, String villagerId, VillagerType villagerType) {
        UUID playerId = player.m_20148_();
        PlayerVillagerQuestData data = QuestManager.getOrCreateQuestData(playerId, villagerId, villagerType);
        long now = System.currentTimeMillis();
        long cooldown = 600000L;
        switch (data.state) {
            case AVAILABLE: {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7eQu\u00eate disponible : " + data.quest.getTitle())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77" + data.quest.getDescription())));
                return true;
            }
            case ACCEPTED: {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7aQu\u00eate en cours : " + data.quest.getTitle())));
                for (QuestObjective obj : data.quest.getObjectives()) {
                    String status = obj.isCompleted() ? "\u00a7a\u2713" : "\u00a7e\u25cb";
                    player.m_213846_((Component)Component.m_237113_((String)String.format("  %s %s \u00a77(%s)", status, obj.getDescription(), obj.getProgressText())));
                }
                return true;
            }
            case COMPLETED: {
                Quest newQuest;
                if (now - data.completionTimestamp < cooldown) {
                    player.m_213846_((Component)Component.m_237113_((String)"\u00a77Le villageois n'a besoin de rien pour le moment. Revenez plus tard !"));
                    return false;
                }
                data.quest = newQuest = QuestManager.generateRandomQuest(villagerId, villagerType);
                data.state = PlayerVillagerQuestData.State.AVAILABLE;
                data.completionTimestamp = 0L;
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7eNouvelle qu\u00eate disponible : " + newQuest.getTitle())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77" + newQuest.getDescription())));
                return true;
            }
            case REFUSED: {
                player.m_213846_((Component)Component.m_237113_((String)("\u00a7eQu\u00eate disponible : " + data.quest.getTitle())));
                player.m_213846_((Component)Component.m_237113_((String)("\u00a77" + data.quest.getDescription())));
                return true;
            }
        }
        return false;
    }

    public static void savePlayerQuests(UUID playerId, CompoundTag playerData) {
        Map<String, PlayerVillagerQuestData> villagerMap;
        LOGGER.info("Sauvegarde des qu\u00eates pour le joueur: {}", (Object)playerId);
        List<Quest> quests = playerQuests.get(playerId);
        if (quests != null && !quests.isEmpty()) {
            ListTag questsTag = new ListTag();
            for (Quest quest : quests) {
                questsTag.add((Object)quest.save());
            }
            playerData.m_128365_("VillagerQuests", (Tag)questsTag);
            LOGGER.info("Sauvegard\u00e9 {} qu\u00eates anciennes", (Object)quests.size());
        }
        if ((villagerMap = playerVillagerQuests.get(playerId)) != null && !villagerMap.isEmpty()) {
            ListTag villagerQuestsTag = new ListTag();
            for (Map.Entry<String, PlayerVillagerQuestData> entry : villagerMap.entrySet()) {
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("VillagerId", entry.getKey());
                tag.m_128359_("State", entry.getValue().state.name());
                tag.m_128356_("CompletionTimestamp", entry.getValue().completionTimestamp);
                if (entry.getValue().quest != null) {
                    tag.m_128365_("Quest", (Tag)entry.getValue().quest.save());
                }
                villagerQuestsTag.add((Object)tag);
            }
            playerData.m_128365_("VillagerQuestsPersistent", (Tag)villagerQuestsTag);
            LOGGER.info("Sauvegard\u00e9 {} qu\u00eates persistantes", (Object)villagerMap.size());
        } else {
            LOGGER.info("Aucune qu\u00eate persistante \u00e0 sauvegarder");
        }
    }

    public static void loadPlayerQuests(UUID playerId, CompoundTag playerData) {
        int i;
        LOGGER.info("Chargement des qu\u00eates pour le joueur: {}", (Object)playerId);
        if (playerData.m_128441_("VillagerQuests")) {
            ListTag questsTag = playerData.m_128437_("VillagerQuests", 10);
            ArrayList<Quest> quests = new ArrayList<Quest>();
            for (i = 0; i < questsTag.size(); ++i) {
                CompoundTag questTag = questsTag.m_128728_(i);
                quests.add(Quest.load(questTag));
            }
            playerQuests.put(playerId, quests);
            LOGGER.info("Charg\u00e9 {} qu\u00eates anciennes", (Object)quests.size());
        }
        if (playerData.m_128441_("VillagerQuestsPersistent")) {
            ListTag villagerQuestsTag = playerData.m_128437_("VillagerQuestsPersistent", 10);
            ConcurrentHashMap<String, PlayerVillagerQuestData> villagerMap = new ConcurrentHashMap<String, PlayerVillagerQuestData>();
            for (i = 0; i < villagerQuestsTag.size(); ++i) {
                CompoundTag tag = villagerQuestsTag.m_128728_(i);
                String villagerId = tag.m_128461_("VillagerId");
                PlayerVillagerQuestData.State state = PlayerVillagerQuestData.State.valueOf(tag.m_128461_("State"));
                long completionTimestamp = tag.m_128454_("CompletionTimestamp");
                Quest quest = null;
                if (tag.m_128441_("Quest")) {
                    quest = Quest.load(tag.m_128469_("Quest"));
                }
                PlayerVillagerQuestData data = new PlayerVillagerQuestData(quest, state);
                data.completionTimestamp = completionTimestamp;
                villagerMap.put(villagerId, data);
            }
            playerVillagerQuests.put(playerId, villagerMap);
            LOGGER.info("Charg\u00e9 {} qu\u00eates persistantes", (Object)villagerMap.size());
        } else {
            LOGGER.info("Aucune qu\u00eate persistante trouv\u00e9e dans les donn\u00e9es");
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag playerData = player2.getPersistentData();
            QuestManager.loadPlayerQuests(player2.m_20148_(), playerData);
            LOGGER.info("Qu\u00eates charg\u00e9es pour le joueur: {}", (Object)player2.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CompoundTag playerData = player2.getPersistentData();
            QuestManager.savePlayerQuests(player2.m_20148_(), playerData);
            LOGGER.info("Qu\u00eates sauvegard\u00e9es pour le joueur: {}", (Object)player2.m_7755_().getString());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (event.phase == TickEvent.Phase.END && player2.f_19797_ % 200 == 0) {
                CompoundTag playerData = player2.getPersistentData();
                QuestManager.savePlayerQuests(player2.m_20148_(), playerData);
            }
        }
    }

    public static PlayerVillagerQuestData getOrCreateQuestData(UUID playerId, String villagerId, VillagerType villagerType) {
        long cooldown;
        long now;
        Map villagerMap = playerVillagerQuests.computeIfAbsent(playerId, k -> new ConcurrentHashMap());
        PlayerVillagerQuestData data = (PlayerVillagerQuestData)villagerMap.get(villagerId);
        if (data == null) {
            Quest quest = QuestManager.generateRandomQuest(villagerId, villagerType);
            data = new PlayerVillagerQuestData(quest, PlayerVillagerQuestData.State.AVAILABLE);
            villagerMap.put(villagerId, data);
        } else if (data.state == PlayerVillagerQuestData.State.COMPLETED && (now = System.currentTimeMillis()) - data.completionTimestamp >= (cooldown = 600000L)) {
            Quest quest;
            data.quest = quest = QuestManager.generateRandomQuest(villagerId, villagerType);
            data.state = PlayerVillagerQuestData.State.AVAILABLE;
            data.completionTimestamp = 0L;
        }
        return data;
    }

    public static void acceptQuest(UUID playerId, String villagerId) {
        PlayerVillagerQuestData data;
        Map<String, PlayerVillagerQuestData> villagerMap = playerVillagerQuests.get(playerId);
        if (villagerMap != null && (data = villagerMap.get(villagerId)) != null && data.state == PlayerVillagerQuestData.State.AVAILABLE) {
            data.state = PlayerVillagerQuestData.State.ACCEPTED;
            LOGGER.info("Qu\u00eate accept\u00e9e pour le joueur {} et villageois {}", (Object)playerId, (Object)villagerId);
        }
    }

    public static void refuseQuest(UUID playerId, String villagerId) {
        PlayerVillagerQuestData data;
        Map<String, PlayerVillagerQuestData> villagerMap = playerVillagerQuests.get(playerId);
        if (villagerMap != null && (data = villagerMap.get(villagerId)) != null && data.state == PlayerVillagerQuestData.State.AVAILABLE) {
            data.state = PlayerVillagerQuestData.State.REFUSED;
            LOGGER.info("Qu\u00eate refus\u00e9e pour le joueur {} et villageois {}", (Object)playerId, (Object)villagerId);
        }
    }

    public static class PlayerVillagerQuestData {
        public Quest quest;
        public State state;
        public long completionTimestamp;

        public PlayerVillagerQuestData(Quest quest, State state) {
            this.quest = quest;
            this.state = state;
            this.completionTimestamp = 0L;
        }

        public static enum State {
            AVAILABLE,
            ACCEPTED,
            COMPLETED,
            REFUSED;

        }
    }
}

