/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.quest;

import fr.midaco.villagerquests.quest.ObjectiveType;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class QuestObjective {
    private String id;
    private String translationKey;
    private Object[] translationParams;
    private ObjectiveType type;
    private ItemStack targetItem;
    private String targetEntity;
    private String targetBlock;
    private int requiredAmount;
    private int currentAmount;
    private boolean completed;

    public QuestObjective(String id, String translationKey, ObjectiveType type, int requiredAmount, Object ... translationParams) {
        this.id = id;
        this.translationKey = translationKey;
        this.type = type;
        this.requiredAmount = requiredAmount;
        this.currentAmount = 0;
        this.completed = false;
        this.translationParams = translationParams;
    }

    public String getId() {
        return this.id;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public Object[] getTranslationParams() {
        return this.translationParams;
    }

    public ObjectiveType getType() {
        return this.type;
    }

    public ItemStack getTargetItem() {
        return this.targetItem;
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public String getTargetBlock() {
        return this.targetBlock;
    }

    public int getRequiredAmount() {
        return this.requiredAmount;
    }

    public int getCurrentAmount() {
        return this.currentAmount;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setTargetItem(ItemStack targetItem) {
        this.targetItem = targetItem;
    }

    public void setTargetEntity(String targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setTargetBlock(String targetBlock) {
        this.targetBlock = targetBlock;
    }

    public void setCurrentAmount(int currentAmount) {
        this.currentAmount = currentAmount;
        this.checkCompletion();
    }

    public void incrementProgress(int amount) {
        this.currentAmount += amount;
        this.checkCompletion();
    }

    public void checkCompletion() {
        this.completed = this.currentAmount >= this.requiredAmount;
    }

    public float getProgress() {
        return Math.min(1.0f, (float)this.currentAmount / (float)this.requiredAmount);
    }

    public String getProgressText() {
        return this.currentAmount + "/" + this.requiredAmount;
    }

    public String getDescription() {
        String firstParam;
        if (this.translationParams.length > 0 && this.translationParams[0] instanceof String && (firstParam = (String)this.translationParams[0]).startsWith("entity.minecraft.")) {
            String translatedEntity = Component.m_237115_((String)firstParam).getString();
            if (this.translationKey.equals("quest.objective.kill")) {
                return Component.m_237110_((String)this.translationKey, (Object[])new Object[]{translatedEntity}).getString();
            }
            Object[] newParams = new Object[this.translationParams.length];
            newParams[0] = translatedEntity;
            for (int i = 1; i < this.translationParams.length; ++i) {
                newParams[i] = this.translationParams[i];
            }
            return Component.m_237110_((String)this.translationKey, (Object[])newParams).getString();
        }
        return Component.m_237110_((String)this.translationKey, (Object[])this.translationParams).getString();
    }

    public boolean isFulfilledByInventory(LocalPlayer player) {
        if (this.getType() == ObjectiveType.GATHER_ITEM && this.getTargetItem() != null) {
            int count = 0;
            for (ItemStack stack : player.m_150109_().f_35974_) {
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)this.getTargetItem())) continue;
                count += stack.m_41613_();
            }
            return count >= this.getRequiredAmount();
        }
        return false;
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.id);
        tag.m_128359_("translationKey", this.translationKey);
        if (this.translationParams != null && this.translationParams.length > 0) {
            ListTag paramsTag = new ListTag();
            for (Object param : this.translationParams) {
                if (param == null) continue;
                paramsTag.add((Object)StringTag.m_129297_((String)param.toString()));
            }
            tag.m_128365_("translationParams", (Tag)paramsTag);
        }
        tag.m_128359_("type", this.type.name());
        tag.m_128405_("requiredAmount", this.requiredAmount);
        tag.m_128405_("currentAmount", this.currentAmount);
        tag.m_128379_("completed", this.completed);
        if (this.targetItem != null) {
            CompoundTag itemTag = new CompoundTag();
            this.targetItem.m_41739_(itemTag);
            tag.m_128365_("targetItem", (Tag)itemTag);
        }
        if (this.targetEntity != null) {
            tag.m_128359_("targetEntity", this.targetEntity);
        }
        if (this.targetBlock != null) {
            tag.m_128359_("targetBlock", this.targetBlock);
        }
        return tag;
    }

    public static QuestObjective load(CompoundTag tag) {
        String id = tag.m_128461_("id");
        String translationKey = tag.m_128461_("translationKey");
        ObjectiveType type = ObjectiveType.valueOf(tag.m_128461_("type"));
        int requiredAmount = tag.m_128451_("requiredAmount");
        Object[] translationParams = new Object[]{};
        if (tag.m_128441_("translationParams")) {
            ListTag paramsTag = tag.m_128437_("translationParams", 8);
            translationParams = new Object[paramsTag.size()];
            for (int i = 0; i < paramsTag.size(); ++i) {
                String paramStr = paramsTag.m_128778_(i);
                try {
                    translationParams[i] = Integer.parseInt(paramStr);
                    continue;
                }
                catch (NumberFormatException e) {
                    translationParams[i] = paramStr;
                }
            }
        }
        QuestObjective objective = new QuestObjective(id, translationKey, type, requiredAmount, translationParams);
        objective.currentAmount = tag.m_128451_("currentAmount");
        objective.completed = tag.m_128471_("completed");
        if (tag.m_128441_("targetItem")) {
            objective.targetItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("targetItem"));
        }
        if (tag.m_128441_("targetEntity")) {
            objective.targetEntity = tag.m_128461_("targetEntity");
        }
        if (tag.m_128441_("targetBlock")) {
            objective.targetBlock = tag.m_128461_("targetBlock");
        }
        return objective;
    }
}

