/*
 * Decompiled with CFR 0.152.
 */
package fr.midaco.villagerquests.villager;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public enum VillagerType {
    FARMER("farmer", Arrays.asList(new ItemStack((ItemLike)Items.f_42405_), new ItemStack((ItemLike)Items.f_42620_), new ItemStack((ItemLike)Items.f_42619_), new ItemStack((ItemLike)Items.f_42732_), new ItemStack((ItemLike)Items.f_42046_), new ItemStack((ItemLike)Items.f_42575_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)Items.f_42406_, 5), new ItemStack((ItemLike)Items.f_42410_, 3)), 10),
    FISHERMAN("fisherman", Arrays.asList(new ItemStack((ItemLike)Items.f_42526_), new ItemStack((ItemLike)Items.f_42527_), new ItemStack((ItemLike)Items.f_42528_), new ItemStack((ItemLike)Items.f_42529_), new ItemStack((ItemLike)Items.f_41867_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_42530_, 8), new ItemStack((ItemLike)Items.f_42531_, 8)), 15),
    SHEPHERD("shepherd", Arrays.asList(new ItemStack((ItemLike)Items.f_41870_), new ItemStack((ItemLike)Items.f_41938_), new ItemStack((ItemLike)Items.f_41877_), new ItemStack((ItemLike)Items.f_41935_), new ItemStack((ItemLike)Items.f_42658_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)Items.f_41870_, 16), new ItemStack((ItemLike)Items.f_42659_, 6)), 12),
    BUTCHER("butcher", Arrays.asList(new ItemStack((ItemLike)Items.f_42579_), new ItemStack((ItemLike)Items.f_42485_), new ItemStack((ItemLike)Items.f_42658_), new ItemStack((ItemLike)Items.f_42697_), new ItemStack((ItemLike)Items.f_42581_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)Items.f_42580_, 8), new ItemStack((ItemLike)Items.f_42486_, 8)), 20),
    LIBRARIAN("librarian", Arrays.asList(new ItemStack((ItemLike)Items.f_42516_), new ItemStack((ItemLike)Items.f_42517_), new ItemStack((ItemLike)Items.f_42532_), new ItemStack((ItemLike)Items.f_42402_), new ItemStack((ItemLike)Items.f_42454_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_42517_, 3), new ItemStack((ItemLike)Items.f_42612_, 2)), 18),
    CARTOGRAPHER("cartographer", Arrays.asList(new ItemStack((ItemLike)Items.f_42516_), new ItemStack((ItemLike)Items.f_42522_), new ItemStack((ItemLike)Items.f_42676_), new ItemStack((ItemLike)Items.f_42532_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_42676_, 2), new ItemStack((ItemLike)Items.f_42522_, 1)), 15),
    CLERIC("cleric", Arrays.asList(new ItemStack((ItemLike)Items.f_42583_), new ItemStack((ItemLike)Items.f_42417_), new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)Items.f_42534_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_42612_, 3), new ItemStack((ItemLike)Items.f_42525_, 8)), 16),
    ARMORER("armorer", Arrays.asList(new ItemStack((ItemLike)Items.f_42416_), new ItemStack((ItemLike)Items.f_42413_), new ItemStack((ItemLike)Items.f_42415_), new ItemStack((ItemLike)Items.f_42616_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)Items.f_42468_, 1), new ItemStack((ItemLike)Items.f_42469_, 1)), 25),
    WEAPONSMITH("weaponsmith", Arrays.asList(new ItemStack((ItemLike)Items.f_42416_), new ItemStack((ItemLike)Items.f_42413_), new ItemStack((ItemLike)Items.f_42484_), new ItemStack((ItemLike)Items.f_42398_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)Items.f_42383_, 1), new ItemStack((ItemLike)Items.f_42386_, 1)), 25),
    TOOLSMITH("toolsmith", Arrays.asList(new ItemStack((ItemLike)Items.f_42416_), new ItemStack((ItemLike)Items.f_42413_), new ItemStack((ItemLike)Items.f_42398_), new ItemStack((ItemLike)Items.f_42484_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)Items.f_42385_, 1), new ItemStack((ItemLike)Items.f_42384_, 1)), 20),
    MASON("mason", Arrays.asList(new ItemStack((ItemLike)Items.f_41905_), new ItemStack((ItemLike)Items.f_42594_), new ItemStack((ItemLike)Items.f_41856_), new ItemStack((ItemLike)Items.f_42692_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)Items.f_41905_, 64), new ItemStack((ItemLike)Items.f_41856_, 32)), 12),
    LEATHERWORKER("leatherworker", Arrays.asList(new ItemStack((ItemLike)Items.f_42454_), new ItemStack((ItemLike)Items.f_42649_), new ItemStack((ItemLike)Items.f_42355_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 2), new ItemStack((ItemLike)Items.f_42407_, 1), new ItemStack((ItemLike)Items.f_42463_, 1)), 15),
    NITWIT("nitwit", Arrays.asList(new ItemStack((ItemLike)Items.f_42329_), new ItemStack((ItemLike)Items.f_41905_), new ItemStack((ItemLike)Items.f_42276_)), Arrays.asList(new ItemStack((ItemLike)Items.f_42616_, 1), new ItemStack((ItemLike)Items.f_42406_, 2)), 5);

    private final String id;
    private final List<ItemStack> requestedItems;
    private final List<ItemStack> rewards;
    private final int experienceReward;

    private VillagerType(String id, List<ItemStack> requestedItems, List<ItemStack> rewards, int experienceReward) {
        this.id = id;
        this.requestedItems = requestedItems;
        this.rewards = rewards;
        this.experienceReward = experienceReward;
    }

    public String getId() {
        return this.id;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)("villagerquests.profession." + this.id));
    }

    public List<ItemStack> getRequestedItems() {
        return this.requestedItems;
    }

    public List<ItemStack> getRewards() {
        return this.rewards;
    }

    public int getExperienceReward() {
        return this.experienceReward;
    }

    public static VillagerType fromString(String type) {
        for (VillagerType villagerType : VillagerType.values()) {
            if (!villagerType.getId().equals(type.toLowerCase())) continue;
            return villagerType;
        }
        return FARMER;
    }

    public static VillagerType getRandomType() {
        VillagerType[] types = VillagerType.values();
        return types[(int)(Math.random() * (double)types.length)];
    }

    public Component getRandomQuestSentenceComponent(String itemName, int amount) {
        Random random = new Random();
        String keyBase = "villagerquests.quest." + this.id + ".";
        int maxPhrases = 10;
        int idx = random.nextInt(maxPhrases);
        String key = keyBase + idx;
        return Component.m_237110_((String)key, (Object[])new Object[]{amount, itemName});
    }

    public String getRandomQuestSentence(String itemName, int amount) {
        return this.getRandomQuestSentenceComponent(itemName, amount).getString();
    }
}

