/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.internal;

import app.simplecloud.relocate.grpc.Attributes;
import app.simplecloud.relocate.grpc.ClientStreamTracer;
import app.simplecloud.relocate.grpc.Context;
import app.simplecloud.relocate.grpc.Metadata;
import app.simplecloud.relocate.grpc.ServerStreamTracer;
import app.simplecloud.relocate.grpc.Status;
import app.simplecloud.relocate.grpc.StreamTracer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class StatsTraceContext {
    public static final StatsTraceContext NOOP = new StatsTraceContext(new StreamTracer[0]);
    private final StreamTracer[] tracers;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public static StatsTraceContext newClientContext(ClientStreamTracer[] tracers, Attributes transportAtts, Metadata headers2) {
        StatsTraceContext ctx = new StatsTraceContext(tracers);
        for (ClientStreamTracer tracer : tracers) {
            tracer.streamCreated(transportAtts, headers2);
        }
        return ctx;
    }

    public static StatsTraceContext newServerContext(List<? extends ServerStreamTracer.Factory> factories, String fullMethodName, Metadata headers2) {
        if (factories.isEmpty()) {
            return NOOP;
        }
        StreamTracer[] tracers = new StreamTracer[factories.size()];
        for (int i2 = 0; i2 < tracers.length; ++i2) {
            tracers[i2] = factories.get(i2).newServerStreamTracer(fullMethodName, headers2);
        }
        return new StatsTraceContext(tracers);
    }

    @VisibleForTesting
    StatsTraceContext(StreamTracer[] tracers) {
        this.tracers = tracers;
    }

    @VisibleForTesting
    public List<StreamTracer> getTracersForTest() {
        return new ArrayList<StreamTracer>(Arrays.asList(this.tracers));
    }

    public void clientOutboundHeaders() {
        for (StreamTracer tracer : this.tracers) {
            ((ClientStreamTracer)tracer).outboundHeaders();
        }
    }

    public void clientInboundHeaders() {
        for (StreamTracer tracer : this.tracers) {
            ((ClientStreamTracer)tracer).inboundHeaders();
        }
    }

    public void clientInboundTrailers(Metadata trailers) {
        for (StreamTracer tracer : this.tracers) {
            ((ClientStreamTracer)tracer).inboundTrailers(trailers);
        }
    }

    public <ReqT, RespT> Context serverFilterContext(Context context) {
        Context ctx = Preconditions.checkNotNull(context, "context");
        for (StreamTracer tracer : this.tracers) {
            ctx = ((ServerStreamTracer)tracer).filterContext(ctx);
            Preconditions.checkNotNull(ctx, "%s returns null context", (Object)tracer);
        }
        return ctx;
    }

    public void serverCallStarted(ServerStreamTracer.ServerCallInfo<?, ?> callInfo) {
        for (StreamTracer tracer : this.tracers) {
            ((ServerStreamTracer)tracer).serverCallStarted(callInfo);
        }
    }

    public void streamClosed(Status status) {
        if (this.closed.compareAndSet(false, true)) {
            for (StreamTracer tracer : this.tracers) {
                tracer.streamClosed(status);
            }
        }
    }

    public void outboundMessage(int seqNo) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundMessage(seqNo);
        }
    }

    public void inboundMessage(int seqNo) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundMessage(seqNo);
        }
    }

    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundMessageSent(seqNo, optionalWireSize, optionalUncompressedSize);
        }
    }

    public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundMessageRead(seqNo, optionalWireSize, optionalUncompressedSize);
        }
    }

    public void outboundUncompressedSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundUncompressedSize(bytes);
        }
    }

    public void outboundWireSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.outboundWireSize(bytes);
        }
    }

    public void inboundUncompressedSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundUncompressedSize(bytes);
        }
    }

    public void inboundWireSize(long bytes) {
        for (StreamTracer tracer : this.tracers) {
            tracer.inboundWireSize(bytes);
        }
    }
}

