/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.AsciiString;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class HttpMethod
implements Comparable<HttpMethod> {
    public static final HttpMethod OPTIONS = new HttpMethod("OPTIONS");
    public static final HttpMethod GET = new HttpMethod("GET");
    public static final HttpMethod HEAD = new HttpMethod("HEAD");
    public static final HttpMethod POST = new HttpMethod("POST");
    public static final HttpMethod PUT = new HttpMethod("PUT");
    public static final HttpMethod PATCH = new HttpMethod("PATCH");
    public static final HttpMethod DELETE = new HttpMethod("DELETE");
    public static final HttpMethod TRACE = new HttpMethod("TRACE");
    public static final HttpMethod CONNECT = new HttpMethod("CONNECT");
    private static final EnumNameMap<HttpMethod> methodMap = new EnumNameMap(new EnumNameMap.Node<HttpMethod>(OPTIONS.toString(), OPTIONS), new EnumNameMap.Node<HttpMethod>(GET.toString(), GET), new EnumNameMap.Node<HttpMethod>(HEAD.toString(), HEAD), new EnumNameMap.Node<HttpMethod>(POST.toString(), POST), new EnumNameMap.Node<HttpMethod>(PUT.toString(), PUT), new EnumNameMap.Node<HttpMethod>(PATCH.toString(), PATCH), new EnumNameMap.Node<HttpMethod>(DELETE.toString(), DELETE), new EnumNameMap.Node<HttpMethod>(TRACE.toString(), TRACE), new EnumNameMap.Node<HttpMethod>(CONNECT.toString(), CONNECT));
    private final AsciiString name;

    public static HttpMethod valueOf(String name) {
        if (name == GET.name()) {
            return GET;
        }
        if (name == POST.name()) {
            return POST;
        }
        HttpMethod result2 = methodMap.get(name);
        return result2 != null ? result2 : new HttpMethod(name);
    }

    public HttpMethod(String name) {
        name = ObjectUtil.checkNonEmptyAfterTrim(name, "name");
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (!Character.isISOControl(c) && !Character.isWhitespace(c)) continue;
            throw new IllegalArgumentException("invalid character in name");
        }
        this.name = AsciiString.cached(name);
    }

    public String name() {
        return this.name.toString();
    }

    public AsciiString asciiName() {
        return this.name;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HttpMethod)) {
            return false;
        }
        HttpMethod that = (HttpMethod)o;
        return this.name().equals(that.name());
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public int compareTo(HttpMethod o) {
        if (o == this) {
            return 0;
        }
        return this.name().compareTo(o.name());
    }

    private static final class EnumNameMap<T> {
        private final Node<T>[] values;
        private final int valuesMask;

        EnumNameMap(Node<T> ... nodes) {
            this.values = new Node[MathUtil.findNextPositivePowerOfTwo(nodes.length)];
            this.valuesMask = this.values.length - 1;
            for (Node<T> node : nodes) {
                int i2 = EnumNameMap.hashCode(node.key) & this.valuesMask;
                if (this.values[i2] != null) {
                    throw new IllegalArgumentException("index " + i2 + " collision between values: [" + this.values[i2].key + ", " + node.key + ']');
                }
                this.values[i2] = node;
            }
        }

        T get(String name) {
            Node<T> node = this.values[EnumNameMap.hashCode(name) & this.valuesMask];
            return node == null || !node.key.equals(name) ? null : (T)node.value;
        }

        private static int hashCode(String name) {
            return name.hashCode() >>> 6;
        }

        private static final class Node<T> {
            final String key;
            final T value;

            Node(String key2, T value) {
                this.key = key2;
                this.value = value;
            }
        }
    }
}

