/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.rtsp;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.buffer.ByteBufUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.UnsupportedMessageTypeException;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpMessage;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpObjectEncoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponse;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.CharsetUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.StringUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final int CRLF_SHORT = 3338;

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && (msg instanceof HttpRequest || msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpMessage message) throws Exception {
        if (message instanceof HttpRequest) {
            HttpRequest request2 = (HttpRequest)message;
            ByteBufUtil.copy(request2.method().asciiName(), buf);
            buf.writeByte(32);
            buf.writeCharSequence(request2.uri(), CharsetUtil.UTF_8);
            buf.writeByte(32);
            buf.writeCharSequence(request2.protocolVersion().toString(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE(buf, 3338);
        } else if (message instanceof HttpResponse) {
            HttpResponse response2 = (HttpResponse)message;
            buf.writeCharSequence(response2.protocolVersion().toString(), CharsetUtil.US_ASCII);
            buf.writeByte(32);
            ByteBufUtil.copy(response2.status().codeAsText(), buf);
            buf.writeByte(32);
            buf.writeCharSequence(response2.status().reasonPhrase(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE(buf, 3338);
        } else {
            throw new UnsupportedMessageTypeException("Unsupported type " + StringUtil.simpleClassName(message));
        }
    }
}

