/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.util;

import app.simplecloud.relocate.grpc.Attributes;
import app.simplecloud.relocate.grpc.ConnectivityState;
import app.simplecloud.relocate.grpc.EquivalentAddressGroup;
import app.simplecloud.relocate.grpc.Internal;
import app.simplecloud.relocate.grpc.LoadBalancer;
import app.simplecloud.relocate.grpc.LoadBalancerProvider;
import app.simplecloud.relocate.grpc.Status;
import app.simplecloud.relocate.grpc.internal.PickFirstLoadBalancerProvider;
import app.simplecloud.relocate.grpc.util.ForwardingLoadBalancerHelper;
import app.simplecloud.relocate.grpc.util.GracefulSwitchLoadBalancer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public abstract class MultiChildLoadBalancer
extends LoadBalancer {
    private static final Logger logger = Logger.getLogger(MultiChildLoadBalancer.class.getName());
    private final Map<Object, ChildLbState> childLbStates = new LinkedHashMap<Object, ChildLbState>();
    private final LoadBalancer.Helper helper;
    protected boolean resolvingAddresses;
    protected final LoadBalancerProvider pickFirstLbProvider = new PickFirstLoadBalancerProvider();
    protected ConnectivityState currentConnectivityState;

    protected MultiChildLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = Preconditions.checkNotNull(helper, "helper");
        logger.log(Level.FINE, "Created");
    }

    protected abstract LoadBalancer.SubchannelPicker getSubchannelPicker(Map<Object, LoadBalancer.SubchannelPicker> var1);

    protected LoadBalancer.SubchannelPicker getInitialPicker() {
        return new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withNoResult());
    }

    protected LoadBalancer.SubchannelPicker getErrorPicker(Status error) {
        return new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withError(error));
    }

    protected ImmutableMap<Object, ChildLbState> getImmutableChildMap() {
        return ImmutableMap.copyOf(this.childLbStates);
    }

    @VisibleForTesting
    protected Collection<ChildLbState> getChildLbStates() {
        return this.childLbStates.values();
    }

    protected ChildLbState getChildLbState(Object key2) {
        if (key2 == null) {
            return null;
        }
        if (key2 instanceof EquivalentAddressGroup) {
            key2 = new Endpoint((EquivalentAddressGroup)key2);
        }
        return this.childLbStates.get(key2);
    }

    protected ChildLbState getChildLbStateEag(EquivalentAddressGroup eag) {
        return this.getChildLbState(new Endpoint(eag));
    }

    protected Map<Object, ChildLbState> createChildLbMap(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        HashMap<Object, ChildLbState> childLbMap = new HashMap<Object, ChildLbState>();
        List<EquivalentAddressGroup> addresses = resolvedAddresses.getAddresses();
        for (EquivalentAddressGroup eag : addresses) {
            Endpoint endpoint = new Endpoint(eag);
            ChildLbState existingChildLbState = this.childLbStates.get(endpoint);
            if (existingChildLbState != null) {
                childLbMap.put(endpoint, existingChildLbState);
                continue;
            }
            childLbMap.put(endpoint, this.createChildLbState(endpoint, null, this.getInitialPicker(), resolvedAddresses));
        }
        return childLbMap;
    }

    protected ChildLbState createChildLbState(Object key2, Object policyConfig, LoadBalancer.SubchannelPicker initialPicker, LoadBalancer.ResolvedAddresses resolvedAddresses) {
        return new ChildLbState(key2, this.pickFirstLbProvider, policyConfig, initialPicker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        try {
            this.resolvingAddresses = true;
            AcceptResolvedAddressRetVal acceptRetVal = this.acceptResolvedAddressesInternal(resolvedAddresses);
            if (!acceptRetVal.status.isOk()) {
                Status status = acceptRetVal.status;
                return status;
            }
            this.updateOverallBalancingState();
            this.shutdownRemoved(acceptRetVal.removedChildren);
            Status status = acceptRetVal.status;
            return status;
        }
        finally {
            this.resolvingAddresses = false;
        }
    }

    protected LoadBalancer.ResolvedAddresses getChildAddresses(Object key2, LoadBalancer.ResolvedAddresses resolvedAddresses, Object childConfig) {
        Endpoint endpointKey;
        if (key2 instanceof EquivalentAddressGroup) {
            endpointKey = new Endpoint((EquivalentAddressGroup)key2);
        } else {
            Preconditions.checkArgument(key2 instanceof Endpoint, "key is wrong type");
            endpointKey = (Endpoint)key2;
        }
        EquivalentAddressGroup eagToUse = null;
        for (EquivalentAddressGroup currEag : resolvedAddresses.getAddresses()) {
            if (!endpointKey.equals(new Endpoint(currEag))) continue;
            eagToUse = currEag;
            break;
        }
        Preconditions.checkNotNull(eagToUse, key2 + " no longer present in load balancer children");
        return resolvedAddresses.toBuilder().setAddresses(Collections.singletonList(eagToUse)).setAttributes(Attributes.newBuilder().set(IS_PETIOLE_POLICY, true).build()).setLoadBalancingPolicyConfig(childConfig).build();
    }

    protected AcceptResolvedAddressRetVal acceptResolvedAddressesInternal(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        logger.log(Level.FINE, "Received resolution result: {0}", resolvedAddresses);
        Map<Object, ChildLbState> newChildren = this.createChildLbMap(resolvedAddresses);
        if (newChildren.isEmpty()) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. " + resolvedAddresses);
            this.handleNameResolutionError(unavailableStatus);
            return new AcceptResolvedAddressRetVal(unavailableStatus, null);
        }
        for (Map.Entry<Object, ChildLbState> entry : newChildren.entrySet()) {
            Object key2 = entry.getKey();
            LoadBalancerProvider childPolicyProvider = entry.getValue().getPolicyProvider();
            Object childConfig = entry.getValue().getConfig();
            if (!this.childLbStates.containsKey(key2)) {
                this.childLbStates.put(key2, entry.getValue());
            } else {
                ChildLbState existingChildLbState = this.childLbStates.get(key2);
                if (existingChildLbState.isDeactivated() && this.reactivateChildOnReuse()) {
                    existingChildLbState.reactivate(childPolicyProvider);
                }
            }
            ChildLbState childLbState = this.childLbStates.get(key2);
            LoadBalancer.ResolvedAddresses childAddresses = this.getChildAddresses(key2, resolvedAddresses, childConfig);
            this.childLbStates.get(key2).setResolvedAddresses(childAddresses);
            if (childLbState.deactivated) continue;
            childLbState.lb.handleResolvedAddresses(childAddresses);
        }
        ArrayList<ChildLbState> removedChildren = new ArrayList<ChildLbState>();
        for (Object key2 : ImmutableList.copyOf(this.childLbStates.keySet())) {
            if (newChildren.containsKey(key2)) continue;
            ChildLbState childLbState = this.childLbStates.get(key2);
            childLbState.deactivate();
            removedChildren.add(childLbState);
        }
        return new AcceptResolvedAddressRetVal(Status.OK, removedChildren);
    }

    protected void shutdownRemoved(List<ChildLbState> removedChildren) {
        for (ChildLbState childLbState : removedChildren) {
            childLbState.shutdown();
        }
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.currentConnectivityState != ConnectivityState.READY) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, this.getErrorPicker(error));
        }
    }

    protected void handleNameResolutionError(ChildLbState child, Status error) {
        child.lb.handleNameResolutionError(error);
    }

    protected boolean reconnectOnIdle() {
        return true;
    }

    protected boolean reactivateChildOnReuse() {
        return true;
    }

    @Override
    public void shutdown() {
        logger.log(Level.INFO, "Shutdown");
        for (ChildLbState state : this.childLbStates.values()) {
            state.shutdown();
        }
        this.childLbStates.clear();
    }

    protected void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        HashMap<Object, LoadBalancer.SubchannelPicker> childPickers = new HashMap<Object, LoadBalancer.SubchannelPicker>();
        for (ChildLbState childLbState : this.getChildLbStates()) {
            if (childLbState.deactivated) continue;
            childPickers.put(childLbState.key, childLbState.currentPicker);
            overallState = MultiChildLoadBalancer.aggregateState(overallState, childLbState.currentState);
        }
        if (overallState != null) {
            this.helper.updateBalancingState(overallState, this.getSubchannelPicker(childPickers));
            this.currentConnectivityState = overallState;
        }
    }

    @Nullable
    protected static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    protected LoadBalancer.Helper getHelper() {
        return this.helper;
    }

    protected void removeChild(Object key2) {
        this.childLbStates.remove(key2);
    }

    protected List<ChildLbState> getReadyChildren() {
        ArrayList<ChildLbState> activeChildren = new ArrayList<ChildLbState>();
        for (ChildLbState child : this.getChildLbStates()) {
            if (child.isDeactivated() || child.getCurrentState() != ConnectivityState.READY) continue;
            activeChildren.add(child);
        }
        return activeChildren;
    }

    protected static class AcceptResolvedAddressRetVal {
        public final Status status;
        public final List<ChildLbState> removedChildren;

        public AcceptResolvedAddressRetVal(Status status, List<ChildLbState> removedChildren) {
            this.status = status;
            this.removedChildren = removedChildren;
        }
    }

    protected static class Endpoint {
        final String[] addrs;
        final int hashCode;

        public Endpoint(EquivalentAddressGroup eag) {
            Preconditions.checkNotNull(eag, "eag");
            this.addrs = new String[eag.getAddresses().size()];
            int i2 = 0;
            for (SocketAddress address : eag.getAddresses()) {
                this.addrs[i2++] = address.toString();
            }
            Arrays.sort(this.addrs);
            this.hashCode = Arrays.hashCode(this.addrs);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (!(other instanceof Endpoint)) {
                return false;
            }
            Endpoint o = (Endpoint)other;
            if (o.hashCode != this.hashCode || o.addrs.length != this.addrs.length) {
                return false;
            }
            return Arrays.equals(o.addrs, this.addrs);
        }

        public String toString() {
            return Arrays.toString(this.addrs);
        }
    }

    public class ChildLbState {
        private final Object key;
        private LoadBalancer.ResolvedAddresses resolvedAddresses;
        private final Object config;
        private final GracefulSwitchLoadBalancer lb;
        private final LoadBalancerProvider policyProvider;
        private ConnectivityState currentState;
        private LoadBalancer.SubchannelPicker currentPicker;
        private boolean deactivated;

        public ChildLbState(Object key2, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker) {
            this(key2, policyProvider, childConfig, initialPicker, null, false);
        }

        public ChildLbState(Object key2, LoadBalancerProvider policyProvider, Object childConfig, LoadBalancer.SubchannelPicker initialPicker, LoadBalancer.ResolvedAddresses resolvedAddrs, boolean deactivated) {
            this.key = key2;
            this.policyProvider = policyProvider;
            this.deactivated = deactivated;
            this.currentPicker = initialPicker;
            this.config = childConfig;
            this.lb = new GracefulSwitchLoadBalancer(new ChildLbStateHelper());
            this.currentState = deactivated ? ConnectivityState.IDLE : ConnectivityState.CONNECTING;
            this.resolvedAddresses = resolvedAddrs;
            if (!deactivated) {
                this.lb.switchTo(policyProvider);
            }
        }

        public String toString() {
            return "Address = " + this.key + ", state = " + (Object)((Object)this.currentState) + ", picker type: " + this.currentPicker.getClass() + ", lb: " + this.lb.delegate().getClass() + (this.deactivated ? ", deactivated" : "");
        }

        public Object getKey() {
            return this.key;
        }

        Object getConfig() {
            return this.config;
        }

        protected GracefulSwitchLoadBalancer getLb() {
            return this.lb;
        }

        public LoadBalancerProvider getPolicyProvider() {
            return this.policyProvider;
        }

        protected LoadBalancer.Subchannel getSubchannels(LoadBalancer.PickSubchannelArgs args2) {
            if (this.getCurrentPicker() == null) {
                return null;
            }
            return this.getCurrentPicker().pickSubchannel(args2).getSubchannel();
        }

        public ConnectivityState getCurrentState() {
            return this.currentState;
        }

        public LoadBalancer.SubchannelPicker getCurrentPicker() {
            return this.currentPicker;
        }

        public EquivalentAddressGroup getEag() {
            if (this.resolvedAddresses == null || this.resolvedAddresses.getAddresses().isEmpty()) {
                return null;
            }
            return this.resolvedAddresses.getAddresses().get(0);
        }

        public boolean isDeactivated() {
            return this.deactivated;
        }

        protected void setDeactivated() {
            this.deactivated = true;
        }

        protected void markReactivated() {
            this.deactivated = false;
        }

        protected void setResolvedAddresses(LoadBalancer.ResolvedAddresses newAddresses) {
            Preconditions.checkNotNull(newAddresses, "Missing address list for child");
            this.resolvedAddresses = newAddresses;
        }

        protected void deactivate() {
            if (this.deactivated) {
                return;
            }
            MultiChildLoadBalancer.this.childLbStates.remove(this.key);
            this.deactivated = true;
            logger.log(Level.FINE, "Child balancer {0} deactivated", this.key);
        }

        protected void reactivate(LoadBalancerProvider policyProvider) {
            this.deactivated = false;
        }

        protected void shutdown() {
            this.lb.shutdown();
            this.currentState = ConnectivityState.SHUTDOWN;
            logger.log(Level.FINE, "Child balancer {0} deleted", this.key);
        }

        @VisibleForTesting
        public LoadBalancer.ResolvedAddresses getResolvedAddresses() {
            return this.resolvedAddresses;
        }

        private final class ChildLbStateHelper
        extends ForwardingLoadBalancerHelper {
            private ChildLbStateHelper() {
            }

            @Override
            public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
                if (!MultiChildLoadBalancer.this.childLbStates.containsKey(ChildLbState.this.key)) {
                    return;
                }
                ChildLbState.this.currentState = newState;
                ChildLbState.this.currentPicker = newPicker;
                if (!ChildLbState.this.deactivated && !MultiChildLoadBalancer.this.resolvingAddresses) {
                    if (newState == ConnectivityState.IDLE && MultiChildLoadBalancer.this.reconnectOnIdle()) {
                        ChildLbState.this.lb.requestConnection();
                    }
                    MultiChildLoadBalancer.this.updateOverallBalancingState();
                }
            }

            @Override
            protected LoadBalancer.Helper delegate() {
                return MultiChildLoadBalancer.this.helper;
            }
        }
    }
}

