/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.embedded;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.Channel;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.DefaultChannelPromise;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.EventLoop;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.EventLoopGroup;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.AbstractScheduledEventExecutor;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.Future;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;

final class EmbeddedEventLoop
extends AbstractScheduledEventExecutor
implements EventLoop {
    private long startTime = EmbeddedEventLoop.initialNanoTime();
    private long frozenTimestamp;
    private boolean timeFrozen;
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>(2);

    EmbeddedEventLoop() {
    }

    @Override
    public EventLoopGroup parent() {
        return (EventLoopGroup)super.parent();
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public void execute(Runnable command2) {
        this.tasks.add(ObjectUtil.checkNotNull(command2, "command"));
    }

    void runTasks() {
        Runnable task2;
        while ((task2 = this.tasks.poll()) != null) {
            task2.run();
        }
    }

    boolean hasPendingNormalTasks() {
        return !this.tasks.isEmpty();
    }

    long runScheduledTasks() {
        long time = this.getCurrentTimeNanos();
        Runnable task2;
        while ((task2 = this.pollScheduledTask(time)) != null) {
            task2.run();
        }
        return this.nextScheduledTaskNano();
    }

    long nextScheduledTask() {
        return this.nextScheduledTaskNano();
    }

    @Override
    protected long getCurrentTimeNanos() {
        if (this.timeFrozen) {
            return this.frozenTimestamp;
        }
        return System.nanoTime() - this.startTime;
    }

    void advanceTimeBy(long nanos) {
        if (this.timeFrozen) {
            this.frozenTimestamp += nanos;
        } else {
            this.startTime -= nanos;
        }
    }

    void freezeTime() {
        if (!this.timeFrozen) {
            this.frozenTimestamp = this.getCurrentTimeNanos();
            this.timeFrozen = true;
        }
    }

    void unfreezeTime() {
        if (this.timeFrozen) {
            this.startTime = System.nanoTime() - this.frozenTimestamp;
            this.timeFrozen = false;
        }
    }

    @Override
    protected void cancelScheduledTasks() {
        super.cancelScheduledTasks();
    }

    @Override
    public Future<?> shutdownGracefully(long quietPeriod, long timeout2, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Future<?> terminationFuture() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShuttingDown() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean awaitTermination(long timeout2, TimeUnit unit) {
        return false;
    }

    @Override
    public ChannelFuture register(Channel channel2) {
        return this.register(new DefaultChannelPromise(channel2, this));
    }

    @Override
    public ChannelFuture register(ChannelPromise promise) {
        ObjectUtil.checkNotNull(promise, "promise");
        promise.channel().unsafe().register(this, promise);
        return promise;
    }

    @Override
    @Deprecated
    public ChannelFuture register(Channel channel2, ChannelPromise promise) {
        channel2.unsafe().register(this, promise);
        return promise;
    }

    @Override
    public boolean inEventLoop() {
        return true;
    }

    @Override
    public boolean inEventLoop(Thread thread2) {
        return true;
    }
}

