/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.Channel;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.ChannelFuture;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.ChannelPromise;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpRequest;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker00;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker07;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker08;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker13;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public class WebSocketServerHandshakerFactory {
    private final String webSocketURL;
    private final String subprotocols;
    private final WebSocketDecoderConfig decoderConfig;

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions) {
        this(webSocketURL, subprotocols, allowExtensions, 65536);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength) {
        this(webSocketURL, subprotocols, allowExtensions, maxFramePayloadLength, false);
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, boolean allowExtensions, int maxFramePayloadLength, boolean allowMaskMismatch) {
        this(webSocketURL, subprotocols, WebSocketDecoderConfig.newBuilder().allowExtensions(allowExtensions).maxFramePayloadLength(maxFramePayloadLength).allowMaskMismatch(allowMaskMismatch).build());
    }

    public WebSocketServerHandshakerFactory(String webSocketURL, String subprotocols, WebSocketDecoderConfig decoderConfig) {
        this.webSocketURL = webSocketURL;
        this.subprotocols = subprotocols;
        this.decoderConfig = ObjectUtil.checkNotNull(decoderConfig, "decoderConfig");
    }

    public WebSocketServerHandshaker newHandshaker(HttpRequest req) {
        String version = req.headers().get(HttpHeaderNames.SEC_WEBSOCKET_VERSION);
        if (version != null) {
            if (version.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker13(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            if (version.equals(WebSocketVersion.V08.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker08(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            if (version.equals(WebSocketVersion.V07.toHttpHeaderValue())) {
                return new WebSocketServerHandshaker07(this.webSocketURL, this.subprotocols, this.decoderConfig);
            }
            return null;
        }
        return new WebSocketServerHandshaker00(this.webSocketURL, this.subprotocols, this.decoderConfig);
    }

    @Deprecated
    public static void sendUnsupportedWebSocketVersionResponse(Channel channel2) {
        WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel2);
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel2) {
        return WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel2, channel2.newPromise());
    }

    public static ChannelFuture sendUnsupportedVersionResponse(Channel channel2, ChannelPromise promise) {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UPGRADE_REQUIRED, channel2.alloc().buffer(0));
        res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)WebSocketVersion.V13.toHttpHeaderValue());
        HttpUtil.setContentLength(res, 0L);
        return channel2.writeAndFlush(res, promise);
    }
}

