/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.util;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.ByteProcessor;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.CharsetUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.HashingStrategy;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.EmptyArrays;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.InternalThreadLocalMap;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.MathUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;

public final class AsciiString
implements CharSequence,
Comparable<CharSequence> {
    public static final AsciiString EMPTY_STRING = AsciiString.cached("");
    private static final char MAX_CHAR_VALUE = '\u00ff';
    public static final int INDEX_NOT_FOUND = -1;
    private final byte[] value;
    private final int offset;
    private final int length;
    private int hash;
    private String string;
    public static final HashingStrategy<CharSequence> CASE_INSENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEqualsIgnoreCase(a, b);
        }
    };
    public static final HashingStrategy<CharSequence> CASE_SENSITIVE_HASHER = new HashingStrategy<CharSequence>(){

        @Override
        public int hashCode(CharSequence o) {
            return AsciiString.hashCode(o);
        }

        @Override
        public boolean equals(CharSequence a, CharSequence b) {
            return AsciiString.contentEquals(a, b);
        }
    };

    public AsciiString(byte[] value) {
        this(value, true);
    }

    public AsciiString(byte[] value, boolean copy) {
        this(value, 0, value.length, copy);
    }

    public AsciiString(byte[] value, int start2, int length, boolean copy) {
        if (copy) {
            byte[] rangedCopy = new byte[length];
            System.arraycopy(value, start2, rangedCopy, 0, rangedCopy.length);
            this.value = rangedCopy;
            this.offset = 0;
        } else {
            if (MathUtil.isOutOfBounds(start2, length, value.length)) {
                throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
            }
            this.value = value;
            this.offset = start2;
        }
        this.length = length;
    }

    public AsciiString(ByteBuffer value) {
        this(value, true);
    }

    public AsciiString(ByteBuffer value, boolean copy) {
        this(value, value.position(), value.remaining(), copy);
    }

    public AsciiString(ByteBuffer value, int start2, int length, boolean copy) {
        if (MathUtil.isOutOfBounds(start2, length, value.capacity())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.capacity(" + value.capacity() + ')');
        }
        if (value.hasArray()) {
            if (copy) {
                int bufferOffset = value.arrayOffset() + start2;
                this.value = Arrays.copyOfRange(value.array(), bufferOffset, bufferOffset + length);
                this.offset = 0;
            } else {
                this.value = value.array();
                this.offset = start2;
            }
        } else {
            this.value = PlatformDependent.allocateUninitializedArray(length);
            int oldPos = value.position();
            value.get(this.value, 0, length);
            value.position(oldPos);
            this.offset = 0;
        }
        this.length = length;
    }

    public AsciiString(char[] value) {
        this(value, 0, value.length);
    }

    public AsciiString(char[] value, int start2, int length) {
        if (MathUtil.isOutOfBounds(start2, length, value.length)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value.length + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i2 = 0;
        int j = start2;
        while (i2 < length) {
            this.value[i2] = AsciiString.c2b(value[j]);
            ++i2;
            ++j;
        }
        this.offset = 0;
        this.length = length;
    }

    public AsciiString(char[] value, Charset charset) {
        this(value, charset, 0, value.length);
    }

    public AsciiString(char[] value, Charset charset, int start2, int length) {
        CharBuffer cbuf = CharBuffer.wrap(value, start2, length);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        encoder.encode(cbuf, nativeBuffer, true);
        int bufferOffset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), bufferOffset, bufferOffset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public AsciiString(CharSequence value) {
        this(value, 0, value.length());
    }

    public AsciiString(CharSequence value, int start2, int length) {
        if (MathUtil.isOutOfBounds(start2, length, value.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= start + length(" + length + ") <= value.length(" + value.length() + ')');
        }
        this.value = PlatformDependent.allocateUninitializedArray(length);
        int i2 = 0;
        int j = start2;
        while (i2 < length) {
            this.value[i2] = AsciiString.c2b(value.charAt(j));
            ++i2;
            ++j;
        }
        this.offset = 0;
        this.length = length;
    }

    public AsciiString(CharSequence value, Charset charset) {
        this(value, charset, 0, value.length());
    }

    public AsciiString(CharSequence value, Charset charset, int start2, int length) {
        CharBuffer cbuf = CharBuffer.wrap(value, start2, start2 + length);
        CharsetEncoder encoder = CharsetUtil.encoder(charset);
        ByteBuffer nativeBuffer = ByteBuffer.allocate((int)(encoder.maxBytesPerChar() * (float)length));
        encoder.encode(cbuf, nativeBuffer, true);
        int offset = nativeBuffer.arrayOffset();
        this.value = Arrays.copyOfRange(nativeBuffer.array(), offset, offset + nativeBuffer.position());
        this.offset = 0;
        this.length = this.value.length;
    }

    public int forEachByte(ByteProcessor visitor2) throws Exception {
        return this.forEachByte0(0, this.length(), visitor2);
    }

    public int forEachByte(int index, int length, ByteProcessor visitor2) throws Exception {
        if (MathUtil.isOutOfBounds(index, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByte0(index, length, visitor2);
    }

    private int forEachByte0(int index, int length, ByteProcessor visitor2) throws Exception {
        int len = this.offset + index + length;
        for (int i2 = this.offset + index; i2 < len; ++i2) {
            if (visitor2.process(this.value[i2])) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public int forEachByteDesc(ByteProcessor visitor2) throws Exception {
        return this.forEachByteDesc0(0, this.length(), visitor2);
    }

    public int forEachByteDesc(int index, int length, ByteProcessor visitor2) throws Exception {
        if (MathUtil.isOutOfBounds(index, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= index(" + index + ") <= start + length(" + length + ") <= length(" + this.length() + ')');
        }
        return this.forEachByteDesc0(index, length, visitor2);
    }

    private int forEachByteDesc0(int index, int length, ByteProcessor visitor2) throws Exception {
        int end = this.offset + index;
        for (int i2 = this.offset + index + length - 1; i2 >= end; --i2) {
            if (visitor2.process(this.value[i2])) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public byte byteAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException("index: " + index + " must be in the range [0," + this.length + ")");
        }
        if (PlatformDependent.hasUnsafe()) {
            return PlatformDependent.getByte(this.value, index + this.offset);
        }
        return this.value[index + this.offset];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    public void arrayChanged() {
        this.string = null;
        this.hash = 0;
    }

    public byte[] array() {
        return this.value;
    }

    public int arrayOffset() {
        return this.offset;
    }

    public boolean isEntireArrayUsed() {
        return this.offset == 0 && this.length == this.value.length;
    }

    public byte[] toByteArray() {
        return this.toByteArray(0, this.length());
    }

    public byte[] toByteArray(int start2, int end) {
        return Arrays.copyOfRange(this.value, start2 + this.offset, end + this.offset);
    }

    public void copy(int srcIdx, byte[] dst, int dstIdx, int length) {
        if (MathUtil.isOutOfBounds(srcIdx, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        System.arraycopy(this.value, srcIdx + this.offset, ObjectUtil.checkNotNull(dst, "dst"), dstIdx, length);
    }

    @Override
    public char charAt(int index) {
        return AsciiString.b2c(this.byteAt(index));
    }

    public boolean contains(CharSequence cs) {
        return this.indexOf(cs) >= 0;
    }

    @Override
    public int compareTo(CharSequence string) {
        if (this == string) {
            return 0;
        }
        int length1 = this.length();
        int length2 = string.length();
        int minLength = Math.min(length1, length2);
        int i2 = 0;
        int j = this.arrayOffset();
        while (i2 < minLength) {
            int result2 = AsciiString.b2c(this.value[j]) - string.charAt(i2);
            if (result2 != 0) {
                return result2;
            }
            ++i2;
            ++j;
        }
        return length1 - length2;
    }

    public AsciiString concat(CharSequence string) {
        int thisLen = this.length();
        int thatLen = string.length();
        if (thatLen == 0) {
            return this;
        }
        if (string instanceof AsciiString) {
            AsciiString that = (AsciiString)string;
            if (this.isEmpty()) {
                return that;
            }
            byte[] newValue = PlatformDependent.allocateUninitializedArray(thisLen + thatLen);
            System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
            System.arraycopy(that.value, that.arrayOffset(), newValue, thisLen, thatLen);
            return new AsciiString(newValue, false);
        }
        if (this.isEmpty()) {
            return new AsciiString(string);
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(thisLen + thatLen);
        System.arraycopy(this.value, this.arrayOffset(), newValue, 0, thisLen);
        int i2 = thisLen;
        int j = 0;
        while (i2 < newValue.length) {
            newValue[i2] = AsciiString.c2b(string.charAt(j));
            ++i2;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public boolean endsWith(CharSequence suffix) {
        int suffixLen = suffix.length();
        return this.regionMatches(this.length() - suffixLen, suffix, 0, suffixLen);
    }

    public boolean contentEqualsIgnoreCase(CharSequence string) {
        if (this == string) {
            return true;
        }
        if (string == null || string.length() != this.length()) {
            return false;
        }
        if (string instanceof AsciiString) {
            AsciiString rhs = (AsciiString)string;
            int i2 = this.arrayOffset();
            int j = rhs.arrayOffset();
            int end = i2 + this.length();
            while (i2 < end) {
                if (!AsciiString.equalsIgnoreCase(this.value[i2], rhs.value[j])) {
                    return false;
                }
                ++i2;
                ++j;
            }
            return true;
        }
        int i3 = this.arrayOffset();
        int end = this.length();
        for (int j = 0; j < end; ++j) {
            if (!AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[i3]), string.charAt(j))) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    public char[] toCharArray() {
        return this.toCharArray(0, this.length());
    }

    public char[] toCharArray(int start2, int end) {
        int length = end - start2;
        if (length == 0) {
            return EmptyArrays.EMPTY_CHARS;
        }
        if (MathUtil.isOutOfBounds(start2, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        char[] buffer = new char[length];
        int i2 = 0;
        int j = start2 + this.arrayOffset();
        while (i2 < length) {
            buffer[i2] = AsciiString.b2c(this.value[j]);
            ++i2;
            ++j;
        }
        return buffer;
    }

    public void copy(int srcIdx, char[] dst, int dstIdx, int length) {
        ObjectUtil.checkNotNull(dst, "dst");
        if (MathUtil.isOutOfBounds(srcIdx, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + srcIdx + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        int dstEnd = dstIdx + length;
        int i2 = dstIdx;
        int j = srcIdx + this.arrayOffset();
        while (i2 < dstEnd) {
            dst[i2] = AsciiString.b2c(this.value[j]);
            ++i2;
            ++j;
        }
    }

    public AsciiString subSequence(int start2) {
        return this.subSequence(start2, this.length());
    }

    @Override
    public AsciiString subSequence(int start2, int end) {
        return this.subSequence(start2, end, true);
    }

    public AsciiString subSequence(int start2, int end, boolean copy) {
        if (MathUtil.isOutOfBounds(start2, end - start2, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= end (" + end + ") <= length(" + this.length() + ')');
        }
        if (start2 == 0 && end == this.length()) {
            return this;
        }
        if (end == start2) {
            return EMPTY_STRING;
        }
        return new AsciiString(this.value, start2 + this.offset, end - start2, copy);
    }

    public int indexOf(CharSequence string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(CharSequence subString, int start2) {
        int subCount = subString.length();
        if (start2 < 0) {
            start2 = 0;
        }
        if (subCount <= 0) {
            return start2 < this.length ? start2 : this.length;
        }
        if (subCount > this.length - start2) {
            return -1;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        byte firstCharAsByte = AsciiString.c2b0(firstChar);
        int len = this.offset + this.length - subCount;
        for (int i2 = start2 + this.offset; i2 <= len; ++i2) {
            if (this.value[i2] != firstCharAsByte) continue;
            int o1 = i2;
            int o2 = 0;
            while (++o2 < subCount && AsciiString.b2c(this.value[++o1]) == subString.charAt(o2)) {
            }
            if (o2 != subCount) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public int indexOf(char ch, int start2) {
        if (ch > '\u00ff') {
            return -1;
        }
        if (start2 < 0) {
            start2 = 0;
        }
        byte chAsByte = AsciiString.c2b0(ch);
        int len = this.offset + this.length;
        for (int i2 = start2 + this.offset; i2 < len; ++i2) {
            if (this.value[i2] != chAsByte) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public int lastIndexOf(CharSequence string) {
        return this.lastIndexOf(string, this.length);
    }

    public int lastIndexOf(CharSequence subString, int start2) {
        int subCount = subString.length();
        if ((start2 = Math.min(start2, this.length - subCount)) < 0) {
            return -1;
        }
        if (subCount == 0) {
            return start2;
        }
        char firstChar = subString.charAt(0);
        if (firstChar > '\u00ff') {
            return -1;
        }
        byte firstCharAsByte = AsciiString.c2b0(firstChar);
        for (int i2 = this.offset + start2; i2 >= this.offset; --i2) {
            if (this.value[i2] != firstCharAsByte) continue;
            int o1 = i2;
            int o2 = 0;
            while (++o2 < subCount && AsciiString.b2c(this.value[++o1]) == subString.charAt(o2)) {
            }
            if (o2 != subCount) continue;
            return i2 - this.offset;
        }
        return -1;
    }

    public boolean regionMatches(int thisStart, CharSequence string, int start2, int length) {
        ObjectUtil.checkNotNull(string, "string");
        if (start2 < 0 || string.length() - start2 < length) {
            return false;
        }
        int thisLen = this.length();
        if (thisStart < 0 || thisLen - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int thatEnd = start2 + length;
        int i2 = start2;
        int j = thisStart + this.arrayOffset();
        while (i2 < thatEnd) {
            if (AsciiString.b2c(this.value[j]) != string.charAt(i2)) {
                return false;
            }
            ++i2;
            ++j;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int thisStart, CharSequence string, int start2, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string, start2, length);
        }
        ObjectUtil.checkNotNull(string, "string");
        int thisLen = this.length();
        if (thisStart < 0 || length > thisLen - thisStart) {
            return false;
        }
        if (start2 < 0 || length > string.length() - start2) {
            return false;
        }
        int thisEnd = (thisStart += this.arrayOffset()) + length;
        while (thisStart < thisEnd) {
            if (AsciiString.equalsIgnoreCase(AsciiString.b2c(this.value[thisStart++]), string.charAt(start2++))) continue;
            return false;
        }
        return true;
    }

    public AsciiString replace(char oldChar, char newChar) {
        if (oldChar > '\u00ff') {
            return this;
        }
        byte oldCharAsByte = AsciiString.c2b0(oldChar);
        byte newCharAsByte = AsciiString.c2b(newChar);
        int len = this.offset + this.length;
        for (int i2 = this.offset; i2 < len; ++i2) {
            if (this.value[i2] != oldCharAsByte) continue;
            byte[] buffer = PlatformDependent.allocateUninitializedArray(this.length());
            System.arraycopy(this.value, this.offset, buffer, 0, i2 - this.offset);
            buffer[i2 - this.offset] = newCharAsByte;
            ++i2;
            while (i2 < len) {
                byte oldValue = this.value[i2];
                buffer[i2 - this.offset] = oldValue != oldCharAsByte ? oldValue : newCharAsByte;
                ++i2;
            }
            return new AsciiString(buffer, false);
        }
        return this;
    }

    public boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(CharSequence prefix, int start2) {
        return this.regionMatches(start2, prefix, 0, prefix.length());
    }

    public AsciiString toLowerCase() {
        int i2;
        boolean lowercased = true;
        int len = this.length() + this.arrayOffset();
        for (i2 = this.arrayOffset(); i2 < len; ++i2) {
            byte b = this.value[i2];
            if (b < 65 || b > 90) continue;
            lowercased = false;
            break;
        }
        if (lowercased) {
            return this;
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(this.length());
        i2 = 0;
        int j = this.arrayOffset();
        while (i2 < newValue.length) {
            newValue[i2] = AsciiString.toLowerCase(this.value[j]);
            ++i2;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public AsciiString toUpperCase() {
        int i2;
        boolean uppercased = true;
        int len = this.length() + this.arrayOffset();
        for (i2 = this.arrayOffset(); i2 < len; ++i2) {
            byte b = this.value[i2];
            if (b < 97 || b > 122) continue;
            uppercased = false;
            break;
        }
        if (uppercased) {
            return this;
        }
        byte[] newValue = PlatformDependent.allocateUninitializedArray(this.length());
        i2 = 0;
        int j = this.arrayOffset();
        while (i2 < newValue.length) {
            newValue[i2] = AsciiString.toUpperCase(this.value[j]);
            ++i2;
            ++j;
        }
        return new AsciiString(newValue, false);
    }

    public static CharSequence trim(CharSequence c) {
        int start2;
        int last2;
        if (c instanceof AsciiString) {
            return ((AsciiString)c).trim();
        }
        if (c instanceof String) {
            return ((String)c).trim();
        }
        int end = last2 = c.length() - 1;
        for (start2 = 0; start2 <= end && c.charAt(start2) <= ' '; ++start2) {
        }
        while (end >= start2 && c.charAt(end) <= ' ') {
            --end;
        }
        if (start2 == 0 && end == last2) {
            return c;
        }
        return c.subSequence(start2, end);
    }

    public AsciiString trim() {
        int start2;
        int last2;
        int end = last2 = this.arrayOffset() + this.length() - 1;
        for (start2 = this.arrayOffset(); start2 <= end && this.value[start2] <= 32; ++start2) {
        }
        while (end >= start2 && this.value[end] <= 32) {
            --end;
        }
        if (start2 == 0 && end == last2) {
            return this;
        }
        return new AsciiString(this.value, start2, end - start2 + 1, false);
    }

    public boolean contentEquals(CharSequence a) {
        if (this == a) {
            return true;
        }
        if (a == null || a.length() != this.length()) {
            return false;
        }
        if (a instanceof AsciiString) {
            return this.equals(a);
        }
        int i2 = this.arrayOffset();
        for (int j = 0; j < a.length(); ++j) {
            if (AsciiString.b2c(this.value[i2]) != a.charAt(j)) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean matches(String expr) {
        return Pattern.matches(expr, this);
    }

    public AsciiString[] split(String expr, int max) {
        return AsciiString.toAsciiStringArray(Pattern.compile(expr).split(this, max));
    }

    public AsciiString[] split(char delim) {
        int i2;
        ArrayList<AsciiString> res = InternalThreadLocalMap.get().arrayList();
        int start2 = 0;
        int length = this.length();
        for (i2 = start2; i2 < length; ++i2) {
            if (this.charAt(i2) != delim) continue;
            if (start2 == i2) {
                res.add(EMPTY_STRING);
            } else {
                res.add(new AsciiString(this.value, start2 + this.arrayOffset(), i2 - start2, false));
            }
            start2 = i2 + 1;
        }
        if (start2 == 0) {
            res.add(this);
        } else if (start2 != length) {
            res.add(new AsciiString(this.value, start2 + this.arrayOffset(), length - start2, false));
        } else {
            for (i2 = res.size() - 1; i2 >= 0 && ((AsciiString)res.get(i2)).isEmpty(); --i2) {
                res.remove(i2);
            }
        }
        return res.toArray(EmptyArrays.EMPTY_ASCII_STRINGS);
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            this.hash = h2 = PlatformDependent.hashCodeAscii(this.value, this.offset, this.length);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != AsciiString.class) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        AsciiString other = (AsciiString)obj;
        return this.length() == other.length() && this.hashCode() == other.hashCode() && PlatformDependent.equals(this.array(), this.arrayOffset(), other.array(), other.arrayOffset(), this.length());
    }

    @Override
    public String toString() {
        String cache2 = this.string;
        if (cache2 == null) {
            this.string = cache2 = this.toString(0);
        }
        return cache2;
    }

    public String toString(int start2) {
        return this.toString(start2, this.length());
    }

    public String toString(int start2, int end) {
        int length = end - start2;
        if (length == 0) {
            return "";
        }
        if (MathUtil.isOutOfBounds(start2, length, this.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start2 + ") <= srcIdx + length(" + length + ") <= srcLen(" + this.length() + ')');
        }
        String str = new String(this.value, 0, start2 + this.offset, length);
        return str;
    }

    public boolean parseBoolean() {
        return this.length >= 1 && this.value[this.offset] != 0;
    }

    public char parseChar() {
        return this.parseChar(0);
    }

    public char parseChar(int start2) {
        if (start2 + 1 >= this.length()) {
            throw new IndexOutOfBoundsException("2 bytes required to convert to character. index " + start2 + " would go out of bounds.");
        }
        int startWithOffset = start2 + this.offset;
        return (char)(AsciiString.b2c(this.value[startWithOffset]) << 8 | AsciiString.b2c(this.value[startWithOffset + 1]));
    }

    public short parseShort() {
        return this.parseShort(0, this.length(), 10);
    }

    public short parseShort(int radix) {
        return this.parseShort(0, this.length(), radix);
    }

    public short parseShort(int start2, int end) {
        return this.parseShort(start2, end, 10);
    }

    public short parseShort(int start2, int end, int radix) {
        int intValue = this.parseInt(start2, end, radix);
        short result2 = (short)intValue;
        if (result2 != intValue) {
            throw new NumberFormatException(this.subSequence(start2, end, false).toString());
        }
        return result2;
    }

    public int parseInt() {
        return this.parseInt(0, this.length(), 10);
    }

    public int parseInt(int radix) {
        return this.parseInt(0, this.length(), radix);
    }

    public int parseInt(int start2, int end) {
        return this.parseInt(start2, end, 10);
    }

    public int parseInt(int start2, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start2 == end) {
            throw new NumberFormatException();
        }
        int i2 = start2;
        boolean bl = negative = this.byteAt(i2) == 45;
        if (negative && ++i2 == end) {
            throw new NumberFormatException(this.subSequence(start2, end, false).toString());
        }
        return this.parseInt(i2, end, radix, negative);
    }

    private int parseInt(int start2, int end, int radix, boolean negative) {
        int max = Integer.MIN_VALUE / radix;
        int result2 = 0;
        int currOffset = start2;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start2, end, false).toString());
            }
            if (max > result2) {
                throw new NumberFormatException(this.subSequence(start2, end, false).toString());
            }
            int next = result2 * radix - digit;
            if (next > result2) {
                throw new NumberFormatException(this.subSequence(start2, end, false).toString());
            }
            result2 = next;
        }
        if (!negative && (result2 = -result2) < 0) {
            throw new NumberFormatException(this.subSequence(start2, end, false).toString());
        }
        return result2;
    }

    public long parseLong() {
        return this.parseLong(0, this.length(), 10);
    }

    public long parseLong(int radix) {
        return this.parseLong(0, this.length(), radix);
    }

    public long parseLong(int start2, int end) {
        return this.parseLong(start2, end, 10);
    }

    public long parseLong(int start2, int end, int radix) {
        boolean negative;
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        if (start2 == end) {
            throw new NumberFormatException();
        }
        int i2 = start2;
        boolean bl = negative = this.byteAt(i2) == 45;
        if (negative && ++i2 == end) {
            throw new NumberFormatException(this.subSequence(start2, end, false).toString());
        }
        return this.parseLong(i2, end, radix, negative);
    }

    private long parseLong(int start2, int end, int radix, boolean negative) {
        long max = Long.MIN_VALUE / (long)radix;
        long result2 = 0L;
        int currOffset = start2;
        while (currOffset < end) {
            int digit;
            if ((digit = Character.digit((char)(this.value[currOffset++ + this.offset] & 0xFF), radix)) == -1) {
                throw new NumberFormatException(this.subSequence(start2, end, false).toString());
            }
            if (max > result2) {
                throw new NumberFormatException(this.subSequence(start2, end, false).toString());
            }
            long next = result2 * (long)radix - (long)digit;
            if (next > result2) {
                throw new NumberFormatException(this.subSequence(start2, end, false).toString());
            }
            result2 = next;
        }
        if (!negative && (result2 = -result2) < 0L) {
            throw new NumberFormatException(this.subSequence(start2, end, false).toString());
        }
        return result2;
    }

    public float parseFloat() {
        return this.parseFloat(0, this.length());
    }

    public float parseFloat(int start2, int end) {
        return Float.parseFloat(this.toString(start2, end));
    }

    public double parseDouble() {
        return this.parseDouble(0, this.length());
    }

    public double parseDouble(int start2, int end) {
        return Double.parseDouble(this.toString(start2, end));
    }

    public static AsciiString of(CharSequence string) {
        return string instanceof AsciiString ? (AsciiString)string : new AsciiString(string);
    }

    public static AsciiString cached(String string) {
        AsciiString asciiString = new AsciiString(string);
        asciiString.string = string;
        return asciiString;
    }

    public static int hashCode(CharSequence value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof AsciiString) {
            return value.hashCode();
        }
        return PlatformDependent.hashCodeAscii(value);
    }

    public static boolean contains(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean containsIgnoreCase(CharSequence a, CharSequence b) {
        return AsciiString.contains(a, b, AsciiCaseInsensitiveCharEqualityComparator.INSTANCE);
    }

    public static boolean contentEqualsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEqualsIgnoreCase(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEqualsIgnoreCase(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i2 = 0; i2 < a.length(); ++i2) {
            if (AsciiString.equalsIgnoreCase(a.charAt(i2), b.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static boolean containsContentEqualsIgnoreCase(Collection<CharSequence> collection, CharSequence value) {
        for (CharSequence v : collection) {
            if (!AsciiString.contentEqualsIgnoreCase(value, v)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAllContentEqualsIgnoreCase(Collection<CharSequence> a, Collection<CharSequence> b) {
        for (CharSequence v : b) {
            if (AsciiString.containsContentEqualsIgnoreCase(a, v)) continue;
            return false;
        }
        return true;
    }

    public static boolean contentEquals(CharSequence a, CharSequence b) {
        if (a == null || b == null) {
            return a == b;
        }
        if (a instanceof AsciiString) {
            return ((AsciiString)a).contentEquals(b);
        }
        if (b instanceof AsciiString) {
            return ((AsciiString)b).contentEquals(a);
        }
        if (a.length() != b.length()) {
            return false;
        }
        for (int i2 = 0; i2 < a.length(); ++i2) {
            if (a.charAt(i2) == b.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    private static AsciiString[] toAsciiStringArray(String[] jdkResult) {
        AsciiString[] res = new AsciiString[jdkResult.length];
        for (int i2 = 0; i2 < jdkResult.length; ++i2) {
            res[i2] = new AsciiString(jdkResult[i2]);
        }
        return res;
    }

    private static boolean contains(CharSequence a, CharSequence b, CharEqualityComparator cmp) {
        if (a == null || b == null || a.length() < b.length()) {
            return false;
        }
        if (b.length() == 0) {
            return true;
        }
        int bStart = 0;
        for (int i2 = 0; i2 < a.length(); ++i2) {
            if (cmp.equals(b.charAt(bStart), a.charAt(i2))) {
                if (++bStart != b.length()) continue;
                return true;
            }
            if (a.length() - i2 < b.length()) {
                return false;
            }
            bStart = 0;
        }
        return false;
    }

    private static boolean regionMatchesCharSequences(CharSequence cs, int csStart, CharSequence string, int start2, int length, CharEqualityComparator charEqualityComparator) {
        if (csStart < 0 || length > cs.length() - csStart) {
            return false;
        }
        if (start2 < 0 || length > string.length() - start2) {
            return false;
        }
        int csIndex = csStart;
        int csEnd = csIndex + length;
        int stringIndex = start2;
        while (csIndex < csEnd) {
            char c2;
            char c1;
            if (charEqualityComparator.equals(c1 = cs.charAt(csIndex++), c2 = string.charAt(stringIndex++))) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string, int start2, int length) {
        if (cs == null || string == null) {
            return false;
        }
        if (cs instanceof String && string instanceof String) {
            return ((String)cs).regionMatches(ignoreCase, csStart, (String)string, start2, length);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase, csStart, string, start2, length);
        }
        return AsciiString.regionMatchesCharSequences(cs, csStart, string, start2, length, ignoreCase ? GeneralCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    public static boolean regionMatchesAscii(CharSequence cs, boolean ignoreCase, int csStart, CharSequence string, int start2, int length) {
        if (cs == null || string == null) {
            return false;
        }
        if (!ignoreCase && cs instanceof String && string instanceof String) {
            return ((String)cs).regionMatches(false, csStart, (String)string, start2, length);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).regionMatches(ignoreCase, csStart, string, start2, length);
        }
        return AsciiString.regionMatchesCharSequences(cs, csStart, string, start2, length, ignoreCase ? AsciiCaseInsensitiveCharEqualityComparator.INSTANCE : DefaultCharEqualityComparator.INSTANCE);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 < endLimit; ++i2) {
            if (!AsciiString.regionMatches(str, true, i2, searchStr, 0, searchStrLen)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOfIgnoreCaseAscii(CharSequence str, CharSequence searchStr, int startPos) {
        if (str == null || searchStr == null) {
            return -1;
        }
        if (startPos < 0) {
            startPos = 0;
        }
        int searchStrLen = searchStr.length();
        int endLimit = str.length() - searchStrLen + 1;
        if (startPos > endLimit) {
            return -1;
        }
        if (searchStrLen == 0) {
            return startPos;
        }
        for (int i2 = startPos; i2 < endLimit; ++i2) {
            if (!AsciiString.regionMatchesAscii(str, true, i2, searchStr, 0, searchStrLen)) continue;
            return i2;
        }
        return -1;
    }

    public static int indexOf(CharSequence cs, char searchChar, int start2) {
        int i2;
        if (cs instanceof String) {
            return ((String)cs).indexOf(searchChar, start2);
        }
        if (cs instanceof AsciiString) {
            return ((AsciiString)cs).indexOf(searchChar, start2);
        }
        if (cs == null) {
            return -1;
        }
        int sz = cs.length();
        int n = i2 = start2 < 0 ? 0 : start2;
        while (i2 < sz) {
            if (cs.charAt(i2) == searchChar) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private static boolean equalsIgnoreCase(byte a, byte b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static boolean equalsIgnoreCase(char a, char b) {
        return a == b || AsciiString.toLowerCase(a) == AsciiString.toLowerCase(b);
    }

    private static byte toLowerCase(byte b) {
        return AsciiString.isUpperCase(b) ? (byte)(b + 32) : b;
    }

    public static char toLowerCase(char c) {
        return AsciiString.isUpperCase(c) ? (char)(c + 32) : c;
    }

    private static byte toUpperCase(byte b) {
        return AsciiString.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    private static boolean isLowerCase(byte value) {
        return value >= 97 && value <= 122;
    }

    public static boolean isUpperCase(byte value) {
        return value >= 65 && value <= 90;
    }

    public static boolean isUpperCase(char value) {
        return value >= 'A' && value <= 'Z';
    }

    public static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (int)c);
    }

    private static byte c2b0(char c) {
        return (byte)c;
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }

    private static final class GeneralCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final GeneralCaseInsensitiveCharEqualityComparator INSTANCE = new GeneralCaseInsensitiveCharEqualityComparator();

        private GeneralCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b);
        }
    }

    private static final class AsciiCaseInsensitiveCharEqualityComparator
    implements CharEqualityComparator {
        static final AsciiCaseInsensitiveCharEqualityComparator INSTANCE = new AsciiCaseInsensitiveCharEqualityComparator();

        private AsciiCaseInsensitiveCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return AsciiString.equalsIgnoreCase(a, b);
        }
    }

    private static final class DefaultCharEqualityComparator
    implements CharEqualityComparator {
        static final DefaultCharEqualityComparator INSTANCE = new DefaultCharEqualityComparator();

        private DefaultCharEqualityComparator() {
        }

        @Override
        public boolean equals(char a, char b) {
            return a == b;
        }
    }

    private static interface CharEqualityComparator {
        public boolean equals(char var1, char var2);
    }
}

