/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.DefaultProgressivePromise;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.DefaultPromise;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.EventExecutor;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.EventExecutorGroup;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.FailedFuture;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.Future;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.ProgressivePromise;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.Promise;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.PromiseTask;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.ScheduledFuture;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.concurrent.SucceededFuture;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Async;

public abstract class AbstractEventExecutor
extends AbstractExecutorService
implements EventExecutor {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractEventExecutor.class);
    static final long DEFAULT_SHUTDOWN_QUIET_PERIOD = 2L;
    static final long DEFAULT_SHUTDOWN_TIMEOUT = 15L;
    private final EventExecutorGroup parent;
    private final Collection<EventExecutor> selfCollection = Collections.singleton(this);

    protected AbstractEventExecutor() {
        this(null);
    }

    protected AbstractEventExecutor(EventExecutorGroup parent) {
        this.parent = parent;
    }

    @Override
    public EventExecutorGroup parent() {
        return this.parent;
    }

    @Override
    public EventExecutor next() {
        return this;
    }

    @Override
    public boolean inEventLoop() {
        return this.inEventLoop(Thread.currentThread());
    }

    @Override
    public Iterator<EventExecutor> iterator() {
        return this.selfCollection.iterator();
    }

    @Override
    public Future<?> shutdownGracefully() {
        return this.shutdownGracefully(2L, 15L, TimeUnit.SECONDS);
    }

    @Override
    @Deprecated
    public abstract void shutdown();

    @Override
    @Deprecated
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public <V> Promise<V> newPromise() {
        return new DefaultPromise(this);
    }

    @Override
    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new DefaultProgressivePromise(this);
    }

    @Override
    public <V> Future<V> newSucceededFuture(V result2) {
        return new SucceededFuture<V>(this, result2);
    }

    @Override
    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new FailedFuture(this, cause);
    }

    @Override
    public Future<?> submit(Runnable task2) {
        return (Future)super.submit(task2);
    }

    @Override
    public <T> Future<T> submit(Runnable task2, T result2) {
        return (Future)super.submit(task2, result2);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task2) {
        return (Future)super.submit(task2);
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new PromiseTask<T>(this, runnable, value);
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new PromiseTask<T>((EventExecutor)this, callable);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command2, long delay2, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay2, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command2, long initialDelay, long period, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command2, long initialDelay, long delay2, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    protected static void safeExecute(Runnable task2) {
        try {
            AbstractEventExecutor.runTask(task2);
        }
        catch (Throwable t2) {
            logger.warn("A task raised an exception. Task: {}", (Object)task2, (Object)t2);
        }
    }

    protected static void runTask(@Async.Execute Runnable task2) {
        task2.run();
    }

    public void lazyExecute(Runnable task2) {
        this.execute(task2);
    }

    @Deprecated
    public static interface LazyRunnable
    extends Runnable {
    }
}

