/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.protobuf;

import app.simplecloud.relocate.protobuf.ByteString;
import app.simplecloud.relocate.protobuf.CodedInputStream;
import app.simplecloud.relocate.protobuf.CodedOutputStream;
import app.simplecloud.relocate.protobuf.ExtensionRegistryLite;
import app.simplecloud.relocate.protobuf.FieldSet;
import app.simplecloud.relocate.protobuf.MapFieldLite;
import app.simplecloud.relocate.protobuf.MessageLite;
import app.simplecloud.relocate.protobuf.WireFormat;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class MapEntryLite<K, V> {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private final K key;
    private final V value;

    private MapEntryLite(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        this.metadata = new Metadata<K, V>(keyType, defaultKey, valueType, defaultValue);
        this.key = defaultKey;
        this.value = defaultValue;
    }

    private MapEntryLite(Metadata<K, V> metadata, K key2, V value) {
        this.metadata = metadata;
        this.key = key2;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> MapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
        return new MapEntryLite<K, V>(keyType, defaultKey, valueType, defaultValue);
    }

    static <K, V> void writeTo(CodedOutputStream output2, Metadata<K, V> metadata, K key2, V value) throws IOException {
        FieldSet.writeElement(output2, metadata.keyType, 1, key2);
        FieldSet.writeElement(output2, metadata.valueType, 2, value);
    }

    static <K, V> int computeSerializedSize(Metadata<K, V> metadata, K key2, V value) {
        return FieldSet.computeElementSize(metadata.keyType, 1, key2) + FieldSet.computeElementSize(metadata.valueType, 2, value);
    }

    static <T> T parseField(CodedInputStream input2, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type, T value) throws IOException {
        switch (type) {
            case MESSAGE: {
                MessageLite.Builder subBuilder = ((MessageLite)value).toBuilder();
                input2.readMessage(subBuilder, extensionRegistry);
                return (T)subBuilder.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(input2.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(input2, type, true);
    }

    public void serializeTo(CodedOutputStream output2, int fieldNumber, K key2, V value) throws IOException {
        output2.writeTag(fieldNumber, 2);
        output2.writeUInt32NoTag(MapEntryLite.computeSerializedSize(this.metadata, key2, value));
        MapEntryLite.writeTo(output2, this.metadata, key2, value);
    }

    public int computeMessageSize(int fieldNumber, K key2, V value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(MapEntryLite.computeSerializedSize(this.metadata, key2, value));
    }

    public Map.Entry<K, V> parseEntry(ByteString bytes, ExtensionRegistryLite extensionRegistry) throws IOException {
        return MapEntryLite.parseEntry(bytes.newCodedInput(), this.metadata, extensionRegistry);
    }

    static <K, V> Map.Entry<K, V> parseEntry(CodedInputStream input2, Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
        int tag;
        Object key2 = metadata.defaultKey;
        Object value = metadata.defaultValue;
        while ((tag = input2.readTag()) != 0) {
            if (tag == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                key2 = MapEntryLite.parseField(input2, extensionRegistry, metadata.keyType, key2);
                continue;
            }
            if (tag == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                value = MapEntryLite.parseField(input2, extensionRegistry, metadata.valueType, value);
                continue;
            }
            if (input2.skipField(tag)) continue;
            break;
        }
        return new AbstractMap.SimpleImmutableEntry(key2, value);
    }

    public void parseInto(MapFieldLite<K, V> map2, CodedInputStream input2, ExtensionRegistryLite extensionRegistry) throws IOException {
        int tag;
        int length = input2.readRawVarint32();
        int oldLimit = input2.pushLimit(length);
        Object key2 = this.metadata.defaultKey;
        Object value = this.metadata.defaultValue;
        while ((tag = input2.readTag()) != 0) {
            if (tag == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                key2 = MapEntryLite.parseField(input2, extensionRegistry, this.metadata.keyType, key2);
                continue;
            }
            if (tag == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                value = MapEntryLite.parseField(input2, extensionRegistry, this.metadata.valueType, value);
                continue;
            }
            if (input2.skipField(tag)) continue;
            break;
        }
        input2.checkLastTagWas(0);
        input2.popLimit(oldLimit);
        map2.put(key2, value);
    }

    Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    static class Metadata<K, V> {
        public final WireFormat.FieldType keyType;
        public final K defaultKey;
        public final WireFormat.FieldType valueType;
        public final V defaultValue;

        public Metadata(WireFormat.FieldType keyType, K defaultKey, WireFormat.FieldType valueType, V defaultValue) {
            this.keyType = keyType;
            this.defaultKey = defaultKey;
            this.valueType = valueType;
            this.defaultValue = defaultValue;
        }
    }
}

