/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.protobuf;

import app.simplecloud.relocate.protobuf.ByteString;

final class TextFormatEscaper {
    private TextFormatEscaper() {
    }

    static String escapeBytes(ByteSequence input2) {
        StringBuilder builder2 = new StringBuilder(input2.size());
        block12: for (int i2 = 0; i2 < input2.size(); ++i2) {
            byte b = input2.byteAt(i2);
            switch (b) {
                case 7: {
                    builder2.append("\\a");
                    continue block12;
                }
                case 8: {
                    builder2.append("\\b");
                    continue block12;
                }
                case 12: {
                    builder2.append("\\f");
                    continue block12;
                }
                case 10: {
                    builder2.append("\\n");
                    continue block12;
                }
                case 13: {
                    builder2.append("\\r");
                    continue block12;
                }
                case 9: {
                    builder2.append("\\t");
                    continue block12;
                }
                case 11: {
                    builder2.append("\\v");
                    continue block12;
                }
                case 92: {
                    builder2.append("\\\\");
                    continue block12;
                }
                case 39: {
                    builder2.append("\\'");
                    continue block12;
                }
                case 34: {
                    builder2.append("\\\"");
                    continue block12;
                }
                default: {
                    if (b >= 32 && b <= 126) {
                        builder2.append((char)b);
                        continue block12;
                    }
                    builder2.append('\\');
                    builder2.append((char)(48 + (b >>> 6 & 3)));
                    builder2.append((char)(48 + (b >>> 3 & 7)));
                    builder2.append((char)(48 + (b & 7)));
                }
            }
        }
        return builder2.toString();
    }

    static String escapeBytes(final ByteString input2) {
        return TextFormatEscaper.escapeBytes(new ByteSequence(){

            @Override
            public int size() {
                return input2.size();
            }

            @Override
            public byte byteAt(int offset) {
                return input2.byteAt(offset);
            }
        });
    }

    static String escapeBytes(final byte[] input2) {
        return TextFormatEscaper.escapeBytes(new ByteSequence(){

            @Override
            public int size() {
                return input2.length;
            }

            @Override
            public byte byteAt(int offset) {
                return input2[offset];
            }
        });
    }

    static String escapeText(String input2) {
        return TextFormatEscaper.escapeBytes(ByteString.copyFromUtf8(input2));
    }

    static String escapeDoubleQuotesAndBackslashes(String input2) {
        return input2.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private static interface ByteSequence {
        public int size();

        public byte byteAt(int var1);
    }
}

