/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.controller.api.impl.future;

import app.simplecloud.relocate.buf.simplecloud.controller.v1.ControllerGroupServiceGrpc;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.CreateGroupRequest;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.DeleteGroupByNameRequest;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.GetAllGroupsRequest;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.GetAllGroupsResponse;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.GetGroupByNameRequest;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.GetGroupByNameResponse;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.GetGroupsByTypeRequest;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.GetGroupsByTypeResponse;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.GroupDefinition;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.ServerType;
import app.simplecloud.relocate.buf.simplecloud.controller.v1.UpdateGroupRequest;
import app.simplecloud.relocate.controller.api.GroupApi;
import app.simplecloud.relocate.controller.shared.group.Group;
import app.simplecloud.relocate.droplet.api.auth.AuthCallCredentials;
import app.simplecloud.relocate.droplet.api.future.ListenableFutureExtensionKt;
import app.simplecloud.relocate.grpc.ManagedChannel;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0014\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00140\u000bH\u0016J\u001c\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00140\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lapp/simplecloud/relocate/controller/api/impl/future/GroupApiFutureImpl;", "Lapp/simplecloud/relocate/controller/api/GroupApi$Future;", "managedChannel", "Lapp/simplecloud/relocate/grpc/ManagedChannel;", "authCallCredentials", "Lapp/simplecloud/relocate/droplet/api/auth/AuthCallCredentials;", "<init>", "(Lio/grpc/ManagedChannel;Lapp/simplecloud/droplet/api/auth/AuthCallCredentials;)V", "groupServiceStub", "Lapp/simplecloud/relocate/buf/simplecloud/controller/v1/ControllerGroupServiceGrpc$ControllerGroupServiceFutureStub;", "getGroupByName", "Ljava/util/concurrent/CompletableFuture;", "Lapp/simplecloud/relocate/controller/shared/group/Group;", "name", "", "deleteGroup", "createGroup", "group", "updateGroup", "getAllGroups", "", "getGroupsByType", "type", "Lapp/simplecloud/relocate/buf/simplecloud/controller/v1/ServerType;", "controller-api"})
@SourceDebugExtension(value={"SMAP\nGroupApiFutureImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupApiFutureImpl.kt\napp/simplecloud/controller/api/impl/future/GroupApiFutureImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1557#2:87\n1628#2,3:88\n1557#2:91\n1628#2,3:92\n*S KotlinDebug\n*F\n+ 1 GroupApiFutureImpl.kt\napp/simplecloud/controller/api/impl/future/GroupApiFutureImpl\n*L\n72#1:87\n72#1:88,3\n82#1:91\n82#1:92,3\n*E\n"})
public final class GroupApiFutureImpl
implements GroupApi.Future {
    @NotNull
    private final ControllerGroupServiceGrpc.ControllerGroupServiceFutureStub groupServiceStub;

    public GroupApiFutureImpl(@NotNull ManagedChannel managedChannel, @NotNull AuthCallCredentials authCallCredentials) {
        Intrinsics.checkNotNullParameter(managedChannel, "managedChannel");
        Intrinsics.checkNotNullParameter(authCallCredentials, "authCallCredentials");
        Object s2 = ControllerGroupServiceGrpc.newFutureStub(managedChannel).withCallCredentials(authCallCredentials);
        Intrinsics.checkNotNullExpressionValue(s2, "withCallCredentials(...)");
        this.groupServiceStub = (ControllerGroupServiceGrpc.ControllerGroupServiceFutureStub)s2;
    }

    @Override
    @NotNull
    public CompletableFuture<Group> getGroupByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ListenableFuture<GetGroupByNameResponse> listenableFuture = this.groupServiceStub.getGroupByName(GetGroupByNameRequest.newBuilder().setGroupName(name).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getGroupByName(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> GroupApiFutureImpl.getGroupByName$lambda$1(GroupApiFutureImpl::getGroupByName$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Group> deleteGroup(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ListenableFuture<GroupDefinition> listenableFuture = this.groupServiceStub.deleteGroupByName(DeleteGroupByNameRequest.newBuilder().setGroupName(name).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "deleteGroupByName(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> GroupApiFutureImpl.deleteGroup$lambda$3(GroupApiFutureImpl::deleteGroup$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Group> createGroup(@NotNull Group group) {
        Intrinsics.checkNotNullParameter(group, "group");
        ListenableFuture<GroupDefinition> listenableFuture = this.groupServiceStub.createGroup(CreateGroupRequest.newBuilder().setGroup(group.toDefinition()).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "createGroup(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> GroupApiFutureImpl.createGroup$lambda$5(GroupApiFutureImpl::createGroup$lambda$4, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Group> updateGroup(@NotNull Group group) {
        Intrinsics.checkNotNullParameter(group, "group");
        ListenableFuture<GroupDefinition> listenableFuture = this.groupServiceStub.updateGroup(UpdateGroupRequest.newBuilder().setGroup(group.toDefinition()).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "updateGroup(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> GroupApiFutureImpl.updateGroup$lambda$7(GroupApiFutureImpl::updateGroup$lambda$6, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<List<Group>> getAllGroups() {
        ListenableFuture<GetAllGroupsResponse> listenableFuture = this.groupServiceStub.getAllGroups(GetAllGroupsRequest.newBuilder().build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getAllGroups(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> GroupApiFutureImpl.getAllGroups$lambda$10(GroupApiFutureImpl::getAllGroups$lambda$9, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<List<Group>> getGroupsByType(@NotNull ServerType type) {
        Intrinsics.checkNotNullParameter(type, "type");
        ListenableFuture<GetGroupsByTypeResponse> listenableFuture = this.groupServiceStub.getGroupsByType(GetGroupsByTypeRequest.newBuilder().setServerType(type).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getGroupsByType(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> GroupApiFutureImpl.getGroupsByType$lambda$13(GroupApiFutureImpl::getGroupsByType$lambda$12, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    private static final Group getGroupByName$lambda$0(GetGroupByNameResponse it) {
        GroupDefinition groupDefinition = it.getGroup();
        Intrinsics.checkNotNullExpressionValue(groupDefinition, "getGroup(...)");
        return Group.Companion.fromDefinition(groupDefinition);
    }

    private static final Group getGroupByName$lambda$1(Function1 $tmp0, Object p0) {
        return (Group)$tmp0.invoke(p0);
    }

    private static final Group deleteGroup$lambda$2(GroupDefinition it) {
        Intrinsics.checkNotNull(it);
        return Group.Companion.fromDefinition(it);
    }

    private static final Group deleteGroup$lambda$3(Function1 $tmp0, Object p0) {
        return (Group)$tmp0.invoke(p0);
    }

    private static final Group createGroup$lambda$4(GroupDefinition it) {
        Intrinsics.checkNotNull(it);
        return Group.Companion.fromDefinition(it);
    }

    private static final Group createGroup$lambda$5(Function1 $tmp0, Object p0) {
        return (Group)$tmp0.invoke(p0);
    }

    private static final Group updateGroup$lambda$6(GroupDefinition it) {
        Intrinsics.checkNotNull(it);
        return Group.Companion.fromDefinition(it);
    }

    private static final Group updateGroup$lambda$7(Function1 $tmp0, Object p0) {
        return (Group)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getAllGroups$lambda$9(GetAllGroupsResponse it) {
        void $this$mapTo$iv$iv;
        List<GroupDefinition> list = it.getGroupsList();
        Intrinsics.checkNotNullExpressionValue(list, "getGroupsList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            GroupDefinition groupDefinition = (GroupDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(group);
            collection.add(Group.Companion.fromDefinition((GroupDefinition)group));
        }
        return (List)destination$iv$iv;
    }

    private static final List getAllGroups$lambda$10(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getGroupsByType$lambda$12(GetGroupsByTypeResponse it) {
        void $this$mapTo$iv$iv;
        List<GroupDefinition> list = it.getGroupsList();
        Intrinsics.checkNotNullExpressionValue(list, "getGroupsList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void group;
            GroupDefinition groupDefinition = (GroupDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(group);
            collection.add(Group.Companion.fromDefinition((GroupDefinition)group));
        }
        return (List)destination$iv$iv;
    }

    private static final List getGroupsByType$lambda$13(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }
}

