/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc;

import app.simplecloud.relocate.grpc.CallCredentials;
import app.simplecloud.relocate.grpc.Context;
import app.simplecloud.relocate.grpc.ExperimentalApi;
import app.simplecloud.relocate.grpc.Metadata;
import app.simplecloud.relocate.grpc.Status;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/1914")
public final class CompositeCallCredentials
extends CallCredentials {
    private final CallCredentials credentials1;
    private final CallCredentials credentials2;

    public CompositeCallCredentials(CallCredentials creds1, CallCredentials creds2) {
        this.credentials1 = Preconditions.checkNotNull(creds1, "creds1");
        this.credentials2 = Preconditions.checkNotNull(creds2, "creds2");
    }

    @Override
    public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
        this.credentials1.applyRequestMetadata(requestInfo, appExecutor, new WrappingMetadataApplier(requestInfo, appExecutor, applier, Context.current()));
    }

    private static final class CombiningMetadataApplier
    extends CallCredentials.MetadataApplier {
        private final CallCredentials.MetadataApplier delegate;
        private final Metadata firstHeaders;

        public CombiningMetadataApplier(CallCredentials.MetadataApplier delegate, Metadata firstHeaders) {
            this.delegate = delegate;
            this.firstHeaders = firstHeaders;
        }

        @Override
        public void apply(Metadata headers2) {
            Preconditions.checkNotNull(headers2, "headers");
            Metadata combined = new Metadata();
            combined.merge(this.firstHeaders);
            combined.merge(headers2);
            this.delegate.apply(combined);
        }

        @Override
        public void fail(Status status) {
            this.delegate.fail(status);
        }
    }

    private final class WrappingMetadataApplier
    extends CallCredentials.MetadataApplier {
        private final CallCredentials.RequestInfo requestInfo;
        private final Executor appExecutor;
        private final CallCredentials.MetadataApplier delegate;
        private final Context context;

        public WrappingMetadataApplier(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier delegate, Context context) {
            this.requestInfo = requestInfo;
            this.appExecutor = appExecutor;
            this.delegate = Preconditions.checkNotNull(delegate, "delegate");
            this.context = Preconditions.checkNotNull(context, "context");
        }

        @Override
        public void apply(Metadata headers2) {
            Preconditions.checkNotNull(headers2, "headers");
            Context previous = this.context.attach();
            try {
                CompositeCallCredentials.this.credentials2.applyRequestMetadata(this.requestInfo, this.appExecutor, new CombiningMetadataApplier(this.delegate, headers2));
            }
            finally {
                this.context.detach(previous);
            }
        }

        @Override
        public void fail(Status status) {
            this.delegate.fail(status);
        }
    }
}

