/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.internal;

import app.simplecloud.relocate.grpc.CallOptions;
import app.simplecloud.relocate.grpc.ClientStreamTracer;
import app.simplecloud.relocate.grpc.InternalChannelz;
import app.simplecloud.relocate.grpc.InternalLogId;
import app.simplecloud.relocate.grpc.Metadata;
import app.simplecloud.relocate.grpc.MethodDescriptor;
import app.simplecloud.relocate.grpc.Status;
import app.simplecloud.relocate.grpc.internal.ClientStream;
import app.simplecloud.relocate.grpc.internal.ClientStreamListener;
import app.simplecloud.relocate.grpc.internal.ClientTransport;
import app.simplecloud.relocate.grpc.internal.FailingClientStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.Executor;

class FailingClientTransport
implements ClientTransport {
    @VisibleForTesting
    final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    FailingClientTransport(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers2, CallOptions callOptions, ClientStreamTracer[] tracers) {
        return new FailingClientStream(this.error, this.rpcProgress, tracers);
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, Executor executor2) {
        executor2.execute(new Runnable(){

            @Override
            public void run() {
                callback.onFailure(FailingClientTransport.this.error.asException());
            }
        });
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture<InternalChannelz.SocketStats> ret2 = SettableFuture.create();
        ret2.set(null);
        return ret2;
    }

    @Override
    public InternalLogId getLogId() {
        throw new UnsupportedOperationException("Not a real transport");
    }
}

