/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.channel.embedded.EmbeddedChannel;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.compression.Brotli;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.compression.BrotliDecoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.compression.SnappyFrameDecoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibCodecFactory;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.compression.ZlibWrapper;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpContentDecoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;

public class HttpContentDecompressor
extends HttpContentDecoder {
    private final boolean strict;

    public HttpContentDecompressor() {
        this(false);
    }

    public HttpContentDecompressor(boolean strict) {
        this.strict = strict;
    }

    @Override
    protected EmbeddedChannel newContentDecoder(String contentEncoding) throws Exception {
        if (HttpHeaderValues.GZIP.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_GZIP.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(ZlibWrapper.GZIP));
        }
        if (HttpHeaderValues.DEFLATE.contentEqualsIgnoreCase(contentEncoding) || HttpHeaderValues.X_DEFLATE.contentEqualsIgnoreCase(contentEncoding)) {
            ZlibWrapper wrapper = this.strict ? ZlibWrapper.ZLIB : ZlibWrapper.ZLIB_OR_NONE;
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), ZlibCodecFactory.newZlibDecoder(wrapper));
        }
        if (Brotli.isAvailable() && HttpHeaderValues.BR.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new BrotliDecoder());
        }
        if (HttpHeaderValues.SNAPPY.contentEqualsIgnoreCase(contentEncoding)) {
            return new EmbeddedChannel(this.ctx.channel().id(), this.ctx.channel().metadata().hasDisconnect(), this.ctx.channel().config(), new SnappyFrameDecoder());
        }
        return null;
    }
}

