/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import app.simplecloud.relocate.grpc.netty.shaded.io.netty.buffer.Unpooled;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpRequest;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.FullHttpResponse;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpHeaders;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpMethod;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.HttpVersion;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket07FrameDecoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocket07FrameEncoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.CharsetUtil;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.logging.InternalLogger;
import app.simplecloud.relocate.grpc.netty.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.URI;

public class WebSocketClientHandshaker07
extends WebSocketClientHandshaker {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketClientHandshaker07.class);
    public static final String MAGIC_GUID = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
    private String expectedChallengeResponseString;
    private final boolean allowExtensions;
    private final boolean performMasking;
    private final boolean allowMaskMismatch;

    public WebSocketClientHandshaker07(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, true, false);
    }

    public WebSocketClientHandshaker07(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, 10000L);
    }

    public WebSocketClientHandshaker07(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, false);
    }

    WebSocketClientHandshaker07(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl) {
        this(webSocketURL, version, subprotocol, allowExtensions, customHeaders, maxFramePayloadLength, performMasking, allowMaskMismatch, forceCloseTimeoutMillis, absoluteUpgradeUrl, true);
    }

    WebSocketClientHandshaker07(URI webSocketURL, WebSocketVersion version, String subprotocol, boolean allowExtensions, HttpHeaders customHeaders, int maxFramePayloadLength, boolean performMasking, boolean allowMaskMismatch, long forceCloseTimeoutMillis, boolean absoluteUpgradeUrl, boolean generateOriginHeader) {
        super(webSocketURL, version, subprotocol, customHeaders, maxFramePayloadLength, forceCloseTimeoutMillis, absoluteUpgradeUrl, generateOriginHeader);
        this.allowExtensions = allowExtensions;
        this.performMasking = performMasking;
        this.allowMaskMismatch = allowMaskMismatch;
    }

    @Override
    protected FullHttpRequest newHandshakeRequest() {
        String expectedSubprotocol;
        URI wsURL = this.uri();
        byte[] nonce = WebSocketUtil.randomBytes(16);
        String key2 = WebSocketUtil.base64(nonce);
        String acceptSeed = key2 + MAGIC_GUID;
        byte[] sha1 = WebSocketUtil.sha1(acceptSeed.getBytes(CharsetUtil.US_ASCII));
        this.expectedChallengeResponseString = WebSocketUtil.base64(sha1);
        if (logger.isDebugEnabled()) {
            logger.debug("WebSocket version 07 client handshake key: {}, expected response: {}", (Object)key2, (Object)this.expectedChallengeResponseString);
        }
        DefaultFullHttpRequest request2 = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, this.upgradeUrl(wsURL), Unpooled.EMPTY_BUFFER);
        HttpHeaders headers2 = request2.headers();
        if (this.customHeaders != null) {
            headers2.add(this.customHeaders);
            if (!headers2.contains(HttpHeaderNames.HOST)) {
                headers2.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker07.websocketHostValue(wsURL));
            }
        } else {
            headers2.set((CharSequence)HttpHeaderNames.HOST, (Object)WebSocketClientHandshaker07.websocketHostValue(wsURL));
        }
        headers2.set((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET).set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE).set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY, (Object)key2);
        if (this.generateOriginHeader && !headers2.contains(HttpHeaderNames.SEC_WEBSOCKET_ORIGIN)) {
            headers2.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_ORIGIN, (Object)WebSocketClientHandshaker07.websocketOriginValue(wsURL));
        }
        if ((expectedSubprotocol = this.expectedSubprotocol()) != null && !expectedSubprotocol.isEmpty()) {
            headers2.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)expectedSubprotocol);
        }
        headers2.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (Object)this.version().toAsciiString());
        return request2;
    }

    @Override
    protected void verify(FullHttpResponse response2) {
        HttpResponseStatus status = response2.status();
        if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals(status)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response getStatus: " + status, response2);
        }
        HttpHeaders headers2 = response2.headers();
        String upgrade = headers2.get(HttpHeaderNames.UPGRADE);
        if (!HttpHeaderValues.WEBSOCKET.contentEqualsIgnoreCase(upgrade)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response upgrade: " + upgrade, response2);
        }
        if (!headers2.containsValue(HttpHeaderNames.CONNECTION, HttpHeaderValues.UPGRADE, true)) {
            throw new WebSocketClientHandshakeException("Invalid handshake response connection: " + headers2.get(HttpHeaderNames.CONNECTION), response2);
        }
        String accept = headers2.get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT);
        if (accept == null || !accept.equals(this.expectedChallengeResponseString)) {
            throw new WebSocketClientHandshakeException(String.format("Invalid challenge. Actual: %s. Expected: %s", accept, this.expectedChallengeResponseString), response2);
        }
    }

    @Override
    protected WebSocketFrameDecoder newWebsocketDecoder() {
        return new WebSocket07FrameDecoder(false, this.allowExtensions, this.maxFramePayloadLength(), this.allowMaskMismatch);
    }

    @Override
    protected WebSocketFrameEncoder newWebSocketEncoder() {
        return new WebSocket07FrameEncoder(this.performMasking);
    }

    @Override
    public WebSocketClientHandshaker07 setForceCloseTimeoutMillis(long forceCloseTimeoutMillis) {
        super.setForceCloseTimeoutMillis(forceCloseTimeoutMillis);
        return this;
    }
}

