/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.server.application.PipelineCall;
import io.ktor.server.netty.NettyApplicationRequest;
import io.ktor.server.netty.NettyApplicationRequestCookies;
import io.ktor.server.netty.http2.Http2LocalConnectionPoint;
import io.ktor.server.netty.http2.HttpFrameAdapterKt;
import io.ktor.server.request.RequestCookies;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteReadChannel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Headers;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.ActorKt;
import kotlinx.coroutines.channels.ActorScope;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rR\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u000b\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0019\u001a\u00020\u00148TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0006\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u0012\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010#\u001a\u00020\"8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u001a\u0010(\u001a\u00020'8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2ApplicationRequest;", "Lio/ktor/server/netty/NettyApplicationRequest;", "Lio/ktor/server/application/PipelineCall;", "call", "Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "Lio/netty/channel/ChannelHandlerContext;", "context", "Lio/netty/handler/codec/http2/Http2Headers;", "nettyHeaders", "Lio/ktor/utils/io/ByteChannel;", "contentByteChannel", "<init>", "(Lio/ktor/server/application/PipelineCall;Lkotlin/coroutines/CoroutineContext;Lio/netty/channel/ChannelHandlerContext;Lio/netty/handler/codec/http2/Http2Headers;Lio/ktor/utils/io/ByteChannel;)V", "Lio/netty/handler/codec/http2/Http2Headers;", "getNettyHeaders", "()Lio/netty/handler/codec/http2/Http2Headers;", "Lio/ktor/utils/io/ByteChannel;", "getContentByteChannel", "()Lio/ktor/utils/io/ByteChannel;", "Lio/ktor/http/Headers;", "engineHeaders$delegate", "Lkotlin/Lazy;", "getEngineHeaders", "()Lio/ktor/http/Headers;", "engineHeaders", "Lkotlinx/coroutines/channels/SendChannel;", "Lio/netty/handler/codec/http2/Http2DataFrame;", "contentActor", "Lkotlinx/coroutines/channels/SendChannel;", "getContentActor", "()Lkotlinx/coroutines/channels/SendChannel;", "getContentActor$annotations", "()V", "Lio/ktor/server/netty/http2/Http2LocalConnectionPoint;", "local", "Lio/ktor/server/netty/http2/Http2LocalConnectionPoint;", "getLocal", "()Lio/ktor/server/netty/http2/Http2LocalConnectionPoint;", "Lio/ktor/server/request/RequestCookies;", "cookies", "Lio/ktor/server/request/RequestCookies;", "getCookies", "()Lio/ktor/server/request/RequestCookies;", "ktor-server-netty"})
@SourceDebugExtension(value={"SMAP\nNettyHttp2ApplicationRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NettyHttp2ApplicationRequest.kt\nio/ktor/server/netty/http2/NettyHttp2ApplicationRequest\n+ 2 Headers.kt\nio/ktor/http/Headers$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n23#2:65\n1863#3,2:66\n*S KotlinDebug\n*F\n+ 1 NettyHttp2ApplicationRequest.kt\nio/ktor/server/netty/http2/NettyHttp2ApplicationRequest\n*L\n36#1:65\n37#1:66,2\n*E\n"})
public final class NettyHttp2ApplicationRequest
extends NettyApplicationRequest {
    @NotNull
    private final Http2Headers nettyHeaders;
    @NotNull
    private final ByteChannel contentByteChannel;
    @NotNull
    private final Lazy engineHeaders$delegate;
    @NotNull
    private final SendChannel<Http2DataFrame> contentActor;
    @NotNull
    private final Http2LocalConnectionPoint local;
    @NotNull
    private final RequestCookies cookies;

    public NettyHttp2ApplicationRequest(@NotNull PipelineCall call, @NotNull CoroutineContext coroutineContext, @NotNull ChannelHandlerContext context, @NotNull Http2Headers nettyHeaders, @NotNull ByteChannel contentByteChannel) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(coroutineContext, "coroutineContext");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(nettyHeaders, "nettyHeaders");
        Intrinsics.checkNotNullParameter(contentByteChannel, "contentByteChannel");
        ByteReadChannel byteReadChannel = contentByteChannel;
        CharSequence charSequence = (CharSequence)nettyHeaders.get(":path");
        if (charSequence == null || (charSequence = ((Object)charSequence).toString()) == null) {
            charSequence = "/";
        }
        super(call, coroutineContext, context, byteReadChannel, (String)charSequence, true);
        this.nettyHeaders = nettyHeaders;
        this.contentByteChannel = contentByteChannel;
        this.engineHeaders$delegate = LazyKt.lazy(() -> NettyHttp2ApplicationRequest.engineHeaders_delegate$lambda$2(this));
        this.contentActor = ActorKt.actor$default(this, Dispatchers.getUnconfined(), Integer.MAX_VALUE, null, null, new Function2<ActorScope<Http2DataFrame>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ NettyHttp2ApplicationRequest this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        ActorScope $this$actor = (ActorScope)this.L$0;
                        this.label = 1;
                        Object object3 = HttpFrameAdapterKt.http2frameLoop($this$actor, this.this$0.getContentByteChannel(), this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<ActorScope<Http2DataFrame>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(ActorScope<Http2DataFrame> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 12, null);
        SocketAddress socketAddress = context.channel().localAddress();
        InetSocketAddress inetSocketAddress = socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null;
        socketAddress = context.channel().remoteAddress();
        this.local = new Http2LocalConnectionPoint(this.nettyHeaders, inetSocketAddress, socketAddress instanceof InetSocketAddress ? (InetSocketAddress)socketAddress : null);
        this.cookies = new NettyApplicationRequestCookies(this);
    }

    public /* synthetic */ NettyHttp2ApplicationRequest(PipelineCall pipelineCall, CoroutineContext coroutineContext, ChannelHandlerContext channelHandlerContext, Http2Headers http2Headers, ByteChannel byteChannel, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 0x10) != 0) {
            byteChannel = new ByteChannel(false, 1, null);
        }
        this(pipelineCall, coroutineContext, channelHandlerContext, http2Headers, byteChannel);
    }

    @NotNull
    public final Http2Headers getNettyHeaders() {
        return this.nettyHeaders;
    }

    @NotNull
    public final ByteChannel getContentByteChannel() {
        return this.contentByteChannel;
    }

    @Override
    @NotNull
    protected Headers getEngineHeaders() {
        Lazy lazy = this.engineHeaders$delegate;
        return (Headers)lazy.getValue();
    }

    @NotNull
    public final SendChannel<Http2DataFrame> getContentActor() {
        return this.contentActor;
    }

    public static /* synthetic */ void getContentActor$annotations() {
    }

    @Override
    @NotNull
    public Http2LocalConnectionPoint getLocal() {
        return this.local;
    }

    @Override
    @NotNull
    public RequestCookies getCookies() {
        return this.cookies;
    }

    private static final Headers engineHeaders_delegate$lambda$2(NettyHttp2ApplicationRequest this$0) {
        HeadersBuilder headersBuilder;
        Headers.Companion this_$iv = Headers.Companion;
        boolean $i$f$build = false;
        HeadersBuilder $this$engineHeaders_delegate_u24lambda_u242_u24lambda_u241 = headersBuilder = new HeadersBuilder(0, 1, null);
        boolean bl = false;
        Iterable $this$forEach$iv = this$0.nettyHeaders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull(entry);
            CharSequence name = (CharSequence)entry.getKey();
            CharSequence value = (CharSequence)entry.getValue();
            Intrinsics.checkNotNull(name);
            if (!(name.length() > 0) || name.charAt(0) == ':') continue;
            $this$engineHeaders_delegate_u24lambda_u242_u24lambda_u241.append(((Object)name).toString(), ((Object)value).toString());
        }
        return headersBuilder.build();
    }
}

