/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.tags.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.nemonotfound.nemos.tags.helper.ItemReplacementMaps;
import com.nemonotfound.nemos.tags.interfaces.CustomBucketPickup;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PowderSnowBlock.class})
public class PowderSnowBlockMixin
implements CustomBucketPickup {
    @ModifyExpressionValue(method={"pickupBlock"}, at={@At(value="FIELD", target="Lnet/minecraft/world/item/Items;POWDER_SNOW_BUCKET:Lnet/minecraft/world/item/Item;")})
    private Item getItem(Item original, @Local(argsOnly=true) LivingEntity entity) {
        if (entity == null) {
            return original;
        }
        Item mainHandItem = entity.getMainHandItem().getItem();
        Item offHandItem = entity.getOffhandItem().getItem();
        if (ItemReplacementMaps.EMPTY_BUCKET_TO_POWDER_SNOW_BUCKET.containsKey(mainHandItem)) {
            return ItemReplacementMaps.EMPTY_BUCKET_TO_POWDER_SNOW_BUCKET.get(mainHandItem);
        }
        if (ItemReplacementMaps.EMPTY_BUCKET_TO_POWDER_SNOW_BUCKET.containsKey(offHandItem)) {
            return ItemReplacementMaps.EMPTY_BUCKET_TO_POWDER_SNOW_BUCKET.get(offHandItem);
        }
        return original;
    }

    @Override
    public ItemStack nemosTags$pickupBlock(Item bucket, ServerLevel levelAccessor, BlockPos blockpos, BlockState blockstate) {
        levelAccessor.setBlock(blockpos, Blocks.AIR.defaultBlockState(), 11);
        if (!levelAccessor.isClientSide()) {
            levelAccessor.levelEvent(2001, blockpos, Block.getId((BlockState)blockstate));
        }
        if (!ItemReplacementMaps.EMPTY_BUCKET_TO_POWDER_SNOW_BUCKET.containsKey(bucket)) {
            return new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET);
        }
        return new ItemStack((ItemLike)ItemReplacementMaps.EMPTY_BUCKET_TO_POWDER_SNOW_BUCKET.get(bucket));
    }
}

