/*
 * Decompiled with CFR 0.152.
 */
package com.playymcmc007.levelclear;

import com.playymcmc007.levelclear.LevelClearState;
import com.playymcmc007.levelclear.config.LevelClearConfig;
import java.io.File;
import java.io.IOException;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_7923;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelClearMod
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LevelClearMod.class);
    private static LevelClearConfig config;
    private long lastMessageTime = 0L;

    public void onInitialize() {
        AutoConfig.register(LevelClearConfig.class, Toml4jConfigSerializer::new);
        config = (LevelClearConfig)AutoConfig.getConfigHolder(LevelClearConfig.class).getConfig();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            LevelClearState state = LevelClearState.getServerState(server);
            for (class_3222 player : server.method_3760().method_14571()) {
                class_1799 offhandStack;
                boolean hasTriggerItem = false;
                for (class_1799 stack : player.method_31548().field_7547) {
                    if (!this.isTriggerItem(stack)) continue;
                    hasTriggerItem = true;
                    break;
                }
                if (!hasTriggerItem && this.isTriggerItem(offhandStack = (class_1799)player.method_31548().field_7544.getFirst())) {
                    hasTriggerItem = true;
                }
                if (!hasTriggerItem || state.getTriggeredPlayers().contains(player.method_5477().getString())) continue;
                state.setTriggered(true);
                state.addTriggeredPlayer(player.method_5477().getString());
            }
            block2: for (class_3222 player : server.method_3760().method_14571()) {
                class_2985 tracker = player.method_14236();
                for (String advancementId : LevelClearMod.config.triggerAdvancements) {
                    String[] parts = advancementId.split(":");
                    if (parts.length != 2) continue;
                    class_2960 identifier = class_2960.method_60655((String)parts[0], (String)parts[1]);
                    class_8779 advancement = server.method_3851().method_12896(identifier);
                    if (advancement == null || !tracker.method_12882(advancement).method_740()) continue;
                    if (state.getTriggeredPlayers().contains(player.method_5477().getString())) continue block2;
                    state.setTriggered(true);
                    state.addTriggeredPlayer(player.method_5477().getString());
                    continue block2;
                }
            }
            if (state.isTriggered()) {
                this.triggerLevelClear(server);
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            block11: {
                LevelClearState state = LevelClearState.getServerState(server);
                if (state.isTriggered() && LevelClearMod.config.destroySaveOnExit) {
                    boolean meetMinPlayers;
                    boolean bl = meetMinPlayers = state.getTriggeredPlayers().size() >= LevelClearMod.config.minPlayersToDestroySave;
                    if (meetMinPlayers) {
                        if (LevelClearMod.config.showMultiLanguageLogs) {
                            LOGGER.info("[EN] All triggering players have gone offline. Shutting down the server and deleting the world...");
                            LOGGER.info("[ZH] \u6240\u6709\u89e6\u53d1\u73a9\u5bb6\u5df2\u79bb\u7ebf\uff0c\u6b63\u5728\u5173\u95ed\u670d\u52a1\u5668\u5e76\u5220\u9664\u5b58\u6863...");
                        } else {
                            LOGGER.info("All triggering players have gone offline. Shutting down the server and deleting the world...");
                        }
                        try {
                            boolean success = this.deleteWorldWithRetry(server, LevelClearMod.config.deleteWorldRetryAttempts);
                            if (success) break block11;
                            if (LevelClearMod.config.showMultiLanguageLogs) {
                                LOGGER.error("[EN] Failed to delete the world. Please check the world folder manually.");
                                LOGGER.error("[ZH] \u5b58\u6863\u5220\u9664\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u68c0\u67e5\u5b58\u6863\u6587\u4ef6\u5939\u3002");
                                break block11;
                            }
                            LOGGER.error("Failed to delete the world. Please check the world folder manually.");
                        }
                        catch (Exception e) {
                            if (LevelClearMod.config.showMultiLanguageLogs) {
                                LOGGER.error("[EN] An error occurred while shutting down the server: {}", (Object)e.getMessage());
                                LOGGER.error("[ZH] \u5173\u95ed\u670d\u52a1\u5668\u65f6\u53d1\u751f\u9519\u8bef: {}", (Object)e.getMessage());
                                break block11;
                            }
                            LOGGER.error("An error occurred while shutting down the server: {}", (Object)e.getMessage());
                        }
                    } else if (LevelClearMod.config.showMultiLanguageLogs) {
                        LOGGER.info("[EN] Not enough triggering players. Skipping world deletion.");
                        LOGGER.info("[ZH] \u89e6\u53d1\u73a9\u5bb6\u6570\u91cf\u4e0d\u8db3\uff0c\u8df3\u8fc7\u5b58\u6863\u5220\u9664\u3002");
                    } else {
                        LOGGER.info("Not enough triggering players. Skipping world deletion.");
                    }
                }
            }
        });
    }

    private boolean isTriggerItem(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        return LevelClearMod.config.triggerItems.contains(itemId.toString());
    }

    private void triggerLevelClear(MinecraftServer server) {
        LevelClearState state = LevelClearState.getServerState(server);
        state.setTriggered(true);
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMessageTime >= (long)LevelClearMod.config.messageCooldown) {
            String allPlayerNames = state.getTriggeredPlayers().isEmpty() ? "\u672a\u77e5\u73a9\u5bb6" : String.join((CharSequence)"\u3001", state.getTriggeredPlayers());
            String message = LevelClearMod.config.chatMessage.isEmpty() ? class_2561.method_43469((String)"levelclear.message", (Object[])new Object[]{allPlayerNames}).getString() : LevelClearMod.config.chatMessage.replace("<player>", allPlayerNames);
            for (class_3222 player : server.method_3760().method_14571()) {
                player.method_7353(class_2561.method_30163((String)message), false);
            }
            this.lastMessageTime = currentTime;
        }
        block1: for (String playerName : state.getTriggeredPlayers()) {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (!player.method_5477().getString().equals(playerName)) continue;
                player.method_7336(class_1934.field_9219);
                continue block1;
            }
        }
    }

    private boolean deleteWorldWithRetry(MinecraftServer server, int remainingAttempts) {
        File worldSaveDir = server.method_27050(class_5218.field_24188).toFile();
        String worldFolderName = worldSaveDir.getAbsolutePath();
        File worldFolder = new File(worldFolderName);
        if (!worldFolder.exists()) {
            if (LevelClearMod.config.showMultiLanguageLogs) {
                LOGGER.error("[EN] World folder does not exist: {}", (Object)worldFolder.getAbsolutePath());
                LOGGER.error("[ZH] \u5b58\u6863\u6587\u4ef6\u5939\u4e0d\u5b58\u5728: {}", (Object)worldFolder.getAbsolutePath());
            } else {
                LOGGER.error("World folder does not exist: {}", (Object)worldFolder.getAbsolutePath());
            }
            return false;
        }
        try {
            this.deleteFolder(worldFolder);
            if (LevelClearMod.config.showMultiLanguageLogs) {
                LOGGER.info("[EN] World deleted: {}", (Object)worldFolder.getAbsolutePath());
                LOGGER.info("[ZH] \u5b58\u6863\u5df2\u5220\u9664: {}", (Object)worldFolder.getAbsolutePath());
            } else {
                LOGGER.info("World deleted: {}", (Object)worldFolder.getAbsolutePath());
            }
            return true;
        }
        catch (IOException e) {
            if (remainingAttempts > 0) {
                double retryDelaySeconds = (double)LevelClearMod.config.retryDelayMillis / 1000.0;
                String retryDelayDescription = String.format("%.3f", retryDelaySeconds).replaceAll("\\.?0+$", "");
                if (LevelClearMod.config.showMultiLanguageLogs) {
                    LOGGER.error("[EN] Failed to delete world. Remaining attempts: {}, retrying in {} seconds...", (Object)remainingAttempts, (Object)retryDelayDescription);
                    LOGGER.error("[ZH] \u5220\u9664\u5b58\u6863\u5931\u8d25\uff0c\u5269\u4f59\u91cd\u8bd5\u6b21\u6570: {}\uff0c{}\u79d2\u540e\u91cd\u8bd5...", (Object)remainingAttempts, (Object)retryDelayDescription);
                } else {
                    LOGGER.error("Failed to delete world. Remaining attempts: {}, retrying in {} seconds...", (Object)remainingAttempts, (Object)retryDelayDescription);
                }
                server.method_5385(() -> {
                    try {
                        Thread.sleep(LevelClearMod.config.retryDelayMillis);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.deleteWorldWithRetry(server, remainingAttempts - 1);
                    return null;
                });
            } else if (LevelClearMod.config.showMultiLanguageLogs) {
                LOGGER.error("[EN] Failed to delete world: {}", (Object)e.getMessage());
                LOGGER.error("[ZH] \u5b58\u6863\u5220\u9664\u5931\u8d25: {}", (Object)e.getMessage());
            } else {
                LOGGER.error("Failed to delete world: {}", (Object)e.getMessage());
            }
            return false;
        }
    }

    private void deleteFolder(File folder) throws IOException {
        File[] files;
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File file : files) {
                this.deleteFolder(file);
            }
        }
        if (!folder.delete()) {
            throw new IOException("Failed to delete: " + folder.getAbsolutePath());
        }
    }
}

