/*
 * Decompiled with CFR 0.152.
 */
package com.fireball.crispywafermod.entity;

import com.fireball.crispywafermod.entity.ModEntities;
import com.fireball.crispywafermod.item.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3857;
import net.minecraft.class_3966;

public class FireBallEntity
extends class_3857 {
    private static final List<class_2248> BREAKABLE_BLOCKS = new ArrayList<class_2248>();

    public FireBallEntity(class_1299<? extends class_3857> entityType, class_1937 world) {
        super(entityType, world);
    }

    public FireBallEntity(class_1937 world, class_1657 player) {
        super(ModEntities.FIREBALL, (class_1309)player, world);
        class_243 playerPos = player.method_19538();
        double eyeHeight = player.method_5751();
        class_243 lookVec = player.method_5720();
        double spawnDistance = 0.5;
        double spawnX = playerPos.field_1352 + lookVec.field_1352 * spawnDistance;
        double spawnY = playerPos.field_1351 + eyeHeight + lookVec.field_1351 * spawnDistance;
        double spawnZ = playerPos.field_1350 + lookVec.field_1350 * spawnDistance;
        this.method_5814(spawnX, spawnY, spawnZ);
        double speed = 2.0;
        this.method_18800(lookVec.field_1352 * speed, lookVec.field_1351 * speed, lookVec.field_1350 * speed);
        this.method_7432((class_1297)player);
    }

    protected class_1792 method_16942() {
        return ModItems.FIRE_BALL;
    }

    public void method_5773() {
        class_243 currentVelocity = this.method_18798();
        super.method_5773();
        if (!this.method_5740()) {
            this.method_5875(true);
        }
        if (currentVelocity.method_1033() < 4.0) {
            class_243 normalized = currentVelocity.method_1029();
            double newSpeed = currentVelocity.method_1033() * 1.05;
            this.method_18800(normalized.field_1352 * newSpeed, normalized.field_1351 * newSpeed, normalized.field_1350 * newSpeed);
        }
        this.checkFallingEntityCollisions();
        if (this.field_6012 >= 600 && !this.method_37908().method_8608()) {
            this.method_31472();
        }
    }

    private void checkFallingEntityCollisions() {
        List nearbyEntities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014(0.5));
        for (class_1297 entity : nearbyEntities) {
            if (!(entity.method_18798().field_1351 < -0.1) || !(entity instanceof class_1309) || !entity.method_5829().method_994(this.method_5829())) continue;
            this.explodeOnEntityCollision(entity);
            break;
        }
    }

    private void explodeOnEntityCollision(class_1297 entity) {
        if (!this.method_37908().method_8608()) {
            this.createCustomExplosion();
            this.applyUpwardForceToEntity(entity);
            this.applyCustomKnockback();
            this.method_31472();
        }
    }

    private void applyUpwardForceToEntity(class_1297 entity) {
        class_243 upwardForce = new class_243(0.0, 2.0, 0.0);
        entity.method_18799(entity.method_18798().method_1019(upwardForce));
        entity.field_6037 = true;
        if (entity instanceof class_1309) {
            class_1282 damageSource = this.method_48923().method_48811((class_1297)this, this.method_24921());
            ((class_1309)entity).method_5643(damageSource, 0.0f);
        }
    }

    protected void method_7488(class_239 hitResult) {
        class_3966 entityHitResult;
        if (hitResult.method_17783() == class_239.class_240.field_1331 && (entityHitResult = (class_3966)hitResult).method_17782() instanceof FireBallEntity) {
            return;
        }
        super.method_7488(hitResult);
        if (!this.method_37908().method_8608()) {
            this.createCustomExplosion();
            this.applyCustomKnockback();
            this.method_31472();
        }
    }

    private void createCustomExplosion() {
        class_2338 centerPos = new class_2338((int)this.method_23317(), (int)this.method_23318(), (int)this.method_23321());
        int explosionRadius = 1;
        for (int x = -explosionRadius; x <= explosionRadius + 5; ++x) {
            block1: for (int y = -explosionRadius; y <= explosionRadius + 5; ++y) {
                for (int z = -explosionRadius; z <= explosionRadius + 5; ++z) {
                    class_2338 currentPos = centerPos.method_10069(x, y, z);
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (!(distance <= (double)explosionRadius)) continue;
                    class_2680 blockState = this.method_37908().method_8320(currentPos);
                    if (!this.canBreakBlock(blockState.method_26204())) continue block1;
                    if (!(this.method_37908().field_9229.method_43057() < 0.7f)) continue;
                    this.method_37908().method_22352(currentPos, true);
                }
            }
        }
        this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 1.0f, false, class_1937.class_7867.field_40891);
    }

    private boolean canBreakBlock(class_2248 block) {
        return BREAKABLE_BLOCKS.contains(block);
    }

    private void applyCustomKnockback() {
        for (class_1297 entity : this.method_37908().method_8335((class_1297)this, this.method_5829().method_1014(3.0))) {
            if (!((double)entity.method_5739((class_1297)this) <= 3.0) || !(entity instanceof class_1309)) continue;
            class_243 explosionDir = entity.method_19538().method_1020(this.method_19538()).method_1029();
            double upwardY = Math.max(explosionDir.field_1351, 0.2);
            class_243 upwardDir = new class_243(explosionDir.field_1352, upwardY, explosionDir.field_1350).method_1029();
            float knockbackPower = 2.5f;
            class_243 velocity = new class_243(upwardDir.field_1352 * (double)knockbackPower, upwardDir.field_1351 * (double)knockbackPower + 1.2, upwardDir.field_1350 * (double)knockbackPower);
            entity.method_18799(velocity);
            entity.field_6037 = true;
            class_1282 damageSource = this.method_48923().method_48811((class_1297)this, this.method_24921());
            ((class_1309)entity).method_5643(damageSource, 0.0f);
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        if (entity instanceof FireBallEntity) {
            return;
        }
        if (entity instanceof class_1309) {
            class_1282 damageSource = this.method_48923().method_48811((class_1297)this, this.method_24921());
            ((class_1309)entity).method_5643(damageSource, 0.0f);
        }
        super.method_7454(entityHitResult);
    }

    static {
        BREAKABLE_BLOCKS.add(class_2246.field_10446);
        BREAKABLE_BLOCKS.add(class_2246.field_10095);
        BREAKABLE_BLOCKS.add(class_2246.field_10215);
        BREAKABLE_BLOCKS.add(class_2246.field_10294);
        BREAKABLE_BLOCKS.add(class_2246.field_10490);
        BREAKABLE_BLOCKS.add(class_2246.field_10028);
        BREAKABLE_BLOCKS.add(class_2246.field_10459);
        BREAKABLE_BLOCKS.add(class_2246.field_10423);
        BREAKABLE_BLOCKS.add(class_2246.field_10222);
        BREAKABLE_BLOCKS.add(class_2246.field_10619);
        BREAKABLE_BLOCKS.add(class_2246.field_10259);
        BREAKABLE_BLOCKS.add(class_2246.field_10514);
        BREAKABLE_BLOCKS.add(class_2246.field_10113);
        BREAKABLE_BLOCKS.add(class_2246.field_10170);
        BREAKABLE_BLOCKS.add(class_2246.field_10314);
        BREAKABLE_BLOCKS.add(class_2246.field_10146);
        BREAKABLE_BLOCKS.add(class_2246.field_10161);
        BREAKABLE_BLOCKS.add(class_2246.field_9975);
        BREAKABLE_BLOCKS.add(class_2246.field_10148);
        BREAKABLE_BLOCKS.add(class_2246.field_10334);
        BREAKABLE_BLOCKS.add(class_2246.field_10218);
        BREAKABLE_BLOCKS.add(class_2246.field_10075);
        BREAKABLE_BLOCKS.add(class_2246.field_10471);
        BREAKABLE_BLOCKS.add(class_2246.field_10340);
        BREAKABLE_BLOCKS.add(class_2246.field_10445);
        BREAKABLE_BLOCKS.add(class_2246.field_10102);
        BREAKABLE_BLOCKS.add(class_2246.field_9979);
        BREAKABLE_BLOCKS.add(class_2246.field_10255);
        BREAKABLE_BLOCKS.add(class_2246.field_10566);
        BREAKABLE_BLOCKS.add(class_2246.field_10219);
    }
}

