/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.compat;

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@EmiEntrypoint
public class EmiCompat
implements EmiPlugin {
    private static final EmiRecipeCategory PORTABLE_REPAIR = new EmiRecipeCategory(SSO.id("portable_repair"), (EmiRenderable)EmiStack.of((ItemLike)ModItems.WHETSTONE));

    public void register(EmiRegistry emiRegistry) {
        emiRegistry.addCategory(PORTABLE_REPAIR);
        emiRegistry.addRecipe((EmiRecipe)new EmiAnvilRecipe(EmiStack.of((ItemLike)ModItems.WHETSTONE), (EmiIngredient)EmiStack.of((ItemLike)Items.QUARTZ), EmiPort.id((String)"emi", (String)("/anvil/repairing/material/" + EmiUtil.subId((Item)ModItems.WHETSTONE) + "/" + EmiUtil.subId((Item)Items.QUARTZ)))));
        int[] counter = new int[]{1};
        ModUtil.additionalRepairables.forEach((key, value) -> {
            for (ItemStack stack : key.getItems()) {
                emiRegistry.addRecipe((EmiRecipe)new EmiAnvilRecipe(EmiStack.of((ItemStack)stack), EmiIngredient.of((Ingredient)value), EmiPort.id((String)"emi", (String)("/anvil/repairing/material/" + EmiUtil.subId((Item)stack.getItem()) + "/" + counter[0]))));
                counter[0] = counter[0] + 1;
            }
        });
        emiRegistry.removeRecipes(SSO.id("enchantment_upgrade_smithing"));
        emiRegistry.removeRecipes(SSO.id("pinnacle_enchantment_smithing"));
        EmiIngredient input = EmiIngredient.of((Ingredient)Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)SSO.id("enchantment_upgradeable"))));
        counter[0] = 1;
        input.getEmiStacks().forEach(emiStack -> {
            emiRegistry.addRecipe((EmiRecipe)new EmiEnchantmentUpgradeSmithingRecipe(SSO.id("/enchantment_upgrade_" + counter[0]), emiStack.getItemStack()));
            counter[0] = counter[0] + 1;
        });
        EmiIngredient input1 = EmiIngredient.of((Ingredient)Ingredient.of((TagKey)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"enchantable/durability"))));
        counter[0] = 1;
        input1.getEmiStacks().forEach(emiStack -> {
            emiRegistry.addRecipe((EmiRecipe)new EmiPinnacleEnchantmentSmithingRecipe(SSO.id("/pinnacle_enchantment_" + counter[0]), emiStack.getItemStack()));
            counter[0] = counter[0] + 1;
        });
        counter[0] = 1;
        for (Item item : EmiPort.getItemRegistry()) {
            if (item instanceof ArmorItem) {
                ArmorItem ai = (ArmorItem)item;
                if (ai.getMaterial() == null || ((ArmorMaterial)ai.getMaterial().value()).repairIngredient().get() == null || ((Ingredient)((ArmorMaterial)ai.getMaterial().value()).repairIngredient().get()).isEmpty()) continue;
                this.addWhetstoneRepairRecipe(emiRegistry, (Item)ai, (Ingredient)((ArmorMaterial)ai.getMaterial().value()).repairIngredient().get(), counter[0]);
                counter[0] = counter[0] + 1;
                continue;
            }
            if (item instanceof TieredItem) {
                TieredItem ti = (TieredItem)item;
                if (ti.getTier().getRepairIngredient() == null || ti.getTier().getRepairIngredient().isEmpty()) continue;
                this.addWhetstoneRepairRecipe(emiRegistry, (Item)ti, ti.getTier().getRepairIngredient(), counter[0]);
                counter[0] = counter[0] + 1;
                continue;
            }
            ModUtil.additionalRepairables.forEach((key, value) -> {
                for (ItemStack stack : key.getItems()) {
                    if (!item.equals(stack.getItem())) continue;
                    this.addWhetstoneRepairRecipe(emiRegistry, stack.getItem(), (Ingredient)value, counter[0]);
                    counter[0] = counter[0] + 1;
                }
            });
        }
    }

    private void addWhetstoneRepairRecipe(EmiRegistry emiRegistry, Item item, Ingredient repairIngredient, int counter) {
        emiRegistry.addRecipe((EmiRecipe)new EmiPortableRepairRecipe(SSO.id("/portable_repair_" + counter), EmiStack.of((ItemLike)item), EmiIngredient.of((Ingredient)repairIngredient)));
    }

    private static class EmiPortableRepairRecipe
    implements EmiRecipe {
        protected final ResourceLocation id;
        protected final EmiStack input;
        protected final EmiStack whetstone;
        protected final EmiIngredient repairIngredient;
        private final int uniq1;
        private final int uniq2;
        private boolean enchanted;

        private EmiPortableRepairRecipe(ResourceLocation id, EmiStack input, EmiIngredient repairIngredient) {
            this.id = id;
            this.input = input;
            this.whetstone = EmiStack.of((ItemLike)ModItems.WHETSTONE);
            this.repairIngredient = repairIngredient;
            this.uniq1 = EmiUtil.RANDOM.nextInt();
            this.uniq2 = EmiUtil.RANDOM.nextInt();
            this.enchanted = false;
        }

        public EmiRecipeCategory getCategory() {
            return PORTABLE_REPAIR;
        }

        @Nullable
        public ResourceLocation getId() {
            return this.id;
        }

        public List<EmiIngredient> getInputs() {
            return List.of(this.input, this.whetstone, this.repairIngredient);
        }

        public List<EmiStack> getOutputs() {
            return List.of(this.input);
        }

        public int getDisplayWidth() {
            return 118;
        }

        public int getDisplayHeight() {
            return 54;
        }

        public void addWidgets(WidgetHolder widgetHolder) {
            widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 60, 18);
            widgetHolder.addTexture(EmiTexture.SHAPELESS, 97, 0);
            HashSet enchantmentSet = new HashSet();
            EmiPort.getEnchantmentRegistry().holders().forEach(e -> {
                if (((Enchantment)e.value()).canEnchant(this.input.getItemStack()) && ModUtil.enchantmentEligible((Holder<Enchantment>)e)) {
                    enchantmentSet.add(e);
                }
            });
            List enchantmentInstances = EnchantmentHelper.selectEnchantment((RandomSource)RandomSource.create(), (ItemStack)this.input.getItemStack(), (int)30, enchantmentSet.stream());
            widgetHolder.addGeneratedSlot(r -> this.getInput((Random)r, false, enchantmentInstances), this.uniq1, 0, 0);
            widgetHolder.addGeneratedSlot(r -> this.getWhetstone((Random)r, enchantmentInstances), this.uniq2, 18, 0);
            widgetHolder.addSlot(this.repairIngredient, 36, 0);
            for (int i = 3; i < 9; ++i) {
                widgetHolder.addSlot((EmiIngredient)EmiStack.of((ItemStack)ItemStack.EMPTY), i % 3 * 18, i / 3 * 18);
            }
            widgetHolder.addGeneratedSlot(r -> this.getInput((Random)r, true, enchantmentInstances), this.uniq1, 92, 14).large(true).recipeContext((EmiRecipe)this);
        }

        private EmiStack getInput(Random r, boolean repaired, List<EnchantmentInstance> enchantments) {
            this.enchanted = r.nextBoolean();
            ItemStack stack = this.input.getItemStack().copy();
            if (!enchantments.isEmpty() && this.enchanted) {
                enchantments.forEach(enchantment -> stack.enchant(enchantment.enchantment, enchantment.level));
            }
            if (stack.getMaxDamage() > 0) {
                int d = r.nextInt(stack.getMaxDamage());
                if (repaired && (d -= Math.round((float)stack.getMaxDamage() / (float)ModUtil.determineUnitCost(stack))) <= 0) {
                    return EmiStack.of((ItemStack)stack);
                }
                stack.setDamageValue(d);
            }
            return EmiStack.of((ItemStack)stack);
        }

        private EmiIngredient getWhetstone(Random r, List<EnchantmentInstance> enchantments) {
            ItemStack stack = this.whetstone.getItemStack().copy();
            if (!enchantments.isEmpty() && this.enchanted) {
                enchantments.forEach(enchantment -> stack.enchant(enchantment.enchantment, enchantment.level));
            }
            if (stack.getMaxDamage() > 0) {
                int d = r.nextInt(stack.getMaxDamage());
                stack.setDamageValue(d);
            }
            return this.enchanted ? EmiStack.of((ItemStack)stack) : EmiIngredient.of(List.of(EmiStack.of((ItemStack)stack), EmiStack.of((ItemLike)Items.FLINT)));
        }
    }

    private static class EmiPinnacleEnchantmentSmithingRecipe
    implements EmiRecipe {
        protected final ResourceLocation id;
        protected final EmiStack template;
        protected final EmiStack input;
        protected final EmiIngredient addition;
        private final int uniq;

        private EmiPinnacleEnchantmentSmithingRecipe(ResourceLocation id, ItemStack input) {
            this.id = id;
            this.template = EmiStack.of((ItemLike)ModItems.PINNACLE_ENCHANTMENT_SMITHING_TEMPLATE);
            this.input = EmiStack.of((ItemStack)input);
            this.addition = EmiStack.of((ItemLike)Items.ECHO_SHARD);
            this.uniq = EmiUtil.RANDOM.nextInt();
        }

        public EmiRecipeCategory getCategory() {
            return VanillaEmiRecipeCategories.SMITHING;
        }

        @Nullable
        public ResourceLocation getId() {
            return this.id;
        }

        public List<EmiIngredient> getInputs() {
            return List.of(this.template, this.input, this.addition);
        }

        public List<EmiStack> getOutputs() {
            return List.of(this.input);
        }

        public int getDisplayWidth() {
            return 112;
        }

        public int getDisplayHeight() {
            return 18;
        }

        public void addWidgets(WidgetHolder widgetHolder) {
            ItemStack inputStack = this.input.getItemStack().copy();
            ArrayList allEnchantments = new ArrayList();
            EmiPort.getEnchantmentRegistry().holders().forEach(ref -> {
                if (((Enchantment)ref.value()).canEnchant(inputStack) && ModUtil.enchantmentEligible((Holder<Enchantment>)ref)) {
                    allEnchantments.add(new EnchantmentInstance((Holder)ref, ((Enchantment)ref.value()).getMaxLevel()));
                }
            });
            Collections.shuffle(allEnchantments);
            ArrayList filteredEnchantments = new ArrayList();
            allEnchantments.forEach(ei -> {
                if (!((HolderSet.Named)EmiPort.getEnchantmentRegistry().getTag(EnchantmentTags.CURSE).orElseThrow()).contains(ei.enchantment) && filteredEnchantments.stream().allMatch(e1 -> Enchantment.areCompatible((Holder)ei.enchantment, (Holder)e1.enchantment))) {
                    filteredEnchantments.add(new EnchantmentInstance(ei.enchantment, ei.level));
                }
            });
            ItemEnchantments.Mutable finalEnchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
            filteredEnchantments.forEach(ei -> finalEnchantments.set(ei.enchantment, ei.level));
            inputStack.set(DataComponents.ENCHANTMENTS, (Object)finalEnchantments.toImmutable());
            widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
            widgetHolder.addSlot((EmiIngredient)this.template, 0, 0);
            widgetHolder.addSlot((EmiIngredient)EmiStack.of((ItemStack)inputStack), 18, 0);
            widgetHolder.addSlot(this.addition, 36, 0);
            widgetHolder.addGeneratedSlot(r -> this.getOutput(inputStack, finalEnchantments.toImmutable(), (Random)r), this.uniq, 94, 0).recipeContext((EmiRecipe)this);
        }

        private EmiStack getOutput(ItemStack stack, ItemEnchantments enchantments, Random r) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)stack.getItem().getName(stack).copy().withStyle(ChatFormatting.getByName((String)((String)SSO.CONFIG.pinnacleEnchantment.pinnacleItemNameColor.get()).replace(" ", "_").toUpperCase())));
            stack.set(DataComponents.ENCHANTMENTS, (Object)enchantments);
            ArrayList<EnchantmentInstance> possibleUpgrades = new ArrayList<EnchantmentInstance>(enchantments.entrySet().stream().map(entry -> new EnchantmentInstance((Holder)entry.getKey(), entry.getIntValue())).toList());
            possibleUpgrades.removeIf(ei -> ((Enchantment)ei.enchantment.value()).getMaxLevel() == 1);
            EnchantmentInstance toUpgrade = (EnchantmentInstance)possibleUpgrades.get(r.nextInt(possibleUpgrades.size()));
            EnchantmentHelper.updateEnchantments((ItemStack)stack, mutable -> mutable.upgrade(toUpgrade.enchantment, toUpgrade.level + 1));
            return EmiStack.of((ItemStack)stack);
        }
    }

    private static class EmiEnchantmentUpgradeSmithingRecipe
    implements EmiRecipe {
        protected final ResourceLocation id;
        protected final EmiStack template;
        protected final EmiStack input;
        protected final EmiIngredient addition;
        private final int uniq;

        private EmiEnchantmentUpgradeSmithingRecipe(ResourceLocation id, ItemStack input) {
            this.id = id;
            this.template = EmiStack.of((ItemLike)ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE);
            this.input = EmiStack.of((ItemStack)input);
            this.addition = EmiStack.of((ItemLike)Items.LAPIS_LAZULI);
            this.uniq = EmiUtil.RANDOM.nextInt();
        }

        public EmiRecipeCategory getCategory() {
            return VanillaEmiRecipeCategories.SMITHING;
        }

        @Nullable
        public ResourceLocation getId() {
            return this.id;
        }

        public List<EmiIngredient> getInputs() {
            return List.of(this.template, this.input, this.addition);
        }

        public List<EmiStack> getOutputs() {
            return List.of(this.input);
        }

        public int getDisplayWidth() {
            return 112;
        }

        public int getDisplayHeight() {
            return 18;
        }

        public void addWidgets(WidgetHolder widgetHolder) {
            ItemEnchantments.Mutable finalEnchantments;
            ItemEnchantments.Mutable enchantments;
            widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
            boolean fallback = false;
            ItemStack inputStack = this.input.getItemStack().copy();
            HashSet enchantmentSet = new HashSet();
            EmiPort.getEnchantmentRegistry().holders().forEach(e -> {
                if ((inputStack.is(Items.ENCHANTED_BOOK) || inputStack.is(ModItems.WHETSTONE) || ((Enchantment)e.value()).canEnchant(inputStack)) && ModUtil.enchantmentEligible((Holder<Enchantment>)e)) {
                    enchantmentSet.add(e);
                }
            });
            List enchantmentInstances = EnchantmentHelper.selectEnchantment((RandomSource)RandomSource.create(), (ItemStack)inputStack, (int)30, enchantmentSet.stream());
            if (enchantmentInstances.isEmpty()) {
                enchantmentInstances = EnchantmentHelper.selectEnchantment((RandomSource)RandomSource.create(), (ItemStack)new ItemStack((ItemLike)Items.BOOK), (int)30, enchantmentSet.stream());
                fallback = true;
            }
            if (!enchantmentInstances.isEmpty()) {
                if (fallback) {
                    enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                    if (inputStack.is(Items.ENCHANTED_BOOK) || inputStack.is(ModItems.WHETSTONE)) {
                        enchantmentInstances.forEach(enchantment -> {
                            int maxLevel = ((Enchantment)enchantment.enchantment.value()).getMaxLevel();
                            if (maxLevel > 1) {
                                if (enchantment.level == maxLevel) {
                                    enchantments.set(enchantment.enchantment, enchantment.level - 1);
                                } else {
                                    enchantments.set(enchantment.enchantment, enchantment.level);
                                }
                            }
                        });
                        if (enchantments.toImmutable().isEmpty()) {
                            enchantments.set((Holder)EmiPort.getEnchantmentRegistry().getHolderOrThrow(Enchantments.UNBREAKING), 2);
                            inputStack.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments.toImmutable());
                        }
                        inputStack.set(DataComponents.STORED_ENCHANTMENTS, (Object)enchantments.toImmutable());
                    } else {
                        enchantments.set((Holder)EmiPort.getEnchantmentRegistry().getHolderOrThrow(Enchantments.UNBREAKING), 2);
                        inputStack.set(DataComponents.ENCHANTMENTS, (Object)enchantments.toImmutable());
                    }
                } else {
                    enchantmentInstances.forEach(enchantment -> {
                        int maxLevel = ((Enchantment)enchantment.enchantment.value()).getMaxLevel();
                        if (maxLevel > 1) {
                            if (enchantment.level == maxLevel) {
                                inputStack.enchant(enchantment.enchantment, enchantment.level - 1);
                            } else {
                                inputStack.enchant(enchantment.enchantment, enchantment.level);
                            }
                        }
                    });
                    if (!inputStack.isEnchanted()) {
                        inputStack.enchant((Holder)EmiPort.getEnchantmentRegistry().getHolderOrThrow(Enchantments.UNBREAKING), 2);
                    }
                }
            }
            if ((finalEnchantments = (enchantments = inputStack.is(Items.ENCHANTED_BOOK) || inputStack.is(ModItems.WHETSTONE) ? (ItemEnchantments)inputStack.get(DataComponents.STORED_ENCHANTMENTS) : (ItemEnchantments)inputStack.get(DataComponents.ENCHANTMENTS))) != null) {
                int count = EmiUtil.RANDOM.nextInt(finalEnchantments.size()) + 1;
                this.addition.setAmount((long)count);
                widgetHolder.addSlot((EmiIngredient)this.template, 0, 0);
                widgetHolder.addSlot((EmiIngredient)EmiStack.of((ItemStack)inputStack), 18, 0);
                widgetHolder.addSlot(this.addition, 36, 0);
                widgetHolder.addGeneratedSlot(arg_0 -> this.lambda$addWidgets$3(inputStack, (ItemEnchantments)finalEnchantments, count, arg_0), this.uniq, 94, 0).recipeContext((EmiRecipe)this);
            }
        }

        private EmiStack getOutput(ItemStack stack, ItemEnchantments enchantments, int index) {
            Minecraft mc = Minecraft.getInstance();
            ArrayList enchantmentNames = new ArrayList();
            Consumer<Component> consumer = enchantmentNames::add;
            enchantments.addToTooltip(Item.TooltipContext.of((Level)mc.level), consumer, (TooltipFlag)TooltipFlag.NORMAL);
            block0: for (int i = 0; i < enchantmentNames.size(); ++i) {
                if (i + 1 != index) continue;
                Component enchantmentName = (Component)enchantmentNames.get(i);
                for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                    if (!Enchantment.getFullname((Holder)((Holder)entry.getKey()), (int)entry.getIntValue()).equals((Object)enchantmentName)) continue;
                    EnchantmentHelper.updateEnchantments((ItemStack)stack, mutable -> mutable.upgrade((Holder)entry.getKey(), entry.getIntValue() + 1));
                    continue block0;
                }
            }
            return EmiStack.of((ItemStack)stack);
        }

        private /* synthetic */ EmiIngredient lambda$addWidgets$3(ItemStack inputStack, ItemEnchantments finalEnchantments, int count, Random r) {
            return this.getOutput(inputStack, finalEnchantments, count);
        }
    }
}

