/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.items;

import me.pajic.simple_smithing_overhaul.SSO;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.NotNull;

public class WhetstoneItem
extends Item {
    public WhetstoneItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isValidRepairItem(@NotNull ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Items.QUARTZ);
    }

    public boolean isEnabled(@NotNull FeatureFlagSet enabledFeatures) {
        return (Boolean)SSO.CONFIG.whetstone.enableWhetstone.get();
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return !((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty();
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        MutableComponent name = super.getName(stack).copy();
        int damage = stack.getDamageValue();
        if (damage == 2 || damage == 3) {
            name = Component.translatable((String)"item.simple_smithing_overhaul.chipped", (Object[])new Object[]{name});
        } else if (damage == 4 || damage == 5) {
            name = Component.translatable((String)"item.simple_smithing_overhaul.damaged", (Object[])new Object[]{name});
        }
        return this.isFoil(stack) ? name.withStyle(ChatFormatting.YELLOW) : name;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return stack.getCount() == 1 && ((ItemEnchantments)stack.getOrDefault(DataComponents.STORED_ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).isEmpty();
    }

    public int getEnchantmentValue() {
        return 22;
    }
}

