/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_smithing_overhaul.blocks.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={AnvilBlock.class})
public abstract class AnvilBlockMixin
extends FallingBlock {
    @Shadow
    @Final
    public static DirectionProperty FACING;

    public AnvilBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @ModifyReturnValue(method={"damage"}, at={@At(value="RETURN")})
    private static BlockState brokenState(BlockState original, @Local(argsOnly=true) BlockState state) {
        return original == null ? (BlockState)ModBlocks.BROKEN_ANVIL.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))) : original;
    }

    @WrapMethod(method={"useWithoutItem"})
    private InteractionResult noMenuIfBroken(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult, Operation<InteractionResult> original) {
        return state.is(ModBlocks.BROKEN_ANVIL) ? InteractionResult.FAIL : (InteractionResult)original.call(new Object[]{state, level, pos, player, hitResult});
    }

    @NotNull
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.IRON_BLOCK) && !state.is(Blocks.ANVIL)) {
            BlockState updatedState = state.is(ModBlocks.BROKEN_ANVIL) ? (BlockState)Blocks.DAMAGED_ANVIL.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))) : (state.is(Blocks.DAMAGED_ANVIL) ? (BlockState)Blocks.CHIPPED_ANVIL.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))) : (BlockState)Blocks.ANVIL.defaultBlockState().setValue((Property)FACING, (Comparable)((Direction)state.getValue((Property)FACING))));
            level.setBlock(pos, updatedState, 2);
            level.playSound(null, pos, SoundEvents.ANVIL_PLACE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
            stack.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

