/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import java.util.function.BiConsumer;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.config.DestructionPreventMode;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements DataComponentHolder {
    @Unique
    private final ItemStack thisStack = (ItemStack)this;

    @Shadow
    @Nullable
    public abstract <T> T set(DataComponentType<? super T> var1, @Nullable T var2);

    @Shadow
    @Nullable
    public abstract <T> T remove(DataComponentType<? extends T> var1);

    @Shadow
    public abstract int getMaxDamage();

    @Shadow
    public abstract boolean isEnchanted();

    @Shadow
    public abstract boolean isDamageableItem();

    @Shadow
    public abstract boolean is(Item var1);

    @Shadow
    public abstract int getDamageValue();

    @Inject(method={"set(Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Ljava/lang/Object;"}, at={@At(value="HEAD")})
    private <T> void manageBrokenState(DataComponentType<? super T> component, T value, CallbackInfoReturnable<T> cir) {
        if (component == DataComponents.DAMAGE && this.isDamageableItem()) {
            if ((Integer)value < this.getMaxDamage()) {
                this.remove(ModDataComponents.BROKEN);
            } else {
                switch ((DestructionPreventMode)((Object)SSO.CONFIG.streamlinedRepairs.preventItemDestruction.get())) {
                    case ALL: {
                        this.set(ModDataComponents.BROKEN, true);
                        break;
                    }
                    case ENCHANTED: {
                        if (!this.isEnchanted()) break;
                        this.set(ModDataComponents.BROKEN, true);
                    }
                }
            }
        }
    }

    @WrapWithCondition(method={"hurtAndBreak(ILnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")})
    private boolean preventDestruction(ItemStack instance, int decrement) {
        return !ModUtil.isBroken(instance);
    }

    @WrapMethod(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V"})
    private void noAttributesIfBroken(EquipmentSlot equipmentSLot, BiConsumer<Holder<Attribute>, AttributeModifier> action, Operation<Void> original) {
        if (!ModUtil.isBroken(this.thisStack)) {
            original.call(new Object[]{equipmentSLot, action});
        }
    }

    @WrapMethod(method={"forEachModifier(Lnet/minecraft/world/entity/EquipmentSlotGroup;Ljava/util/function/BiConsumer;)V"})
    private void noAttributesIfBroken(EquipmentSlotGroup slotGroup, BiConsumer<Holder<Attribute>, AttributeModifier> action, Operation<Void> original) {
        if (!ModUtil.isBroken(this.thisStack)) {
            original.call(new Object[]{slotGroup, action});
        }
    }

    @ModifyReturnValue(method={"getHoverName"}, at={@At(value="RETURN")})
    private Component changeNameIfBroken(Component original) {
        if (ModUtil.isBroken(this.thisStack) || this.is(Items.ELYTRA) && this.getMaxDamage() - this.getDamageValue() == 1) {
            MutableComponent name = Component.translatable((String)"item.simple_smithing_overhaul.broken", (Object[])new Object[]{original});
            name.withStyle(ChatFormatting.RED);
            return name;
        }
        return original;
    }
}

