/*
 * Decompiled with CFR 0.152.
 */
package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.criterion.ModCriteria;
import me.pajic.simple_smithing_overhaul.recipe.UpgradeRecipeHandler;
import me.pajic.simple_smithing_overhaul.util.CostAccess;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingMenu.class})
public abstract class SmithingMenuMixin
extends ItemCombinerMenu {
    @Shadow
    @Final
    public Level level;

    public SmithingMenuMixin(@Nullable MenuType<?> menuType, int i, Inventory inventory, ContainerLevelAccess containerLevelAccess) {
        super(menuType, i, inventory, containerLevelAccess);
    }

    @Inject(method={"createResult"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;enabledFeatures()Lnet/minecraft/world/flag/FeatureFlagSet;")}, cancellable=true)
    private void handleSmithingUpgradeRecipes(CallbackInfo ci, @Local LocalRef<ItemStack> stack) {
        UpgradeRecipeHandler.handleRecipe(ci, stack, (NonNullList<Slot>)this.slots, this.resultSlots, this.level, this);
    }

    @ModifyReturnValue(method={"mayPickup"}, at={@At(value="RETURN")})
    private boolean modifyMayPickup(boolean original) {
        if (((Boolean)SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get()).booleanValue() && ((Boolean)SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get()).booleanValue() && (ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe((NonNullList<Slot>)this.slots) || ModUtil.isEnchantedItemUpgradeRecipe((NonNullList<Slot>)this.slots))) {
            return (this.player.hasInfiniteMaterials() || this.player.experienceLevel >= ((CostAccess)((Object)this)).sso$getCost()) && ((CostAccess)((Object)this)).sso$getCost() > 0;
        }
        if (((Boolean)SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get()).booleanValue() && ModUtil.isPinnacleEnchantmentRecipe((NonNullList<Slot>)this.slots)) {
            return (this.player.hasInfiniteMaterials() || this.player.experienceLevel >= ((CostAccess)((Object)this)).sso$getCost()) && ((CostAccess)((Object)this)).sso$getCost() > 0;
        }
        return original;
    }

    @Inject(method={"onTake"}, at={@At(value="HEAD")})
    private void hookOnTake(Player player, ItemStack itemStack, CallbackInfo ci) {
        ServerPlayer p;
        if (((Boolean)SSO.CONFIG.enchantmentUpgrading.enableEnchantmentUpgrading.get()).booleanValue() && ((Boolean)SSO.CONFIG.enchantmentUpgrading.upgradingHasExperienceCost.get()).booleanValue() && (ModUtil.isEnchantedBookOrWhetstoneUpgradeRecipe((NonNullList<Slot>)this.slots) || ModUtil.isEnchantedItemUpgradeRecipe((NonNullList<Slot>)this.slots))) {
            if (!player.getAbilities().instabuild) {
                ModUtil.payXpCost(player, ((CostAccess)((Object)this)).sso$getCost());
            }
            if (player instanceof ServerPlayer) {
                p = (ServerPlayer)player;
                ModCriteria.APPLY_ENCHANTMENT_UPGRADE.trigger(p);
            }
        }
        if (((Boolean)SSO.CONFIG.pinnacleEnchantment.enablePinnacleEnchantment.get()).booleanValue() && ModUtil.isPinnacleEnchantmentRecipe((NonNullList<Slot>)this.slots)) {
            if (!player.getAbilities().instabuild) {
                ModUtil.payXpCost(player, ((CostAccess)((Object)this)).sso$getCost());
            }
            if (player instanceof ServerPlayer) {
                p = (ServerPlayer)player;
                ModCriteria.APPLY_PINNACLE_ENCHANTMENT.trigger(p);
                if ((Integer)itemStack.getOrDefault(ModDataComponents.PINNACLE_COUNT, (Object)0) == 10) {
                    ModCriteria.BAD_RNG.trigger(p);
                }
            }
        }
    }
}

