package me.pajic.simple_smithing_overhaul.compat;

//? if 1.21.1 {

import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_124;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;
//? if neoforge
/*import dev.emi.emi.api.EmiEntrypoint;*/

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;

// EMI compatibility plugin for Simple Smithing Overhaul

//? if neoforge
/*@EmiEntrypoint*/
public class EmiCompat implements EmiPlugin {

    private static final EmiRecipeCategory PORTABLE_REPAIR = new EmiRecipeCategory(
            SSO.id("portable_repair"),
            EmiStack.of(ModItems.WHETSTONE)
    );

    @SuppressWarnings("ConstantConditions")
    @Override
    public void register(EmiRegistry emiRegistry) {
        // Add anvil repair recipe for whetstones
        emiRegistry.addCategory(PORTABLE_REPAIR);

        emiRegistry.addRecipe(new EmiAnvilRecipe(
                EmiStack.of(ModItems.WHETSTONE),
                EmiStack.of(class_1802.field_8155),
                EmiPort.id(
                        "emi",
                        "/" + "anvil/repairing/material" +
                                "/" + EmiUtil.subId(ModItems.WHETSTONE) +
                                "/" + EmiUtil.subId(class_1802.field_8155)
                )
        ));

        // Add anvil repair recipes for every item made repairable by the mod
        final int[] counter = {1};
        ModUtil.additionalRepairables.forEach((key, value) -> {
            for (class_1799 stack : key.method_8105()) {
                emiRegistry.addRecipe(new EmiAnvilRecipe(
                        EmiStack.of(stack),
                        EmiIngredient.of(value),
                        EmiPort.id(
                                "emi",
                                "/" + "anvil/repairing/material" +
                                        "/" + EmiUtil.subId(stack.method_7909()) +
                                        "/" + counter[0]
                        )
                ));
                counter[0]++;
            }
        });

        // Hide the "base" enchantment upgrading smithing recipe.
        // The behavior of this recipe is completely changed in the mod code so it's irrelevant.
        emiRegistry.removeRecipes(SSO.id("enchantment_upgrade_smithing"));
        // Same for pinnacle enchantment smithing recipe
        emiRegistry.removeRecipes(SSO.id("pinnacle_enchantment_smithing"));

        // Add enchantment upgrade smithing recipes for every enchantable item.
        // See the enchantment_upgradable tag for the list of included items.
        EmiIngredient input = EmiIngredient.of(class_1856.method_8106(class_6862.method_40092(
                class_7924.field_41197,
                SSO.id("enchantment_upgradeable")
        )));
        counter[0] = 1;
        input.getEmiStacks().forEach(emiStack -> {
            emiRegistry.addRecipe(new EmiEnchantmentUpgradeSmithingRecipe(
                    SSO.id("/enchantment_upgrade_" + counter[0]),
                    emiStack.getItemStack()
            ));
            counter[0]++;
        });
        // Same for pinnacle enchantment smithing recipes
        EmiIngredient input1 = EmiIngredient.of(class_1856.method_8106(class_6862.method_40092(
                class_7924.field_41197,
                class_2960.method_60656("enchantable/durability")
        )));
        counter[0] = 1;
        input1.getEmiStacks().forEach(emiStack -> {
            emiRegistry.addRecipe(new EmiPinnacleEnchantmentSmithingRecipe(
                    SSO.id("/pinnacle_enchantment_" + counter[0]),
                    emiStack.getItemStack()
            ));
            counter[0]++;
        });

        // Add whetstone repair crafting recipes for every repairable item
        counter[0] = 1;
        for (class_1792 item : EmiPort.getItemRegistry()) {
            // Copypasta from EMI's VanillaPlugin
            if (item instanceof class_1738 ai) {
                if (ai.method_7686() != null && ai.method_7686().comp_349().comp_2301().get() != null && !ai.method_7686().comp_349().comp_2301().get().method_8103()) {
                    addWhetstoneRepairRecipe(emiRegistry, ai, ai.method_7686().comp_349().comp_2301().get(), counter[0]);
                    counter[0]++;
                }
            } else if (item instanceof class_1831 ti) {
                if (ti.method_8022().method_8023() != null && !ti.method_8022().method_8023().method_8103()) {
                    addWhetstoneRepairRecipe(emiRegistry, ti, ti.method_8022().method_8023(), counter[0]);
                    counter[0]++;
                }
            // Mod repairables
            } else {
                ModUtil.additionalRepairables.forEach((key, value) -> {
                    for (class_1799 stack : key.method_8105()) {
                        if (item.equals(stack.method_7909())) {
                            addWhetstoneRepairRecipe(emiRegistry, stack.method_7909(), value, counter[0]);
                            counter[0]++;
                        }
                    }
                });
            }
        }
    }

    private void addWhetstoneRepairRecipe(EmiRegistry emiRegistry, class_1792 item, class_1856 repairIngredient, int counter) {
        emiRegistry.addRecipe(new EmiPortableRepairRecipe(
                SSO.id("/portable_repair_" + counter),
                EmiStack.of(item),
                EmiIngredient.of(repairIngredient)
        ));
    }

    private static class EmiPortableRepairRecipe implements EmiRecipe {
        protected final class_2960 id;
        protected final EmiStack input;
        protected final EmiStack whetstone;
        protected final EmiIngredient repairIngredient;
        private final int uniq1;
        private final int uniq2;
        private boolean enchanted;

        private EmiPortableRepairRecipe(class_2960 id, EmiStack input, EmiIngredient repairIngredient) {
            this.id = id;
            this.input = input;
            this.whetstone = EmiStack.of(ModItems.WHETSTONE);
            this.repairIngredient = repairIngredient;
            this.uniq1 = EmiUtil.RANDOM.nextInt();
            this.uniq2 = EmiUtil.RANDOM.nextInt();
            this.enchanted = false;
        }

        @Override
        public EmiRecipeCategory getCategory() {
            return PORTABLE_REPAIR;
        }

        @Override
        public @Nullable class_2960 getId() {
            return this.id;
        }

        @Override
        public List<EmiIngredient> getInputs() {
            return List.of(this.input, this.whetstone, this.repairIngredient);
        }

        @Override
        public List<EmiStack> getOutputs() {
            return List.of(this.input);
        }

        @Override
        public int getDisplayWidth() {
            return 118;
        }

        @Override
        public int getDisplayHeight() {
            return 54;
        }

        @Override
        public void addWidgets(WidgetHolder widgetHolder) {
            widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 60, 18);
            widgetHolder.addTexture(EmiTexture.SHAPELESS, 97, 0);

            List<class_1889> enchantmentInstances;
            Set<class_6880<class_1887>> enchantmentSet = new HashSet<>();
            EmiPort.getEnchantmentRegistry().method_40270().forEach(e -> {
                if (e.comp_349().method_8192(this.input.getItemStack()) && ModUtil.enchantmentEligible(e)) enchantmentSet.add(e);
            });
            enchantmentInstances = class_1890.method_8230(class_5819.method_43047(), input.getItemStack(), 30, enchantmentSet.stream());

            widgetHolder.addGeneratedSlot(r -> this.getInput(r, false, enchantmentInstances), this.uniq1, 0, 0);
            widgetHolder.addGeneratedSlot(r -> this.getWhetstone(r, enchantmentInstances), this.uniq2, 18, 0);
            widgetHolder.addSlot(this.repairIngredient, 36 ,0);
            for(int i = 3; i < 9; ++i) {
                widgetHolder.addSlot(EmiStack.of(class_1799.field_8037), i % 3 * 18, i / 3 * 18);
            }

            widgetHolder.addGeneratedSlot(r -> this.getInput(r, true, enchantmentInstances), this.uniq1, 92, 14).large(true).recipeContext(this);
        }

        private EmiStack getInput(Random r, boolean repaired, List<class_1889> enchantments) {
            enchanted = r.nextBoolean();
            class_1799 stack = this.input.getItemStack().method_7972();
            if (!enchantments.isEmpty() && enchanted) {
                enchantments.forEach(enchantment -> stack.method_7978(enchantment.field_9093, enchantment.field_9094));
            }
            if (stack.method_7936() > 0) {
                int d = r.nextInt(stack.method_7936());
                if (repaired) {
                    d -= Math.round((float) stack.method_7936() / ModUtil.determineUnitCost(stack));
                    if (d <= 0) {
                        return EmiStack.of(stack);
                    }
                }
                stack.method_7974(d);
            }
            return EmiStack.of(stack);
        }

        private EmiIngredient getWhetstone(Random r, List<class_1889> enchantments) {
            class_1799 stack = this.whetstone.getItemStack().method_7972();
            if (!enchantments.isEmpty() && enchanted) {
                enchantments.forEach(enchantment -> stack.method_7978(enchantment.field_9093, enchantment.field_9094));
            }
            if (stack.method_7936() > 0) {
                int d = r.nextInt(stack.method_7936());
                stack.method_7974(d);
            }
            return enchanted ? EmiStack.of(stack) : EmiIngredient.of(List.of(EmiStack.of(stack), EmiStack.of(class_1802.field_8145)));
        }
    }

    private static class EmiEnchantmentUpgradeSmithingRecipe implements EmiRecipe {
        protected final class_2960 id;
        protected final EmiStack template;
        protected final EmiStack input;
        protected final EmiIngredient addition;
        private final int uniq;

        private EmiEnchantmentUpgradeSmithingRecipe(class_2960 id, class_1799 input) {
            this.id = id;
            this.template = EmiStack.of(ModItems.ENCHANTMENT_UPGRADE_SMITHING_TEMPLATE);
            this.input = EmiStack.of(input);
            this.addition = EmiStack.of(class_1802.field_8759);
            this.uniq = EmiUtil.RANDOM.nextInt();
        }

        @Override
        public EmiRecipeCategory getCategory() {
            return VanillaEmiRecipeCategories.SMITHING;
        }

        @Override
        public @Nullable class_2960 getId() {
            return this.id;
        }

        @Override
        public List<EmiIngredient> getInputs() {
            return List.of(this.template, this.input, this.addition);
        }

        @Override
        public List<EmiStack> getOutputs() {
            return List.of(this.input);
        }

        @Override
        public int getDisplayWidth() {
            return 112;
        }

        @Override
        public int getDisplayHeight() {
            return 18;
        }

        @Override
        public void addWidgets(WidgetHolder widgetHolder) {
            widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);

            boolean fallback = false;
            class_1799 inputStack = this.input.getItemStack().method_7972();
            List<class_1889> enchantmentInstances;
            Set<class_6880<class_1887>> enchantmentSet = new HashSet<>();
            EmiPort.getEnchantmentRegistry().method_40270().forEach(e -> {
                if (((inputStack.method_31574(class_1802.field_8598) || inputStack.method_31574(ModItems.WHETSTONE)) || e.comp_349().method_8192(inputStack)) && ModUtil.enchantmentEligible(e)) enchantmentSet.add(e);
            });
            enchantmentInstances = class_1890.method_8230(class_5819.method_43047(), inputStack, 30, enchantmentSet.stream());
            if (enchantmentInstances.isEmpty()) {
                enchantmentInstances = class_1890.method_8230(class_5819.method_43047(), new class_1799(class_1802.field_8529), 30, enchantmentSet.stream());
                fallback = true;
            }
            if (!enchantmentInstances.isEmpty()) {
                if (fallback){
                    class_9304.class_9305 enchantments = new class_9304.class_9305(class_9304.field_49385);
                    if (inputStack.method_31574(class_1802.field_8598) || inputStack.method_31574(ModItems.WHETSTONE)) {
                        enchantmentInstances.forEach(enchantment -> {
                            int maxLevel = enchantment.field_9093.comp_349().method_8183();
                            if (maxLevel > 1) {
                                if (enchantment.field_9094 == maxLevel)
                                    enchantments.method_57547(enchantment.field_9093, enchantment.field_9094 - 1);
                                else
                                    enchantments.method_57547(enchantment.field_9093, enchantment.field_9094);
                            }
                        });
                        if (enchantments.method_57549().method_57543()) {
                            enchantments.method_57547(EmiPort.getEnchantmentRegistry().method_40290(class_1893.field_9119), 2);
                            inputStack.method_57379(class_9334.field_49643, enchantments.method_57549());
                        }
                        inputStack.method_57379(class_9334.field_49643, enchantments.method_57549());
                    } else {
                        enchantments.method_57547(EmiPort.getEnchantmentRegistry().method_40290(class_1893.field_9119), 2);
                        inputStack.method_57379(class_9334.field_49633, enchantments.method_57549());
                    }
                } else {
                    enchantmentInstances.forEach(enchantment -> {
                        int maxLevel = enchantment.field_9093.comp_349().method_8183();
                        if (maxLevel > 1) {
                            if (enchantment.field_9094 == maxLevel)
                                inputStack.method_7978(enchantment.field_9093, enchantment.field_9094 - 1);
                            else
                                inputStack.method_7978(enchantment.field_9093, enchantment.field_9094);
                        }
                    });
                    if (!inputStack.method_7942()) {
                        inputStack.method_7978(EmiPort.getEnchantmentRegistry().method_40290(class_1893.field_9119), 2);
                    }
                }
            }

            class_9304 enchantments;
            if (inputStack.method_31574(class_1802.field_8598) || inputStack.method_31574(ModItems.WHETSTONE)) {
                enchantments = inputStack.method_57824(class_9334.field_49643);
            } else {
                enchantments = inputStack.method_57824(class_9334.field_49633);
            }
            class_9304 finalEnchantments = enchantments;
            if (finalEnchantments != null) {
                int count = EmiUtil.RANDOM.nextInt(finalEnchantments.method_57541()) + 1;
                this.addition.setAmount(count);
                widgetHolder.addSlot(this.template, 0, 0);
                widgetHolder.addSlot(EmiStack.of(inputStack), 18, 0);
                widgetHolder.addSlot(this.addition, 36, 0);
                widgetHolder.addGeneratedSlot(r -> this.getOutput(inputStack, finalEnchantments, count), this.uniq, 94, 0).recipeContext(this);
            }
        }

        private EmiStack getOutput(class_1799 stack, class_9304 enchantments, int index) {
            class_310 mc = class_310.method_1551();
            List<class_2561> enchantmentNames = new ArrayList<>();
            Consumer<class_2561> consumer = enchantmentNames::add;
            enchantments.method_57409(class_1792.class_9635.method_59528(mc.field_1687), consumer, class_1836.field_41070);
            for (int i = 0; i < enchantmentNames.size(); i++) {
                if (i + 1 == index) {
                    class_2561 enchantmentName = enchantmentNames.get(i);
                    for (Object2IntMap.Entry<class_6880<class_1887>> entry : enchantments.method_57539()) {
                        if (class_1887.method_8179(entry.getKey(), entry.getIntValue()).equals(enchantmentName)) {
                            class_1890.method_57531(stack, mutable ->
                                    mutable.method_57550(entry.getKey(), entry.getIntValue() + 1)
                            );
                            break;
                        }
                    }
                }
            }
            return EmiStack.of(stack);
        }
    }

    private static class EmiPinnacleEnchantmentSmithingRecipe implements EmiRecipe {
        protected final class_2960 id;
        protected final EmiStack template;
        protected final EmiStack input;
        protected final EmiIngredient addition;
        private final int uniq;

        private EmiPinnacleEnchantmentSmithingRecipe(class_2960 id, class_1799 input) {
            this.id = id;
            this.template = EmiStack.of(ModItems.PINNACLE_ENCHANTMENT_SMITHING_TEMPLATE);
            this.input = EmiStack.of(input);
            this.addition = EmiStack.of(class_1802.field_38746);
            this.uniq = EmiUtil.RANDOM.nextInt();
        }

        @Override
        public EmiRecipeCategory getCategory() {
            return VanillaEmiRecipeCategories.SMITHING;
        }

        @Override
        public @Nullable class_2960 getId() {
            return this.id;
        }

        @Override
        public List<EmiIngredient> getInputs() {
            return List.of(this.template, this.input, this.addition);
        }

        @Override
        public List<EmiStack> getOutputs() {
            return List.of(this.input);
        }

        @Override
        public int getDisplayWidth() {
            return 112;
        }

        @Override
        public int getDisplayHeight() {
            return 18;
        }

        @Override
        public void addWidgets(WidgetHolder widgetHolder) {
            class_1799 inputStack = this.input.getItemStack().method_7972();
            List<class_1889> allEnchantments = new ArrayList<>();
            EmiPort.getEnchantmentRegistry().method_40270().forEach(ref -> {
                if (ref.comp_349().method_8192(inputStack) && ModUtil.enchantmentEligible(ref))
                    allEnchantments.add(new class_1889(ref, ref.comp_349().method_8183()));
            });
            Collections.shuffle(allEnchantments);
            List<class_1889> filteredEnchantments = new ArrayList<>();
            allEnchantments.forEach(ei -> {
                if (
                        !EmiPort.getEnchantmentRegistry().method_40266(class_9636.field_51551).orElseThrow().method_40241(ei.field_9093) &&
                        filteredEnchantments.stream().allMatch(e1 -> class_1887.method_60033(ei.field_9093, e1.field_9093))
                ) {
                    filteredEnchantments.add(new class_1889(ei.field_9093, ei.field_9094));
                }
            });
            class_9304.class_9305 finalEnchantments = new class_9304.class_9305(class_9304.field_49385);
            filteredEnchantments.forEach(ei -> finalEnchantments.method_57547(ei.field_9093, ei.field_9094));
            inputStack.method_57379(class_9334.field_49633, finalEnchantments.method_57549());

            widgetHolder.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
            widgetHolder.addSlot(this.template, 0, 0);
            widgetHolder.addSlot(EmiStack.of(inputStack), 18, 0);
            widgetHolder.addSlot(this.addition, 36, 0);
            widgetHolder.addGeneratedSlot(r -> this.getOutput(inputStack, finalEnchantments.method_57549(), r), this.uniq, 94, 0).recipeContext(this);
        }

        private EmiStack getOutput(class_1799 stack, class_9304 enchantments, Random r) {
            stack.method_57379(class_9334.field_49631, stack.method_7909().method_7864(stack).method_27661().method_27692(class_124.method_533(SSO.CONFIG.pinnacleEnchantment.pinnacleItemNameColor.get().replace(" ", "_").toUpperCase())));
            stack.method_57379(class_9334.field_49633, enchantments);
            List<class_1889> possibleUpgrades = new ArrayList<>(enchantments.method_57539()
                    .stream().map(entry -> new class_1889(entry.getKey(), entry.getIntValue())).toList());
            possibleUpgrades.removeIf(ei -> ei.field_9093.comp_349().method_8183() == 1);
            class_1889 toUpgrade = possibleUpgrades.get(r.nextInt(possibleUpgrades.size()));
            class_1890.method_57531(stack, mutable ->
                    mutable.method_57550(toUpgrade.field_9093, toUpgrade.field_9094 + 1)
            );
            return EmiStack.of(stack);
        }
    }
}
//?}
