package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.moulberry.mixinconstraints.annotations.IfModLoaded;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.blocks.ModBlocks;
import me.pajic.simple_smithing_overhaul.criterion.ModCriteria;
import me.pajic.simple_smithing_overhaul.items.ModItems;
import me.pajic.simple_smithing_overhaul.util.ModDataComponents;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
//? if > 1.21.1
/*import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;*/

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@Mixin(value = class_1706.class, priority = 2000)
public abstract class AnvilMenuMixin extends class_4861 {

    //? if <= 1.21.1 {
    public AnvilMenuMixin(@Nullable class_3917<?> type, int containerId, class_1661 playerInventory, class_3914 access) {
        super(type, containerId, playerInventory, access);
    }
    //?} else {
    /*public AnvilMenuMixin(@Nullable MenuType<?> menuType, int containerId, Inventory inventory, ContainerLevelAccess access, ItemCombinerMenuSlotDefinition slotDefinition) {
        super(menuType, containerId, inventory, access, slotDefinition);
    }
    *///?}

    @Shadow /*? if fabric {*/private /*?} else {*//*public*//*?}*/ int repairItemCountCost;
    @Shadow @Final private class_3915 cost;

    @WrapMethod(method = "createResult")
    private void nonFunctionalIfBroken(Operation<Void> original) {
        Optional<Boolean> bl = field_22481.method_17395((level, blockPos) -> level.method_8320(blockPos).method_27852(ModBlocks.BROKEN_ANVIL));
        if (bl.isPresent() && !bl.get()) original.call();
    }

    @ModifyArg(
			//? if fabric
            method = "method_24922",
			//? if neoforge
			/*method = "lambda$onTake$2",*/
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/level/Level;levelEvent(ILnet/minecraft/core/BlockPos;I)V",
                    ordinal = 1
            ),
            index = 0
    )
    private static int breakSoundIfBroken(int original, @Local(ordinal = 1) class_2680 blockState2) {
        return blockState2.method_27852(ModBlocks.BROKEN_ANVIL) ? 1029 : original;
    }

    @ModifyExpressionValue(
			//? if fabric || (neoforge && 1.21.1)
			method = "createResult",
			//? if neoforge && > 1.21.1
			/*method = "createResultInternal",*/
            at = @At(
                    value = "INVOKE",
					//? if fabric {
                    target = "Lnet/minecraft/world/item/ItemStack;is(Lnet/minecraft/world/item/Item;)Z",
                    ordinal = 1
					//?} else {
					/*target = "Lnet/minecraft/world/item/ItemStack;supportsEnchantment(Lnet/minecraft/core/Holder;)Z"
					*///?}
            )
    )
    private boolean allowAddingEnchantmentsToWhetstone(boolean original, @Local(ordinal = 0) class_1799 itemStack) {
        if (SSO.CONFIG.whetstone.enableWhetstone.get()) {
            return original || itemStack.method_31574(ModItems.WHETSTONE);
        }
        return original;
    }

    @ModifyArg(
			//? if fabric || (neoforge && 1.21.1)
			method = "createResult",
			//? if neoforge && > 1.21.1
			/*method = "createResultInternal",*/
            at = @At(
                    value = "INVOKE",
                    target = "Ljava/lang/Math;min(II)I"),
            index = 1
    )
    private int modifyRepairUnitCost(int original, @Local(ordinal = 1) class_1799 itemStack) {
        return Math.round((float) itemStack.method_7936() / ModUtil.determineUnitCost(itemStack));
    }

	//? if fabric {
    @ModifyExpressionValue(
            method = "method_24922",
            at = @At(
                    value = "CONSTANT",
                    args = "floatValue=0.12F"
            )
    )
    private static float modifyDegradationChance(float original) {
        if (SSO.CONFIG.anvilImprovements.modifyDegradationChance.get()) {
            return SSO.CONFIG.anvilImprovements.degradationChance.get() / 100;
        }
        return original;
    }
	//?}

    @Inject(
            method = "onTake",
            at = @At("HEAD")
    )
    private void noXPCostIfUnenchanted(class_1657 player, class_1799 itemStack, CallbackInfo ci) {
        if (
				SSO.CONFIG.anvilImprovements.freeUnenchantedRepairs.get() &&
                !itemStack.method_7942() &&
                itemStack.method_57825(class_9334.field_49643, class_9304.field_49385).method_57543()
        ) {
            cost.method_17404(0);
        }
    }

    @SuppressWarnings("resource")
    @Inject(
            method = "onTake",
            at = @At("HEAD")
    )
    private void grantAdvancements(class_1657 player, class_1799 stack, CallbackInfo ci) {
        if (field_22479.method_5438(0).method_7919() < field_22480.method_5438(0).method_7919()) {
            if (player instanceof class_3222 p) ModCriteria.REPAIR_ITEM.trigger(p);
            int repairCount = stack.method_57825(ModDataComponents.REPAIR_COUNT, 0);
            if (player instanceof class_3222 p) {
                if (repairCount + 1 == 100) ModCriteria.ITEM_REPAIR_COUNT.trigger(p);
                if (repairCount + 1 == 1000) ModCriteria.ITEM_REPAIR_COUNT_BIG.trigger(p);
            }
            stack.method_57379(ModDataComponents.REPAIR_COUNT, repairCount + 1);
        }
        if (field_22480.method_5438(1).method_31574(class_1802.field_8598) && !field_22480.method_5438(0).method_31574(class_1802.field_8598)) {
            if (player instanceof class_3222 p) ModCriteria.ANVIL_ENCHANT_COMBINE.trigger(p);
        }
        if (field_22479.method_5438(0).method_31574(ModItems.WHETSTONE)) {
            Set<class_1889> allEnchantments = new HashSet<>();
            player.method_37908().method_30349().method_46762(class_7924.field_41265).method_42017().forEach(ref -> {
                if (ModUtil.enchantmentEligible(ref)) allEnchantments.add(new class_1889(ref, ref.comp_349().method_8183()));
            });
            Set<class_1889> whetstoneEnchantments = field_22479.method_5438(0).method_58657().method_57539()
                    .stream().map(entry -> new class_1889(entry.getKey(), entry.getIntValue()))
                    .collect(Collectors.toSet());
            if (whetstoneEnchantments.containsAll(allEnchantments) && player instanceof class_3222 p) ModCriteria.MAX_WHETSTONE.trigger(p);
        }
    }

    @ModifyArg(
			//? if fabric || (neoforge && 1.21.1)
			method = "createResult",
			//? if neoforge && > 1.21.1
			/*method = "createResultInternal",*/
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/Mth;clamp(JJJ)J"
            ),
            index = 0
    )
    private long modifyXPCost(long value, @Local long l, @Local(ordinal = 1) int j) {
        // deduct cost of rename from total cost if option is enabled
        if (SSO.CONFIG.anvilImprovements.freeRenames.get()) {
            value -= j;
        }
        // if cost ends up consisting of just prior work cost, ignore it
        if (value == l) {
            value = 0;
        }
        // if there is an "actual" cost, deduct prior work cost from total cost if option is enabled
        if (value != 0 && SSO.CONFIG.anvilImprovements.noPriorWorkCost.get()) {
            value -= l;
        }
        return value;
    }

    @IfModLoaded("taxfreelevels")
    @Inject(
			//? if fabric || (neoforge && 1.21.1)
			method = "createResult",
			//? if neoforge && > 1.21.1
			/*method = "createResultInternal",*/
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/ItemStack;isEmpty()Z",
                    ordinal = 2
            )
    )
    private void interceptRenameCostSet(CallbackInfo ci, @Local(ordinal = 0) int i, @Local(ordinal = 1) int j) {
        // tax free levels forcibly sets the rename cost to 1, this injects after it to revert the cost
        if (SSO.CONFIG.anvilImprovements.freeRenames.get() && j > 0 && j == i) {
            cost.method_17404(0);
        }
    }

    @ModifyExpressionValue(
            method = "mayPickup",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/inventory/DataSlot;get()I",
                    ordinal = 1
            )
    )
    private int allowTakingFreeRepairs(int original) {
        return original == 0 && repairItemCountCost >= 0 ? 1 : original;
    }

    @WrapOperation(
			//? if fabric || (neoforge && 1.21.1)
			method = "createResult",
			//? if neoforge && > 1.21.1
			/*method = "createResultInternal",*/
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/inventory/AnvilMenu;calculateIncreasedRepairCost(I)I"
            )
    )
    private int preventPriorWorkCostIncrease(int oldRepairCost, Operation<Integer> original) {
        if (SSO.CONFIG.anvilImprovements.noPriorWorkCost.get()) {
            return oldRepairCost;
        }
        if (
				SSO.CONFIG.anvilImprovements.noWorkCostIncreaseOnRepair.get() &&
                field_22480.method_5438(0).method_7963() &&
                //? if <= 1.21.1
                (ModUtil.hasAdditionalRepair(field_22480.method_5438(0), field_22480.method_5438(1)) || field_22480.method_5438(0).method_7909().method_7878(field_22480.method_5438(0), field_22480.method_5438(1)))
                //? if > 1.21.1 {
                /*inputSlots.getItem(0).has(DataComponents.REPAIRABLE) &&
                inputSlots.getItem(0).get(DataComponents.REPAIRABLE).isValidRepairItem(inputSlots.getItem(1))
                *///?}
        ) {
            return oldRepairCost;
        }
        else {
            return original.call(oldRepairCost);
        }
    }

    @ModifyExpressionValue(
			//? if fabric || (neoforge && 1.21.1)
			method = "createResult",
			//? if neoforge && > 1.21.1
			/*method = "createResultInternal",*/
            at = @At(
                    value = "CONSTANT",
                    args = "intValue=40"
            )
    )
    private int ignoreTooExpensive(int original) {
        if (SSO.CONFIG.anvilImprovements.noTooExpensive.get()) {
            return Integer.MAX_VALUE;
        }
        return original;
    }

    //? if <= 1.21.1 {
    @ModifyExpressionValue(
            method = "createResult",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/Item;isValidRepairItem(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/item/ItemStack;)Z"
            )
    )
    private boolean checkAdditionalRepair(boolean original) {
        return ModUtil.hasAdditionalRepair(field_22480.method_5438(0), field_22480.method_5438(1)) || original;
    }
    //?}
}
