package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import dev.kikugie.fletching_table.annotation.MixinEnvironment;
import me.pajic.simple_smithing_overhaul.SSO;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_471;
import net.minecraft.class_4894;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@MixinEnvironment(type = MixinEnvironment.Env.CLIENT)
@Mixin(class_471.class)
public abstract class AnvilScreenMixin extends class_4894<class_1706> {

    public AnvilScreenMixin(class_1706 menu, class_1661 playerInventory, class_2561 title, class_2960 menuResource) {
        super(menu, playerInventory, title, menuResource);
    }

    @WrapOperation(
            method = "renderLabels",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/inventory/AnvilMenu;getCost()I"
            )
    )
    private int noXPCostIfUnenchanted(class_1706 instance, Operation<Integer> original) {
        if (SSO.CONFIG.anvilImprovements.freeUnenchantedRepairs.get() &&
                !field_2797.method_7611(2).method_7677().method_7942() &&
                field_2797.method_7611(2).method_7677().method_57825(class_9334.field_49643, class_9304.field_49385).method_57543()
        ) {
            return 0;
        }
        return original.call(instance);
    }

    @ModifyExpressionValue(
            method = "renderLabels",
            at = @At(
                    value = "CONSTANT",
                    args = "intValue=40"
            )
    )
    private int ignoreTooExpensive(int original) {
        if (SSO.CONFIG.anvilImprovements.noTooExpensive.get()) {
            return Integer.MAX_VALUE;
        }
        return original;
    }
}
