package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_smithing_overhaul.SSO;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1914;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_9306;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;

@Mixin(class_3853.class_1648.class)
public class EnchantBookForEmeraldsMixin {

    @SuppressWarnings({"rawtypes", "OptionalUsedAsFieldOrParameterType"})
    @WrapOperation(
            method = "getOffer",
            at = @At(
                    value = "NEW",
                    target = "(Lnet/minecraft/world/item/trading/ItemCost;Ljava/util/Optional;Lnet/minecraft/world/item/ItemStack;IIF)Lnet/minecraft/world/item/trading/MerchantOffer;"
            )
    )
    private class_1914 limitTradeUses(class_9306 baseCostA, Optional costB, class_1799 result, int maxUses, int xp, float priceMultiplier, Operation<class_1914> original) {
        if (SSO.CONFIG.enchantmentLimits.limitBookTradeUses.get()) {
            return original.call(baseCostA, costB, result, SSO.CONFIG.enchantmentLimits.bookTradeUsesLimit.get(), xp, priceMultiplier);
        }
        else {
            return original.call(baseCostA, costB, result, maxUses, xp, priceMultiplier);
        }
    }

    @ModifyExpressionValue(
            method = "getOffer",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I"
            )
    )
    private int limitMaxEnchantmentLevel(int original, @Local class_6880<class_1887> enchantment, @Local(argsOnly = true) class_5819 randomSource) {
        int value = ModUtil.calculateNewEnchantmentLevel(enchantment.comp_349().method_8183(), randomSource, original);
        if (SSO.CONFIG.enchantmentLimits.limitBookTradeLevel.get() && value > SSO.CONFIG.enchantmentLimits.bookTradeLevelLimit.get()) {
            value = SSO.CONFIG.enchantmentLimits.bookTradeLevelLimit.get();
        }
        return value;
    }
}
