package me.pajic.simple_smithing_overhaul.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import me.pajic.simple_smithing_overhaul.util.ModUtil;
import net.minecraft.class_109;
import net.minecraft.class_1887;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_109.class)
public class EnchantRandomlyFunctionMixin {

    @ModifyExpressionValue(
            method = "enchantItem",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I"
            )
    )
    private static int modifyEnchantmentLevel(int original,
                                              @Local(argsOnly = true) class_6880<class_1887> enchantmentHolder,
                                              @Local(argsOnly = true) class_5819 randomSource
    ) {
        return ModUtil.calculateNewEnchantmentLevel(enchantmentHolder.comp_349().method_8183(), randomSource, original);
    }
}
